/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.trajstat.forms;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteothink.trajstat.trajectory.Location;

public class FrmStartLocations
extends JDialog {
    private boolean _isOK = false;
    private JButton jButton_Cancel;
    private JButton jButton_OK;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea_Locations;

    public FrmStartLocations(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/images/TrajStat_Logo.png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setIconImage(image);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea_Locations = new JTextArea();
        this.jButton_OK = new JButton();
        this.jButton_Cancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Start Locations");
        this.jLabel1.setText("Starting location (Lat Lon Height(m agl)):");
        this.jTextArea_Locations.setColumns(20);
        this.jTextArea_Locations.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea_Locations);
        this.jButton_OK.setText("OK");
        this.jButton_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmStartLocations.this.jButton_OKActionPerformed(evt);
            }
        });
        this.jButton_Cancel.setText("Cancel");
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmStartLocations.this.jButton_CancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 60, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(113, 113, 113).addComponent(this.jButton_OK, -2, 79, -2).addGap(32, 32, 32).addComponent(this.jButton_Cancel).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 291, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_OK).addComponent(this.jButton_Cancel)).addContainerGap()));
        this.pack();
    }

    private void jButton_OKActionPerformed(ActionEvent evt) {
        this._isOK = true;
        this.dispose();
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public void setLocations(List<Location> locations) {
        String locStr = locations.get(0).toString();
        if (locations.size() > 1) {
            for (int i = 1; i < locations.size(); ++i) {
                locStr = locStr + System.getProperty("line.separator") + locations.get(i).toString();
            }
        }
        this.jTextArea_Locations.setText(locStr);
    }

    public List<Location> getLocations() {
        String[] locs;
        ArrayList<Location> locations = new ArrayList<Location>();
        String locStr = this.jTextArea_Locations.getText();
        for (String loc : locs = locStr.split("[\\r\\n]+")) {
            locations.add(new Location(loc));
        }
        return locations;
    }

    public boolean isOK() {
        return this._isOK;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmStartLocations.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmStartLocations.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmStartLocations.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmStartLocations.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmStartLocations dialog = new FrmStartLocations((Dialog)new JDialog(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

