/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.interpolate;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.math.spatial.KDTree;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;

public class NearestNDInterpolator {
    protected KDTree.Euclidean<Double> kdTree;
    protected DataType dataType;
    protected boolean excludeNaN = true;
    protected double radius = Double.NaN;

    public NearestNDInterpolator(List<Array> points, Array values) {
        this(points, values, true);
    }

    public NearestNDInterpolator(List<Array> points, Array values, boolean excludeNaN) {
        this.excludeNaN = excludeNaN;
        int n = points.size();
        this.kdTree = new KDTree.Euclidean(n);
        for (Array a : points) {
            a = a.copyIfView();
        }
        values = values.copyIfView();
        this.dataType = values.getDataType();
        int pNum = (int)points.get(0).getSize();
        if (excludeNaN) {
            for (int i = 0; i < pNum; ++i) {
                double v = values.getDouble(i);
                if (Double.isNaN(v)) continue;
                this.kdTree.addPoint(this.getCoordinate(points, n, i), v);
            }
        } else {
            for (int i = 0; i < pNum; ++i) {
                this.kdTree.addPoint(this.getCoordinate(points, n, i), values.getDouble(i));
            }
        }
    }

    public NearestNDInterpolator(Array points, Array values) {
        this(points, values, true);
    }

    public NearestNDInterpolator(Array points, Array values, boolean excludeNaN) {
        this.excludeNaN = excludeNaN;
        points = points.copyIfView();
        int[] shape = points.getShape();
        int n = shape[0];
        int pNum = shape[1];
        this.kdTree = new KDTree.Euclidean(n);
        values = values.copyIfView();
        this.dataType = values.getDataType();
        if (excludeNaN) {
            for (int i = 0; i < pNum; ++i) {
                double v = values.getDouble(i);
                if (Double.isNaN(v)) continue;
                this.kdTree.addPoint(this.getCoordinate(points, n, pNum, i), v);
            }
        } else {
            for (int i = 0; i < pNum; ++i) {
                this.kdTree.addPoint(this.getCoordinate(points, n, pNum, i), values.getDouble(i));
            }
        }
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double value) {
        this.radius = value;
    }

    protected double[] getCoordinate(List<Array> points, int n, int idx) {
        double[] coord = new double[n];
        for (int i = 0; i < n; ++i) {
            coord[i] = points.get(i).getDouble(idx);
        }
        return coord;
    }

    protected double[] getCoordinate(Array points, int nRow, int nCol, int idx) {
        double[] coord = new double[nRow];
        for (int i = 0; i < nRow; ++i) {
            coord[i] = points.getDouble(i * nCol + idx);
        }
        return coord;
    }

    public KDTree.SearchResult nearest(double[] location) {
        return this.kdTree.nearestNeighbours(location, 1).get(0);
    }

    public List<KDTree.SearchResult<Double>> nearest(double[] location, int K) {
        ArrayList<KDTree.SearchResult<Double>> r = this.kdTree.nearestNeighbours(location, K);
        return r;
    }

    public Array nearest(List<Array> location) {
        for (Array a : location) {
            a = a.copyIfView();
        }
        int n = location.size();
        int pNum = (int)location.get(0).getSize();
        Array r = Array.factory((DataType)this.dataType, (int[])location.get(0).getShape());
        if (Double.isNaN(this.radius)) {
            for (int i = 0; i < pNum; ++i) {
                KDTree.SearchResult sr = this.nearest(this.getCoordinate(location, n, i));
                r.setObject(i, sr.payload);
            }
        } else {
            for (int i = 0; i < pNum; ++i) {
                KDTree.SearchResult sr = this.nearest(this.getCoordinate(location, n, i));
                if (sr.distance <= this.radius) {
                    r.setObject(i, sr.payload);
                    continue;
                }
                r.setObject(i, (Object)Double.NaN);
            }
        }
        return r;
    }

    public Array nearest(final List<Array> location, int nThreads) {
        for (Array a : location) {
            a = a.copyIfView();
        }
        final int n = location.size();
        int pNum = (int)location.get(0).getSize();
        final Array r = Array.factory((DataType)this.dataType, (int[])location.get(0).getShape());
        int segment = pNum / nThreads;
        int remainder = pNum % nThreads;
        int offset = 0;
        ArrayList<1> threads = new ArrayList<1>();
        for (int ti = 0; ti < nThreads; ++ti) {
            int segEnd;
            int segmentSize = remainder-- > 0 ? segment + 1 : segment;
            final int finalSegEnd = segEnd = offset + segmentSize;
            final int finalOffset = offset;
            Thread t = new Thread(){

                @Override
                public void run() {
                    if (Double.isNaN(NearestNDInterpolator.this.radius)) {
                        for (int i = finalOffset; i < finalSegEnd; ++i) {
                            KDTree.SearchResult sr = NearestNDInterpolator.this.nearest(NearestNDInterpolator.this.getCoordinate(location, n, i));
                            r.setObject(i, sr.payload);
                        }
                    } else {
                        for (int i = finalOffset; i < finalSegEnd; ++i) {
                            KDTree.SearchResult sr = NearestNDInterpolator.this.nearest(NearestNDInterpolator.this.getCoordinate(location, n, i));
                            if (sr.distance <= NearestNDInterpolator.this.radius) {
                                r.setObject(i, sr.payload);
                                continue;
                            }
                            r.setObject(i, (Object)Double.NaN);
                        }
                    }
                }
            };
            threads.add(t);
            t.start();
            offset += segmentSize;
        }
        for (int i = 0; i < threads.size(); ++i) {
            try {
                ((Thread)threads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return r;
    }
}

