/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import org.ojalgo.array.Array1D;
import org.ojalgo.function.BasicFunction;
import org.ojalgo.function.polynomial.AbstractPolynomial;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access1D;

public final class RationalPolynomial
extends AbstractPolynomial<RationalNumber> {
    public RationalPolynomial(int degree) {
        super((Array1D)Array1D.Q128.make(degree + 1));
    }

    RationalPolynomial(Array1D<RationalNumber> coefficients) {
        super(coefficients);
    }

    @Override
    public void estimate(Access1D<?> x, Access1D<?> y) {
        this.estimate(x, y, GenericStore.RATIONAL, QR.RATIONAL);
    }

    @Override
    public RationalNumber integrate(RationalNumber fromPoint, RationalNumber toPoint) {
        BasicFunction tmpPrim = this.buildPrimitive();
        RationalNumber tmpFromVal = tmpPrim.invoke(fromPoint);
        RationalNumber tmpToVal = tmpPrim.invoke(toPoint);
        return tmpToVal.subtract(tmpFromVal);
    }

    @Override
    public RationalNumber invoke(RationalNumber arg) {
        int tmpPower = this.degree();
        RationalNumber retVal = (RationalNumber)this.get(tmpPower);
        while (--tmpPower >= 0) {
            retVal = ((RationalNumber)this.get(tmpPower)).add(arg.multiply(retVal));
        }
        return retVal;
    }

    @Override
    public void set(Access1D<?> coefficients) {
        int tmpLimit = Math.min(this.size(), coefficients.size());
        for (int p = 0; p < tmpLimit; ++p) {
            this.set(p, RationalNumber.valueOf(coefficients.get(p)));
        }
    }

    @Override
    protected RationalNumber getDerivativeFactor(int power) {
        int tmpNextIndex = power + 1;
        return ((RationalNumber)this.get(tmpNextIndex)).multiply(tmpNextIndex);
    }

    @Override
    protected RationalNumber getPrimitiveFactor(int power) {
        if (power <= 0) {
            return RationalNumber.ZERO;
        }
        return ((RationalNumber)this.get(power - 1)).divide(power);
    }

    @Override
    protected AbstractPolynomial<RationalNumber> makeInstance(int size) {
        return new RationalPolynomial((Array1D)Array1D.Q128.make(size));
    }
}

