/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock;

import bibliothek.extension.gui.dock.preference.PreferenceEditor;
import bibliothek.extension.gui.dock.preference.PreferenceEditorCallback;
import bibliothek.extension.gui.dock.preference.PreferenceEditorFactory;
import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceModelListener;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import bibliothek.extension.gui.dock.preference.PreferenceOperationView;
import bibliothek.extension.gui.dock.preference.PreferenceOperationViewListener;
import bibliothek.extension.gui.dock.preference.editor.BooleanEditor;
import bibliothek.extension.gui.dock.preference.editor.ChoiceEditor;
import bibliothek.extension.gui.dock.preference.editor.KeyStrokeEditor;
import bibliothek.extension.gui.dock.preference.editor.LabelEditor;
import bibliothek.extension.gui.dock.preference.editor.ModifierMaskEditor;
import bibliothek.extension.gui.dock.preference.editor.StringEditor;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.themes.basic.action.buttons.BasicMiniButton;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PreferenceTable
extends JPanel {
    private Map<Path, PreferenceEditorFactory<?>> factories = new HashMap();
    private PreferenceModel model;
    private List<Row<?>> rows = new ArrayList();
    private JPanel panel;
    private GridBagLayout layout;
    private Listener listener = new Listener();
    private List<PreferenceOperation> operations = new ArrayList<PreferenceOperation>();
    private Map<PreferenceOperation, Operation> operationViews = new HashMap<PreferenceOperation, Operation>();
    private boolean reverseOrder = true;

    public PreferenceTable() {
        super(new GridBagLayout());
        this.layout = new GridBagLayout();
        this.panel = new JPanel(this.layout);
        this.add((Component)this.panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setEditorFactory(Path.TYPE_BOOLEAN_PATH, BooleanEditor.FACTORY);
        this.setEditorFactory(Path.TYPE_MODIFIER_MASK_PATH, ModifierMaskEditor.FACTORY);
        this.setEditorFactory(Path.TYPE_KEYSTROKE_PATH, KeyStrokeEditor.FACTORY);
        this.setEditorFactory(Path.TYPE_STRING_CHOICE_PATH, ChoiceEditor.FACTORY);
        this.setEditorFactory(Path.TYPE_LABEL, LabelEditor.FACTORY);
        this.setEditorFactory(Path.TYPE_STRING_PATH, StringEditor.FACTORY);
        this.addOperation(PreferenceOperation.DEFAULT);
        this.addOperation(PreferenceOperation.DELETE);
    }

    public PreferenceTable(PreferenceModel model) {
        this();
        this.setModel(model);
    }

    public void setReverseOrder(boolean reverseOrder) {
        this.reverseOrder = reverseOrder;
        int index = 0;
        for (Row<?> row : this.rows) {
            row.setIndex(index++);
        }
    }

    public boolean isReverseOrder() {
        return this.reverseOrder;
    }

    public void addOperation(PreferenceOperation operation) {
        if (!this.operations.contains(operation)) {
            this.operations.add(operation);
            this.operationViews.put(operation, new Operation(operation));
        }
    }

    public void insertOperation(int index, PreferenceOperation operation) {
        if (!this.operations.contains(operation)) {
            this.operations.add(index, operation);
            this.operationViews.put(operation, new Operation(operation));
        }
    }

    private int getOperationIndex(PreferenceOperation operation) {
        int index = this.operations.indexOf(operation);
        if (index < 0) {
            this.operations.add(operation);
            index = this.operations.size() - 1;
        }
        if (this.reverseOrder) {
            index = this.operations.size() - 1 - index;
        }
        return index;
    }

    private void addTable(Component component) {
        this.panel.add(component);
    }

    private void removeTable(Component component) {
        this.panel.remove(component);
    }

    public PreferenceModel getModel() {
        return this.model;
    }

    public void setModel(PreferenceModel model) {
        if (this.model != model) {
            if (this.model != null) {
                this.model.removePreferenceModelListener(this.listener);
                this.listener.preferenceRemoved(this.model, 0, this.model.getSize() - 1);
            }
            this.model = model;
            if (this.model != null) {
                this.model.addPreferenceModelListener(this.listener);
                this.listener.preferenceAdded(this.model, 0, this.model.getSize() - 1);
            }
        }
    }

    public void setEditorFactory(Path type, PreferenceEditorFactory<?> factory) {
        if (factory == null) {
            this.factories.remove(type);
        } else {
            this.factories.put(type, factory);
        }
    }

    public <V> PreferenceEditorFactory<V> getEditorFactory(Path type) {
        return this.factories.get(type);
    }

    protected <V> PreferenceEditor<V> createEditor(Path type) {
        PreferenceEditorFactory<?> factory = this.factories.get(type);
        if (factory == null) {
            throw new IllegalArgumentException("No editor defined for type '" + type.toString() + "'");
        }
        return factory.create();
    }

    private class Listener
    implements PreferenceModelListener {
        private Listener() {
        }

        @Override
        public void preferenceAdded(PreferenceModel model, int beginIndex, int endIndex) {
            for (int index = beginIndex; index <= endIndex; ++index) {
                PreferenceEditor editor = PreferenceTable.this.createEditor(model.getTypePath(index));
                Row row = new Row(editor, model.getLabel(index), model.getDescription(index));
                PreferenceTable.this.rows.add(index, row);
                row.setIndex(index);
            }
            int n = PreferenceTable.this.rows.size();
            for (int i = beginIndex; i < n; ++i) {
                ((Row)PreferenceTable.this.rows.get(i)).setIndex(i);
            }
            PreferenceTable.this.revalidate();
        }

        @Override
        public void preferenceChanged(PreferenceModel model, int beginIndex, int endIndex) {
            for (int i = beginIndex; i <= endIndex; ++i) {
                Row row = (Row)PreferenceTable.this.rows.get(i);
                row.changed();
            }
            PreferenceTable.this.revalidate();
        }

        @Override
        public void preferenceRemoved(PreferenceModel model, int beginIndex, int endIndex) {
            int i;
            for (i = endIndex; i >= beginIndex; --i) {
                Row row = (Row)PreferenceTable.this.rows.remove(i);
                row.destroy();
            }
            int n = PreferenceTable.this.rows.size();
            for (i = beginIndex; i < n; ++i) {
                ((Row)PreferenceTable.this.rows.get(i)).setIndex(i);
            }
            PreferenceTable.this.revalidate();
        }
    }

    private class Row<V>
    implements PreferenceEditorCallback<V> {
        private int index;
        private JLabel label;
        private PreferenceEditor<V> editor;
        private Map<PreferenceOperation, Button> editorOperations;
        private Map<PreferenceOperation, Button> modelOperations;
        private boolean initialized = false;

        public Row(PreferenceEditor<V> editor, String label, String description) {
            this.editor = editor;
            this.label = new JLabel(label);
            this.label.setToolTipText(description);
            PreferenceTable.this.addTable(this.label);
            if (editor != null) {
                editor.setCallback(this);
            }
            PreferenceTable.this.addTable(editor.getComponent());
        }

        public void setIndex(int index) {
            int location;
            this.index = index;
            PreferenceTable.this.layout.setConstraints(this.label, new GridBagConstraints(0, index, 1, 1, 1.0, 1.0, 21, 0, new Insets(1, 1, 1, 1), 0, 0));
            if (this.editor != null) {
                PreferenceTable.this.layout.setConstraints(this.editor.getComponent(), new GridBagConstraints(1, index, 1, 1, 100.0, 1.0, 21, 2, new Insets(1, 1, 1, 1), 0, 0));
            }
            if (!this.initialized) {
                this.initialized = true;
                this.initialize();
            }
            if (this.modelOperations != null) {
                for (Map.Entry<PreferenceOperation, Button> entry : this.modelOperations.entrySet()) {
                    location = 2 + PreferenceTable.this.getOperationIndex(entry.getKey());
                    PreferenceTable.this.layout.setConstraints(entry.getValue(), new GridBagConstraints(location, index, 1, 1, 1.0, 1.0, 22, 0, new Insets(1, 0, 1, 0), 0, 0));
                }
            }
            if (this.editorOperations != null) {
                for (Map.Entry<PreferenceOperation, Button> entry : this.editorOperations.entrySet()) {
                    location = 2 + PreferenceTable.this.getOperationIndex(entry.getKey());
                    PreferenceTable.this.layout.setConstraints(entry.getValue(), new GridBagConstraints(location, index, 1, 1, 1.0, 1.0, 22, 0, new Insets(1, 0, 1, 0), 0, 0));
                }
            }
            PreferenceTable.this.revalidate();
        }

        @Override
        public void setOperation(PreferenceOperation operation, boolean enabled) {
            this.setOperation(operation, enabled, true);
        }

        private void initialize() {
            PreferenceOperation[] operations = PreferenceTable.this.model.getOperations(this.index);
            if (operations != null) {
                for (PreferenceOperation operation : operations) {
                    if (this.editorOperations != null && this.editorOperations.containsKey(operation)) continue;
                    this.setOperation(operation, PreferenceTable.this.model.isEnabled(this.index, operation), false);
                }
            }
            if (this.editor != null) {
                this.editor.setValueInfo(PreferenceTable.this.model.getValueInfo(this.index));
                this.editor.setValue(PreferenceTable.this.model.getValue(this.index));
            }
        }

        private void setOperation(PreferenceOperation operation, boolean enabled, boolean editor) {
            Map<PreferenceOperation, Button> operations;
            if (editor) {
                if (this.editorOperations == null) {
                    this.editorOperations = new HashMap<PreferenceOperation, Button>();
                }
                operations = this.editorOperations;
            } else {
                if (this.modelOperations == null) {
                    this.modelOperations = new HashMap<PreferenceOperation, Button>();
                }
                operations = this.modelOperations;
            }
            Button button = operations.get(operation);
            if (button == null) {
                Operation view = (Operation)PreferenceTable.this.operationViews.get(operation);
                if (view == null) {
                    view = new Operation(operation);
                }
                button = new Button(view, editor);
                operations.put(operation, button);
                PreferenceTable.this.addTable(button);
                int location = 2 + PreferenceTable.this.getOperationIndex(operation);
                PreferenceTable.this.layout.setConstraints(button, new GridBagConstraints(location, this.index, 1, 1, 1.0, 1.0, 22, 0, new Insets(1, 0, 1, 0), 0, 0));
                PreferenceTable.this.revalidate();
            }
            ((BasicButtonModel)button.getModel()).setEnabled(enabled);
        }

        public void changed() {
            if (this.editor != null) {
                this.editor.setValue(PreferenceTable.this.model.getValue(this.index));
            }
            this.label.setText(PreferenceTable.this.model.getLabel(this.index));
            this.label.setToolTipText(PreferenceTable.this.model.getDescription(this.index));
            if (this.modelOperations != null) {
                for (Map.Entry<PreferenceOperation, Button> entry : this.modelOperations.entrySet()) {
                    boolean enabled = PreferenceTable.this.model.isEnabled(this.index, entry.getKey());
                    ((BasicButtonModel)entry.getValue().getModel()).setEnabled(enabled);
                }
            }
        }

        public void destroy() {
            PreferenceTable.this.removeTable(this.label);
            if (this.editor != null) {
                this.editor.setCallback(null);
                this.editor.setValue(null);
                PreferenceTable.this.removeTable(this.editor.getComponent());
                this.editor.setValueInfo(null);
            }
            if (this.editorOperations != null) {
                for (Button button : this.editorOperations.values()) {
                    button.destroy();
                    PreferenceTable.this.removeTable(button);
                }
            }
            if (this.modelOperations != null) {
                for (Button button : this.modelOperations.values()) {
                    button.destroy();
                    PreferenceTable.this.removeTable(button);
                }
            }
        }

        @Override
        public V get() {
            return (V)PreferenceTable.this.model.getValue(this.index);
        }

        @Override
        public void set(V value) {
            PreferenceTable.this.model.setValue(this.index, value);
        }

        private void doOperation(PreferenceOperation operation) {
            PreferenceTable.this.model.doOperation(this.index, operation);
        }

        @Override
        public PreferenceModel getModel() {
            return PreferenceTable.this.model;
        }

        private class Button
        extends BasicMiniButton
        implements PreferenceOperationViewListener {
            private Operation operation;
            private PreferenceOperationView view;

            public Button(final Operation operation, final boolean editorOperation) {
                super(new BasicTrigger(){

                    @Override
                    public void triggered() {
                        if (editorOperation) {
                            Row.this.editor.doOperation(operation.getOperation());
                        } else {
                            Row.this.doOperation(operation.getOperation());
                        }
                    }

                    @Override
                    public DockAction getAction() {
                        return null;
                    }

                    @Override
                    public Dockable getDockable() {
                        return null;
                    }
                }, null);
                this.operation = operation;
                this.view = operation.createView();
                this.view.addListener(this);
                ((BasicButtonModel)this.getModel()).setIcon(ActionContentModifier.NONE_HORIZONTAL, this.view.getIcon());
                ((BasicButtonModel)this.getModel()).setToolTipText(this.view.getDescription());
                this.setMouseOverBorder(BorderFactory.createEtchedBorder(1));
                this.setMousePressedBorder(BorderFactory.createLoweredBevelBorder());
            }

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.setFocusable(enabled);
            }

            @Override
            public void iconChanged(PreferenceOperationView operation, Icon oldIcon, Icon newIcon) {
                ((BasicButtonModel)this.getModel()).setIcon(ActionContentModifier.NONE_HORIZONTAL, newIcon);
            }

            @Override
            public void descriptionChanged(PreferenceOperationView operation, String oldDescription, String newDescription) {
                ((BasicButtonModel)this.getModel()).setToolTipText(newDescription);
            }

            public void destroy() {
                this.view.removeListener(this);
                this.operation.freeView();
            }
        }
    }

    private class Operation {
        private PreferenceOperation operation;
        private PreferenceOperationView view;
        private int usages;

        public Operation(PreferenceOperation operation) {
            this.operation = operation;
        }

        public PreferenceOperation getOperation() {
            return this.operation;
        }

        public synchronized PreferenceOperationView createView() {
            if (this.view == null) {
                this.view = this.operation.create(PreferenceTable.this.model);
            }
            ++this.usages;
            return this.view;
        }

        public synchronized void freeView() {
            --this.usages;
            if (this.usages == 0) {
                this.view.destroy();
                this.view = null;
            }
        }
    }
}

