/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.control.GlobalMouseDispatcher;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.control.focus.FocusAwareComponent;
import bibliothek.gui.dock.control.focus.FocusController;
import bibliothek.gui.dock.control.focus.FocusStrategy;
import bibliothek.gui.dock.control.focus.MouseFocusObserver;
import bibliothek.gui.dock.control.relocator.DockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorAdapter;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorListener;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.event.FocusVetoListener;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class DefaultMouseFocusObserver
implements MouseFocusObserver {
    private DockController controller;
    private VetoableDockRelocatorListener relocatorListener = new VetoableDockRelocatorAdapter(){

        @Override
        public void dropped(final DockRelocatorEvent event) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FocusController focus = DefaultMouseFocusObserver.this.controller.getFocusController();
                    FocusStrategy strategy = focus.getStrategy();
                    if (strategy == null || strategy.shouldFocusAfterDrop(event.getDockable())) {
                        DefaultMouseFocusObserver.this.controller.setFocusedDockable(new DefaultFocusRequest(event.getDockable(), null, true));
                    }
                }
            });
        }
    };
    private GlobalMouseListener listener = new GlobalMouseListener();

    public DefaultMouseFocusObserver(DockController controller, ControllerSetupCollection setup) {
        this.controller = controller;
        setup.add(new ControllerSetupListener(){

            @Override
            public void done(DockController controller) {
                controller.getRelocator().addVetoableDockRelocatorListener(DefaultMouseFocusObserver.this.relocatorListener);
                GlobalMouseDispatcher dispatcher = controller.getGlobalMouseDispatcher();
                dispatcher.addMouseListener(DefaultMouseFocusObserver.this.listener);
                dispatcher.addMouseMotionListener(DefaultMouseFocusObserver.this.listener);
                dispatcher.addMouseWheelListener(DefaultMouseFocusObserver.this.listener);
            }
        });
    }

    @Override
    public void kill() {
        this.getController().getRelocator().removeVetoableDockRelocatorListener(this.relocatorListener);
        GlobalMouseDispatcher dispatcher = this.controller.getGlobalMouseDispatcher();
        dispatcher.removeMouseListener(this.listener);
        dispatcher.removeMouseMotionListener(this.listener);
        dispatcher.removeMouseWheelListener(this.listener);
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    public void check(MouseEvent event) {
        if (this.interact(event)) {
            this.check((AWTEvent)event);
        }
    }

    public void check(MouseWheelEvent event) {
        if (this.interact(event)) {
            this.check((AWTEvent)event);
        }
    }

    protected void check(AWTEvent event) {
        if (this.controller.getRelocator().isOnPut() || this.controller.isOnFocusing()) {
            return;
        }
        Object source = event.getSource();
        if (source instanceof Component) {
            Component component = (Component)source;
            if (event.getID() == 501) {
                if (component.isFocusable() && component.isEnabled()) {
                    this.check(component, false, true, event);
                } else {
                    this.check(component, true, false, event);
                }
            } else {
                this.check(component, event);
            }
        }
    }

    protected boolean interact(AWTEvent event) {
        int id = event.getID();
        return id == 501 || id == 507;
    }

    protected void handleVeto(AWTEvent event, FocusVetoListener.FocusVeto veto) {
        if (veto == FocusVetoListener.FocusVeto.VETO && event instanceof InputEvent) {
            ((InputEvent)event).consume();
        }
    }

    protected void check(Component component, AWTEvent event) {
        this.check(component, true, false, event);
    }

    protected void check(final Component component, final boolean ensureFocus, boolean requestFocusInWindow, final AWTEvent event) {
        DockElementRepresentative element = this.getDockable(component, event);
        if (element == null) {
            return;
        }
        Dockable dock = element.getElement().asDockable();
        if (dock == null) {
            return;
        }
        Dockable focused = this.controller.getFocusedDockable();
        boolean change = true;
        if (focused != null) {
            boolean bl = change = !DockUtilities.isAncestor(dock, focused);
        }
        if (change) {
            if (component instanceof FocusAwareComponent) {
                FocusAwareComponent aware = (FocusAwareComponent)((Object)component);
                if (requestFocusInWindow) {
                    aware.maybeRequestFocus();
                }
                aware.invokeOnFocusRequest(new Runnable(){

                    @Override
                    public void run() {
                        Dockable dock;
                        DockElementRepresentative element = DefaultMouseFocusObserver.this.getDockable(component, event);
                        if (element != null && (dock = element.getElement().asDockable()) != null) {
                            DefaultMouseFocusObserver.this.controller.setFocusedDockable(new DefaultFocusRequest(dock, component, false, ensureFocus, element.shouldTransfersFocus()));
                        }
                    }
                });
            } else {
                if (requestFocusInWindow) {
                    component.requestFocusInWindow();
                }
                this.controller.setFocusedDockable(new DefaultFocusRequest(dock, component, false, ensureFocus, element.shouldTransfersFocus()));
            }
        }
    }

    protected DockElementRepresentative getDockable(Component component, AWTEvent event) {
        DockElementRepresentative element = this.controller.searchElement(component);
        if (element == null) {
            return null;
        }
        if ((event instanceof MouseEvent || event instanceof MouseWheelEvent) && !element.shouldFocus()) {
            return null;
        }
        Dockable dockable = element.getElement().asDockable();
        if (dockable == null) {
            return null;
        }
        FocusVetoListener.FocusVeto veto = this.controller.getFocusController().checkFocusedDockable(element);
        if (veto != null && veto != FocusVetoListener.FocusVeto.NONE) {
            this.handleVeto(event, veto);
            return null;
        }
        return element;
    }

    private class GlobalMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private GlobalMouseListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            DefaultMouseFocusObserver.this.check(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            DefaultMouseFocusObserver.this.check(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            DefaultMouseFocusObserver.this.check(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DefaultMouseFocusObserver.this.check(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            DefaultMouseFocusObserver.this.check(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            DefaultMouseFocusObserver.this.check(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            DefaultMouseFocusObserver.this.check(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            DefaultMouseFocusObserver.this.check(e);
        }
    }
}

