/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UIValue;
import bibliothek.util.Path;

public abstract class AbstractUIValue<V, U extends UIValue<V>>
implements UIValue<V> {
    private V override;
    private V value;
    private V backup;
    private String id;
    private Path kind;
    private UIProperties<V, U, ?> manager;
    private boolean overrideNull = false;

    public AbstractUIValue(String id) {
        this(id, null, null);
    }

    public AbstractUIValue(String id, Path kind) {
        this(id, kind, null);
    }

    public AbstractUIValue(String id, V backup) {
        this(id, null, backup);
    }

    public AbstractUIValue(String id, Path kind, V backup) {
        if (id == null) {
            throw new IllegalArgumentException("id must no be null");
        }
        if (kind == null) {
            throw new IllegalArgumentException("kind must not be null");
        }
        this.id = id;
        this.kind = kind;
        this.backup = backup;
    }

    protected abstract U me();

    public void setId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.id = id;
        if (this.manager != null) {
            U me = this.me();
            this.manager.remove(me);
            this.manager.add(id, this.kind, me);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setKind(Path kind) {
        if (kind == null) {
            throw new IllegalArgumentException("kind must not be null");
        }
        this.kind = kind;
        if (this.manager != null) {
            U me = this.me();
            this.manager.remove(me);
            this.manager.add(this.id, kind, me);
        }
    }

    public Path getKind() {
        return this.kind;
    }

    public void setManager(UIProperties<V, U, ?> manager) {
        if (manager != this.manager) {
            U me = this.me();
            if (this.manager != null) {
                this.manager.remove(me);
            }
            this.manager = manager;
            if (this.manager != null) {
                this.manager.add(this.id, this.kind, me);
            }
        }
    }

    @Override
    public void set(V value) {
        V oldValue = this.value();
        this.value = value;
        V newValue = this.value();
        if (oldValue != newValue) {
            this.changed(oldValue, newValue);
        }
    }

    public void update(UIProperties<V, U, ?> manager) {
        manager.get(this.id, this.kind, this.me());
    }

    public V value() {
        if (this.overrideNull || this.override != null) {
            return this.override;
        }
        if (this.value != null) {
            return this.value;
        }
        return this.backup;
    }

    protected abstract void changed(V var1, V var2);

    public void setValue(V value) {
        this.setValue(value, false);
    }

    public void setValue(V value, boolean forceNull) {
        V oldValue = this.value();
        this.override = value;
        this.overrideNull = forceNull;
        V newValue = this.value();
        if (oldValue != newValue) {
            this.changed(oldValue, newValue);
        }
    }

    public V getValue() {
        return this.override;
    }

    public void setBackup(V backup) {
        V oldColor = this.value();
        this.backup = backup;
        V newColor = this.value();
        if (oldColor != newColor) {
            this.changed(oldColor, newColor);
        }
    }

    public V getBackup() {
        return this.backup;
    }
}

