/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util.workarounds;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.station.stack.DnDAutoSelectSupport;
import bibliothek.util.workarounds.Workaround;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Java6Workaround
implements Workaround {
    private static boolean printWarnings = false;
    private boolean invocationTargetException = false;

    public static void setPrintWarnings(boolean printWarnings) {
        Java6Workaround.printWarnings = printWarnings;
    }

    public static boolean isPrintWarnings() {
        return printWarnings;
    }

    @Override
    public void setup(DockController controller) {
        controller.getProperties().set(StackDockStation.DND_AUTO_SELECT_SUPPORT, new DnDAutoSelectSupport());
    }

    private Class<?> getAWTUtilitiesClass() throws ClassNotFoundException {
        return Class.forName("com.sun.awt.AWTUtilities");
    }

    private Class<?> getTranslucencyClass() throws ClassNotFoundException {
        return Class.forName("com.sun.awt.AWTUtilities$Translucency");
    }

    private Object getTranslucency(String translucency) throws Exception {
        return this.getTranslucencyClass().getField(translucency).get(null);
    }

    @Override
    public void markAsGlassPane(Component component) {
        try {
            Method componentMixingCutoutShape = this.getAWTUtilitiesClass().getMethod("setComponentMixingCutoutShape", Component.class, Shape.class);
            componentMixingCutoutShape.invoke(null, component, new Rectangle());
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private boolean supports(String translucency) {
        block5: {
            try {
                Class<?> translucencyClass = this.getTranslucencyClass();
                Method isTranslucencySupported = this.getAWTUtilitiesClass().getMethod("isTranslucencySupported", translucencyClass);
                return (Boolean)isTranslucencySupported.invoke(null, this.getTranslucency(translucency));
            }
            catch (SecurityException translucencyClass) {
            }
            catch (NoClassDefFoundError translucencyClass) {
            }
            catch (NoSuchMethodError translucencyClass) {
            }
            catch (Exception ex) {
                if (!printWarnings || this.invocationTargetException) break block5;
                this.invocationTargetException = true;
                ex.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean supportsPerpixelTranslucency(Window window) {
        try {
            return this.supports("PERPIXEL_TRANSLUCENT");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean supportsPerpixelTransparency(Window window) {
        if (window instanceof Dialog && !((Dialog)window).isUndecorated()) {
            return false;
        }
        if (window instanceof Frame && !((Frame)window).isUndecorated()) {
            return false;
        }
        try {
            return this.supports("PERPIXEL_TRANSPARENT");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean setTranslucent(Window window) {
        block6: {
            if (!this.supportsPerpixelTranslucency(window)) {
                return false;
            }
            try {
                Method setWindowsOpaque = this.getAWTUtilitiesClass().getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
                setWindowsOpaque.invoke(null, window, false);
                return true;
            }
            catch (NoClassDefFoundError setWindowsOpaque) {
            }
            catch (NoSuchMethodError setWindowsOpaque) {
            }
            catch (SecurityException setWindowsOpaque) {
            }
            catch (Exception ex) {
                if (!printWarnings || this.invocationTargetException) break block6;
                this.invocationTargetException = true;
                ex.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean setTransparent(Window window, Shape shape) {
        block6: {
            if (!this.supportsPerpixelTransparency(window)) {
                return false;
            }
            try {
                Method setWindowShape = this.getAWTUtilitiesClass().getMethod("setWindowShape", Window.class, Shape.class);
                setWindowShape.invoke(null, window, shape);
                return true;
            }
            catch (NoClassDefFoundError setWindowShape) {
            }
            catch (NoSuchMethodError setWindowShape) {
            }
            catch (SecurityException setWindowShape) {
            }
            catch (Exception ex) {
                if (!printWarnings || this.invocationTargetException) break block6;
                this.invocationTargetException = true;
                ex.printStackTrace();
            }
        }
        return false;
    }
}

