/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.layout;

import com.l2fprod.common.beans.BaseBeanInfo;
import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.beans.editor.ComboBoxPropertyEditor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.meteoinfo.common.PointF;
import org.meteoinfo.geo.layout.ElementType;
import org.meteoinfo.geo.layout.LayoutElement;
import org.meteoinfo.geo.layout.LayoutMap;
import org.meteoinfo.geo.layout.ScaleBarType;
import org.meteoinfo.geo.layout.ScaleBarUnits;
import org.meteoinfo.geometry.graphic.ResizeAbility;

public class LayoutScaleBar
extends LayoutElement {
    private LayoutMap _layoutMap;
    private boolean _antiAlias;
    private Font _font;
    private ScaleBarType _scaleBarType;
    private ScaleBarUnits _unit;
    private String _unitText;
    private int _numBreaks;
    private boolean _drawNeatLine;
    private Color _neatLineColor;
    private float _neatLineSize;
    private boolean _drawScaleText;
    private float _yShiftScale = 2.0f;

    public LayoutScaleBar(LayoutMap layoutMap) {
        this.setElementType(ElementType.LAYOUT_SCALE_BAR);
        this.setResizeAbility(ResizeAbility.RESIZE_ALL);
        this.setWidth(200);
        this.setHeight(50);
        this._layoutMap = layoutMap;
        this._antiAlias = true;
        this._scaleBarType = ScaleBarType.SCALE_LINE_1;
        this._drawNeatLine = false;
        this._neatLineColor = Color.black;
        this._neatLineSize = 1.0f;
        this._font = new Font("Arial", 0, 12);
        this._unit = ScaleBarUnits.KILOMETERS;
        this._unitText = "km";
        this._numBreaks = 4;
        this._drawScaleText = false;
    }

    public LayoutMap getLayoutMap() {
        return this._layoutMap;
    }

    public ScaleBarType getScaleBarType() {
        return this._scaleBarType;
    }

    public void setScaleBarType(ScaleBarType type) {
        this._scaleBarType = type;
    }

    public boolean isDrawNeatLine() {
        return this._drawNeatLine;
    }

    public void setDrawNeatLine(boolean istrue) {
        this._drawNeatLine = istrue;
    }

    public Color getNeatLineColor() {
        return this._neatLineColor;
    }

    public void setNeatLineColor(Color color) {
        this._neatLineColor = color;
    }

    public float getNeatLineSize() {
        return this._neatLineSize;
    }

    public void setNeatLineSize(float size) {
        this._neatLineSize = size;
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font font) {
        this._font = font;
    }

    public int getBreakNumber() {
        return this._numBreaks;
    }

    public void setBreakNumber(int num) {
        this._numBreaks = num;
    }

    public boolean isDrawScaleText() {
        return this._drawScaleText;
    }

    public void setDrawScaleText(boolean istrue) {
        this._drawScaleText = istrue;
    }

    @Override
    public void paint(Graphics2D g) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void paintOnLayout(Graphics2D g, PointF pageLocation, float zoom) {
        if (this.isVisible()) {
            this.paintGraphics(g, pageLocation, zoom);
        }
    }

    public void paintGraphics(Graphics2D g, PointF pageLocation, float zoom) {
        AffineTransform oldMatrix = g.getTransform();
        PointF aP = this.pageToScreen(this.getLeft(), this.getTop(), pageLocation, zoom);
        g.translate(aP.X, aP.Y);
        g.scale(zoom, zoom);
        if (this._antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.isDrawBackColor()) {
            g.setColor(this.getBackColor());
            g.fill(new Rectangle2D.Float(0.0f, 0.0f, (float)this.getWidth() * zoom, (float)this.getHeight() * zoom));
        }
        this.drawScaleBar(g, zoom);
        if (this._drawNeatLine) {
            Rectangle2D.Float mapRect = new Rectangle2D.Float(this._neatLineSize - 1.0f, this._neatLineSize - 1.0f, ((float)this.getWidth() - this._neatLineSize) * zoom, ((float)this.getHeight() - this._neatLineSize) * zoom);
            g.setColor(this._neatLineColor);
            g.setStroke(new BasicStroke(this._neatLineSize));
            g.draw(mapRect);
        }
        g.setTransform(oldMatrix);
    }

    private void drawScaleBar(Graphics2D g, float zoom) {
        Font aFont = new Font(this._font.getFontName(), this._font.getStyle(), (int)((float)this._font.getSize() * zoom));
        FontMetrics metrics = g.getFontMetrics(aFont);
        float unitLegnth = metrics.stringWidth(this._unitText) * 2;
        float widthNoUnit = (float)this.getWidth() * zoom - unitLegnth;
        long geoBreakWidth = (long)this.getGeoWidth(widthNoUnit / (float)this._numBreaks);
        if (geoBreakWidth < 1L) {
            return;
        }
        double n = Math.pow(10.0, String.valueOf(geoBreakWidth).length() - 1);
        geoBreakWidth = (long)(Math.floor((double)geoBreakWidth / n) * n);
        long breakWidth = (long)this.getWidth(geoBreakWidth);
        FontMetrics metrics1 = g.getFontMetrics(this._font);
        float fontHeight = (float)metrics1.getHeight() * zoom;
        float leftStart = (float)metrics1.stringWidth(String.valueOf(Math.abs(geoBreakWidth))) / 2.0f;
        double scale = (double)geoBreakWidth * this.getConversionFactor(this._unit) * 100.0 / ((double)(breakWidth / 96L) * 2.539999918) * (double)zoom;
        if (this._drawScaleText) {
            g.setFont(aFont);
            g.setColor(this.getForeColor());
            g.drawString("1 : " + String.format("{0:0,0}", scale), leftStart - (float)(metrics.stringWidth(String.valueOf(Math.abs(0))) / 2), fontHeight * 2.5f);
        }
        switch (this._scaleBarType) {
            case SCALE_LINE_1: {
                this.drawScaleLine1(g, zoom, aFont, breakWidth, geoBreakWidth);
                break;
            }
            case SCALE_LINE_2: {
                this.drawScaleLine2(g, zoom, aFont, breakWidth, geoBreakWidth);
                break;
            }
            case ALTERNATING_BAR: {
                this.drawAlternatingBar(g, zoom, aFont, breakWidth, geoBreakWidth);
            }
        }
    }

    private double getConversionFactor(ScaleBarUnits unit) {
        switch (unit) {
            case KILOMETERS: {
                return 1000.0;
            }
        }
        return 1.0;
    }

    private double getGeoWidth(double width) {
        double geoWidth = width / this._layoutMap.getMapFrame().getMapView().getXScale() / this.getConversionFactor(this._unit);
        if (this._layoutMap.getMapFrame().getMapView().getProjection().isLonLatMap()) {
            geoWidth *= this.getLonDistScale();
        }
        return geoWidth;
    }

    private double getWidth(double geoWidth) {
        double width = geoWidth * this._layoutMap.getMapFrame().getMapView().getXScale() * this.getConversionFactor(this._unit);
        if (this._layoutMap.getMapFrame().getMapView().getProjection().isLonLatMap()) {
            width /= this.getLonDistScale();
        }
        return width;
    }

    private double getLonDistScale() {
        double pY = (this._layoutMap.getMapFrame().getMapView().getViewExtent().maxY + this._layoutMap.getMapFrame().getMapView().getViewExtent().minY) / 2.0;
        double ProjX = 0.0;
        double ProjY = pY;
        double pProjX = 1.0;
        double pProjY = pY;
        double dx = Math.abs(ProjX - pProjX);
        double dy = Math.abs(ProjY - pProjY);
        double y = (ProjY + pProjY) / 2.0;
        double factor = Math.cos(y * Math.PI / 180.0);
        double dist = Math.sqrt((dx *= factor) * dx + dy * dy);
        return dist *= 111319.5;
    }

    private void drawScaleLine1(Graphics2D g, float zoom, Font aFont, long breakWidth, long geoBreakWidth) {
        FontMetrics metrics = g.getFontMetrics(this._font);
        float fontHeight = (float)metrics.getHeight() * zoom;
        float leftStart = (float)metrics.stringWidth(String.valueOf(Math.abs(geoBreakWidth))) / 2.0f;
        int yShift = 10;
        g.setColor(this.getForeColor());
        g.setStroke(new BasicStroke(zoom));
        g.draw(new Line2D.Float(leftStart, fontHeight * 1.6f + (float)yShift, leftStart + (float)(breakWidth * (long)this._numBreaks), fontHeight * 1.6f + (float)yShift));
        FontMetrics metrics1 = g.getFontMetrics(aFont);
        g.setFont(aFont);
        for (int i = 0; i <= this._numBreaks; ++i) {
            g.draw(new Line2D.Float(leftStart, fontHeight * 1.1f + (float)yShift, leftStart, fontHeight * 1.6f + (float)yShift));
            g.drawString(String.valueOf(Math.abs(geoBreakWidth * (long)i)), leftStart - (float)(metrics1.stringWidth(String.valueOf(Math.abs(geoBreakWidth * (long)i))) / 2), (float)yShift * this._yShiftScale);
            leftStart += (float)breakWidth;
        }
        g.drawString(this._unitText, leftStart - (float)breakWidth + fontHeight / 2.0f, fontHeight * 1.1f + (float)yShift * this._yShiftScale);
    }

    private void drawScaleLine2(Graphics2D g, float zoom, Font aFont, long breakWidth, long geoBreakWidth) {
        FontMetrics metrics = g.getFontMetrics(this._font);
        float fontHeight = (float)metrics.getHeight() * zoom;
        float leftStart = (float)metrics.stringWidth(String.valueOf(Math.abs(geoBreakWidth))) / 2.0f;
        int yShift = 5;
        g.setColor(this.getForeColor());
        g.draw(new Line2D.Float(leftStart, fontHeight * 1.6f + (float)yShift, leftStart + (float)(breakWidth * (long)this._numBreaks), fontHeight * 1.6f + (float)yShift));
        FontMetrics metrics1 = g.getFontMetrics(aFont);
        g.setFont(aFont);
        for (int i = 0; i <= this._numBreaks; ++i) {
            g.draw(new Line2D.Float(leftStart, fontHeight * 1.1f + (float)yShift, leftStart, fontHeight + fontHeight * 1.1f + (float)yShift));
            g.drawString(String.valueOf(Math.abs(geoBreakWidth * (long)i)), leftStart - (float)(metrics1.stringWidth(String.valueOf(Math.abs(geoBreakWidth * (long)i))) / 2), (float)yShift * this._yShiftScale);
            leftStart += (float)breakWidth;
        }
        g.drawString(this._unitText, leftStart - (float)breakWidth + fontHeight / 2.0f, fontHeight * 1.1f + (float)yShift * this._yShiftScale);
    }

    private void drawAlternatingBar(Graphics2D g, float zoom, Font aFont, long breakWidth, long geoBreakWidth) {
        FontMetrics metrics = g.getFontMetrics(this._font);
        float fontHeight = (float)metrics.getHeight() * zoom;
        float leftStart = (float)metrics.stringWidth(String.valueOf(Math.abs(geoBreakWidth))) / 2.0f;
        int yShift = 5;
        float rHeight = fontHeight / 2.0f;
        FontMetrics metrics1 = g.getFontMetrics(aFont);
        boolean isFill = false;
        for (int i = 0; i <= this._numBreaks; ++i) {
            if (i < this._numBreaks) {
                if (isFill) {
                    g.setColor(this.getForeColor());
                    g.fill(new Rectangle2D.Float(leftStart, fontHeight * 1.1f + (float)yShift, breakWidth, rHeight));
                } else {
                    g.setColor(this.getForeColor());
                    g.draw(new Rectangle2D.Float(leftStart, fontHeight * 1.1f + (float)yShift, breakWidth, rHeight));
                }
            }
            g.setColor(this.getForeColor());
            g.setFont(aFont);
            g.drawString(String.valueOf(Math.abs(geoBreakWidth * (long)i)), leftStart - (float)(metrics1.stringWidth(String.valueOf(Math.abs(geoBreakWidth * (long)i))) / 2), (float)yShift * this._yShiftScale);
            leftStart += (float)breakWidth;
            isFill = !isFill;
        }
        g.setColor(this.getForeColor());
        g.setFont(aFont);
        g.drawString(this._unitText, leftStart - (float)breakWidth + fontHeight / 2.0f, fontHeight * 1.1f + (float)yShift * this._yShiftScale);
    }

    @Override
    public void moveUpdate() {
    }

    @Override
    public void resizeUpdate() {
    }

    public static class ScaleBarTypeEditor
    extends ComboBoxPropertyEditor {
        public ScaleBarTypeEditor() {
            ScaleBarType[] lutypes = ScaleBarType.values();
            Object[] types = new String[lutypes.length];
            int i = 0;
            for (ScaleBarType type : lutypes) {
                types[i] = type.toString();
                ++i;
            }
            this.setAvailableValues(types);
        }
    }

    public static class LayoutScaleBarBeanBeanInfo
    extends BaseBeanInfo {
        public LayoutScaleBarBeanBeanInfo() {
            super(LayoutScaleBarBean.class);
            ExtendedPropertyDescriptor e = this.addProperty("scaleBarType");
            e.setCategory("General").setDisplayName("Scale Bar Type");
            e.setPropertyEditorClass(ScaleBarTypeEditor.class);
            this.addProperty("drawBackColor").setCategory("General").setDisplayName("Draw Background");
            this.addProperty("backColor").setCategory("General").setDisplayName("Background");
            this.addProperty("foreColor").setCategory("General").setDisplayName("Foreground");
            this.addProperty("font").setCategory("General").setDisplayName("Font");
            this.addProperty("drawScaleText").setCategory("General").setDisplayName("Draw Scale Text");
            this.addProperty("drawNeatLine").setCategory("Neat Line").setDisplayName("Draw Neat Line");
            this.addProperty("neatLineColor").setCategory("Neat Line").setDisplayName("Neat Line Color");
            this.addProperty("neatLineSize").setCategory("Neat Line").setDisplayName("Neat Line Size");
            this.addProperty("left").setCategory("Location").setDisplayName("Left");
            this.addProperty("top").setCategory("Location").setDisplayName("Top");
            this.addProperty("width").setCategory("Location").setDisplayName("Width");
            this.addProperty("height").setCategory("Location").setDisplayName("Height");
        }
    }

    public class LayoutScaleBarBean {
        LayoutScaleBarBean() {
        }

        public String getScaleBarType() {
            return LayoutScaleBar.this._scaleBarType.toString();
        }

        public void setScaleBarType(String type) {
            LayoutScaleBar.this._scaleBarType = ScaleBarType.valueOf(type);
        }

        public boolean isDrawNeatLine() {
            return LayoutScaleBar.this._drawNeatLine;
        }

        public void setDrawNeatLine(boolean istrue) {
            LayoutScaleBar.this._drawNeatLine = istrue;
        }

        public Color getNeatLineColor() {
            return LayoutScaleBar.this._neatLineColor;
        }

        public void setNeatLineColor(Color color) {
            LayoutScaleBar.this._neatLineColor = color;
        }

        public float getNeatLineSize() {
            return LayoutScaleBar.this._neatLineSize;
        }

        public void setNeatLineSize(float size) {
            LayoutScaleBar.this._neatLineSize = size;
        }

        public Font getFont() {
            return LayoutScaleBar.this._font;
        }

        public void setFont(Font font) {
            LayoutScaleBar.this._font = font;
        }

        public int getBreakNumber() {
            return LayoutScaleBar.this._numBreaks;
        }

        public void setBreakNumber(int num) {
            LayoutScaleBar.this._numBreaks = num;
        }

        public boolean isDrawScaleText() {
            return LayoutScaleBar.this._drawScaleText;
        }

        public void setDrawScaleText(boolean istrue) {
            LayoutScaleBar.this._drawScaleText = istrue;
        }

        public boolean isDrawBackColor() {
            return LayoutScaleBar.this.isDrawBackColor();
        }

        public void setDrawBackColor(boolean value) {
            LayoutScaleBar.this.setDrawBackColor(value);
        }

        public Color getBackColor() {
            return LayoutScaleBar.this.getBackColor();
        }

        public void setBackColor(Color c) {
            LayoutScaleBar.this.setBackColor(c);
        }

        public Color getForeColor() {
            return LayoutScaleBar.this.getForeColor();
        }

        public void setForeColor(Color c) {
            LayoutScaleBar.this.setForeColor(c);
        }

        public int getLeft() {
            return LayoutScaleBar.this.getLeft();
        }

        public void setLeft(int left) {
            LayoutScaleBar.this.setLeft(left);
        }

        public int getTop() {
            return LayoutScaleBar.this.getTop();
        }

        public void setTop(int top) {
            LayoutScaleBar.this.setTop(top);
        }

        public int getWidth() {
            return LayoutScaleBar.this.getWidth();
        }

        public void setWidth(int width) {
            LayoutScaleBar.this.setWidth(width);
        }

        public int getHeight() {
            return LayoutScaleBar.this.getHeight();
        }

        public void setHeight(int height) {
            LayoutScaleBar.this.setHeight(height);
        }
    }
}

