/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.meteoinfo.chart.ChartLegend;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.PointF;
import org.meteoinfo.common.XAlign;
import org.meteoinfo.common.YAlign;
import org.meteoinfo.common.colors.ColorMap;
import org.meteoinfo.geometry.colors.BoundaryNorm;
import org.meteoinfo.geometry.colors.ExtendType;
import org.meteoinfo.geometry.colors.LogNorm;
import org.meteoinfo.geometry.colors.Normalize;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.render.java2d.Draw;

public class ChartColorBar
extends ChartLegend {
    private List<Double> tickLocations = new ArrayList<Double>();
    private List<ChartText> tickLabels = new ArrayList<ChartText>();
    private boolean autoTick = true;
    private boolean insideTick = false;
    private float tickLength = 5.0f;
    private boolean tickVisible = true;
    private float tickWidth = 1.0f;
    private Color tickColor = Color.black;
    private boolean drawMinLabel = false;
    private boolean drawMaxLabel = false;
    private ExtendType extendType;
    private boolean drawMinorTick;
    protected int minorTickNum;

    public ChartColorBar(LegendScheme ls) {
        super(ls);
        this.extendType = ls.getExtendType();
        this.drawMinorTick = false;
        this.minorTickNum = 5;
        this.setLegendScheme(ls);
    }

    public List<Double> getTickLocations() {
        return this.tickLocations;
    }

    public void setTickLocations(List<Number> value) {
        this.tickLocations.clear();
        this.tickLabels.clear();
        for (Number v : value) {
            this.tickLocations.add(v.doubleValue());
            this.tickLabels.add(new ChartText(DataConvert.removeTailingZeros((String)String.valueOf(v))));
        }
        this.autoTick = false;
    }

    public void setTickLocations(double[] value) {
        this.tickLocations.clear();
        this.tickLabels.clear();
        for (double v : value) {
            this.tickLocations.add(v);
            this.tickLabels.add(new ChartText(DataConvert.removeTailingZeros((String)String.valueOf(v))));
        }
        this.autoTick = false;
    }

    public List<ChartText> getTickLabels() {
        return this.tickLabels;
    }

    public List<String> getTickLabelText() {
        ArrayList<String> strs = new ArrayList<String>();
        for (ChartText ct : this.tickLabels) {
            strs.add(ct.toString());
        }
        return strs;
    }

    public void setTickLabelText(List<String> value) {
        this.tickLabels = new ArrayList<ChartText>();
        for (String v : value) {
            this.tickLabels.add(new ChartText(v));
        }
        this.autoTick = false;
    }

    public void setTickLabels(List<ChartText> value) {
        this.tickLabels = value;
    }

    public void setTickLabels_Number(List<Number> value) {
        this.tickLabels = new ArrayList<ChartText>();
        for (Number v : value) {
            this.tickLabels.add(new ChartText(v.toString()));
        }
        this.autoTick = false;
    }

    public boolean isAutoTick() {
        return this.autoTick;
    }

    public void setAutoTick(boolean value) {
        this.autoTick = value;
    }

    public float getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(int value) {
        this.tickLength = value;
    }

    public boolean isInsideTick() {
        return this.insideTick;
    }

    public void setInsideTick(boolean value) {
        this.insideTick = value;
    }

    public boolean isTickVisible() {
        return this.tickVisible;
    }

    public void setTickVisible(boolean value) {
        this.tickVisible = value;
    }

    public float getTickWidth() {
        return this.tickWidth;
    }

    public void setTickWidth(float value) {
        this.tickWidth = value;
    }

    public Color getTickColor() {
        return this.tickColor;
    }

    public void setTickColor(Color value) {
        this.tickColor = value;
        this.tickLabelColor = value;
    }

    @Override
    public void setLegendScheme(LegendScheme value) {
        block6: {
            double[] tickValues;
            this.legendScheme = value;
            Normalize normalize = this.legendScheme.getNormalize();
            if (normalize == null) break block6;
            double min = normalize.getMinValue();
            double max = normalize.getMaxValue();
            if (normalize instanceof LogNorm) {
                tickValues = MIMath.getIntervalValues_Log((double)min, (double)max);
                this.drawMinorTick = true;
            } else {
                tickValues = MIMath.getIntervalValues((double)min, (double)max);
            }
            this.tickLocations = Arrays.stream(tickValues).boxed().collect(Collectors.toList());
            this.tickLabels = new ArrayList<ChartText>();
            if (normalize instanceof LogNorm) {
                for (double v : this.tickLocations) {
                    int e = (int)Math.floor(Math.log10(v));
                    this.tickLabels.add(new ChartText("$10^{" + String.valueOf(e) + "}$"));
                }
            } else {
                for (double v : this.tickLocations) {
                    this.tickLabels.add(new ChartText(DataConvert.removeTailingZeros((String)String.valueOf(v))));
                }
            }
        }
    }

    public boolean isDrawMinLabel() {
        return this.drawMinLabel;
    }

    public void setDrawMinLabel(boolean value) {
        this.drawMinLabel = value;
    }

    public boolean isDrawMaxLabel() {
        return this.drawMaxLabel;
    }

    public void setDrawMaxLabel(boolean value) {
        this.drawMaxLabel = value;
    }

    @Override
    public void setExtendRect(boolean value) {
        this.extendRect = value;
        if (!value) {
            this.extendType = ExtendType.BOTH;
        }
    }

    public ExtendType getExtendType() {
        return this.extendType;
    }

    public void setExtendType(ExtendType value) {
        this.extendType = value;
    }

    public void setExtendType(String value) {
        this.extendType = ExtendType.valueOf((String)value.toUpperCase());
    }

    public boolean isDrawMinorTick() {
        return this.drawMinorTick;
    }

    public void setDrawMinorTick(boolean value) {
        this.drawMinorTick = value;
    }

    public int getMinorTickNum() {
        return this.minorTickNum;
    }

    public void setMinorTickNum(int value) {
        this.minorTickNum = value;
    }

    @Override
    protected int getTickWidth(Graphics2D g) {
        if (this.tickLabels.isEmpty()) {
            return super.getTickWidth(g);
        }
        float tWidth = 0.0f;
        g.setFont(this.tickLabelFont);
        for (ChartText ct : this.tickLabels) {
            float labWidth = (float)Draw.getStringDimension((String)ct.getText(), (float)this.tickLabelAngle, (Graphics2D)g).getWidth();
            if (!(tWidth < labWidth)) continue;
            tWidth = labWidth;
        }
        return (int)tWidth;
    }

    @Override
    protected int getTickHeight(Graphics2D g) {
        if (this.tickLabels.isEmpty()) {
            return super.getTickHeight(g);
        }
        float tHeight = 0.0f;
        g.setFont(this.tickLabelFont);
        for (ChartText ct : this.tickLabels) {
            float labHeight = (float)Draw.getStringDimension((String)ct.getText(), (float)(90.0f - Math.abs(this.tickLabelAngle)), (Graphics2D)g).getWidth();
            if (!(tHeight < labHeight)) continue;
            tHeight = labHeight;
        }
        return (int)tHeight;
    }

    @Override
    public void draw(Graphics2D g, PointF point) {
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
        }
        AffineTransform oldMatrix = g.getTransform();
        g.translate(point.X + this.xshift, point.Y + this.yshift);
        if (this.drawBackground) {
            g.setColor(this.background);
            g.fill(new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height));
        }
        g.setStroke(new BasicStroke(1.0f));
        switch (this.orientation) {
            case HORIZONTAL: {
                if (this.legendScheme.getColorMap() != null) {
                    this.drawHorizontal(g, this.legendScheme);
                    break;
                }
                this.drawHorizontalBarLegend(g, this.legendScheme);
                break;
            }
            case VERTICAL: {
                if (this.legendScheme.getColorMap() != null) {
                    this.drawVertical(g, this.legendScheme);
                    break;
                }
                this.drawVerticalBarLegend(g, this.legendScheme);
            }
        }
        if (this.drawNeatLine) {
            Rectangle2D.Float mapRect = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            g.setColor(this.neatLineColor);
            g.setStroke(new BasicStroke(this.neatLineSize));
            g.draw(mapRect);
        }
        g.setTransform(oldMatrix);
    }

    private void drawTickLine(Graphics2D g, PointF sP, float tickLen, boolean vertical, float shift) {
        if (vertical) {
            if (this.insideTick) {
                g.draw(new Line2D.Float(sP.X + shift, sP.Y, sP.X + shift, sP.Y - tickLen));
            } else {
                g.draw(new Line2D.Float(sP.X + shift, sP.Y, sP.X + shift, sP.Y + tickLen));
                sP.Y += tickLen;
            }
            sP.Y += 5.0f;
        } else {
            if (this.insideTick) {
                g.draw(new Line2D.Float(sP.X - tickLen, sP.Y + shift, sP.X, sP.Y + shift));
            } else {
                g.draw(new Line2D.Float(sP.X, sP.Y + shift, sP.X + tickLen, sP.Y + shift));
                sP.X += tickLen;
            }
            sP.X += 5.0f;
        }
    }

    private void drawTickLine(Graphics2D g, PointD sP, float tickLen, boolean vertical, double shift) {
        if (vertical) {
            if (this.insideTick) {
                g.draw(new Line2D.Double(sP.X + shift, sP.Y, sP.X + shift, sP.Y - (double)tickLen));
            } else {
                g.draw(new Line2D.Double(sP.X + shift, sP.Y, sP.X + shift, sP.Y + (double)tickLen));
                sP.Y += (double)tickLen;
            }
            sP.Y += 5.0;
        } else {
            if (this.insideTick) {
                g.draw(new Line2D.Double(sP.X - (double)tickLen, sP.Y + shift, sP.X, sP.Y + shift));
            } else {
                g.draw(new Line2D.Double(sP.X, sP.Y + shift, sP.X + (double)tickLen, sP.Y + shift));
                sP.X += (double)tickLen;
            }
            sP.X += 5.0;
        }
    }

    private PointD drawTickLine(Graphics2D g, double x, double y, float tickLen, boolean vertical, double shift) {
        if (vertical) {
            if (this.insideTick) {
                g.draw(new Line2D.Double(x + shift, y, x + shift, y - (double)tickLen));
            } else {
                g.draw(new Line2D.Double(x + shift, y, x + shift, y + (double)tickLen));
                y += (double)tickLen;
            }
            y += 5.0;
        } else {
            if (this.insideTick) {
                g.draw(new Line2D.Double(x - (double)tickLen, y + shift, x, y + shift));
            } else {
                g.draw(new Line2D.Double(x, y + shift, x + (double)tickLen, y + shift));
                x += (double)tickLen;
            }
            x += 5.0;
        }
        return new PointD(x, y);
    }

    private void drawHorizontal(Graphics2D g, LegendScheme ls) {
        PointF aP = new PointF(0.0f, 0.0f);
        PointF sP = new PointF(0.0f, 0.0f);
        ColorMap colorMap = ls.getColorMap();
        Normalize normalize = ls.getNormalize();
        int bNum = colorMap.getColorCount();
        if (normalize instanceof BoundaryNorm) {
            bNum = ((BoundaryNorm)normalize).getNRegions();
        }
        this.barHeight = (float)this.legendWidth / (float)this.aspect;
        float minMaxWidth = this.legendWidth;
        float x_shift = 0.0f;
        switch (this.extendType) {
            case MIN: {
                minMaxWidth -= this.barHeight;
                x_shift += this.barHeight;
                break;
            }
            case MAX: {
                minMaxWidth -= this.barHeight;
                break;
            }
            case BOTH: {
                minMaxWidth -= this.barHeight * 2.0f;
                x_shift += this.barHeight;
            }
        }
        this.barWidth = minMaxWidth / (float)bNum;
        float y_shift = 0.0f;
        if (this.label != null) {
            switch (this.labelLocation) {
                case "top": 
                case "in": {
                    y_shift = this.label.getDimension((Graphics2D)g).height + 5;
                }
            }
        }
        aP.Y = y_shift;
        Color[] colors = colorMap.getColors(bNum);
        switch (this.extendType) {
            case MIN: 
            case BOTH: {
                g.setColor(colors[0]);
                Path2D.Float p = new Path2D.Float();
                ((Path2D)p).moveTo(aP.X, aP.Y + this.barHeight / 2.0f);
                ((Path2D)p).lineTo(aP.X + this.barHeight, aP.Y);
                ((Path2D)p).lineTo(aP.X + this.barHeight, aP.Y + this.barHeight);
                ((Path2D)p).lineTo(aP.X, aP.Y + this.barHeight / 2.0f);
                p.closePath();
                g.fill(p);
                aP.X += this.barHeight;
            }
        }
        for (int i = 0; i < bNum; ++i) {
            g.setColor(colors[i]);
            Rectangle2D.Float rect = i == bNum - 1 ? new Rectangle2D.Float(aP.X - 1.0f, aP.Y, this.barWidth + 2.0f, this.barHeight) : new Rectangle2D.Float(aP.X - 1.0f, aP.Y, this.barWidth + 1.0f, this.barHeight);
            g.fill(rect);
            aP.X += this.barWidth;
        }
        switch (this.extendType) {
            case MAX: 
            case BOTH: {
                g.setColor(colors[bNum - 1]);
                Path2D.Float p = new Path2D.Float();
                ((Path2D)p).moveTo(aP.X, aP.Y);
                ((Path2D)p).lineTo(aP.X, aP.Y + this.barHeight);
                ((Path2D)p).lineTo(aP.X + this.barHeight, aP.Y + this.barHeight / 2.0f);
                ((Path2D)p).lineTo(aP.X, aP.Y);
                p.closePath();
                g.fill(p);
            }
        }
        g.setStroke(new BasicStroke(this.neatLineSize));
        g.setColor(this.neatLineColor);
        switch (this.extendType) {
            case BOTH: {
                Path2D.Float p = new Path2D.Float();
                ((Path2D)p).moveTo(0.0, this.barHeight / 2.0f + y_shift);
                ((Path2D)p).lineTo(this.barHeight, y_shift);
                ((Path2D)p).lineTo((float)this.legendWidth - this.barHeight, y_shift);
                ((Path2D)p).lineTo(this.legendWidth, this.barHeight / 2.0f + y_shift);
                ((Path2D)p).lineTo((float)this.legendWidth - this.barHeight, this.barHeight + y_shift);
                ((Path2D)p).lineTo(this.barHeight, this.barHeight + y_shift);
                p.closePath();
                g.draw(p);
                break;
            }
            case MIN: {
                Path2D.Float p = new Path2D.Float();
                ((Path2D)p).moveTo(0.0, this.barHeight / 2.0f + y_shift);
                ((Path2D)p).lineTo(this.barHeight, y_shift);
                ((Path2D)p).lineTo(this.legendWidth, y_shift);
                ((Path2D)p).lineTo(this.legendWidth, this.barHeight + y_shift);
                ((Path2D)p).lineTo(this.barHeight, this.barHeight + y_shift);
                ((Path2D)p).lineTo(0.0, this.barHeight / 2.0f + y_shift);
                p.closePath();
                g.draw(p);
                break;
            }
            case MAX: {
                Path2D.Float p = new Path2D.Float();
                ((Path2D)p).moveTo(0.0, y_shift);
                ((Path2D)p).lineTo(0.0, this.barHeight + y_shift);
                ((Path2D)p).lineTo((float)this.legendWidth - this.barHeight, this.barHeight + y_shift);
                ((Path2D)p).lineTo(this.legendWidth, this.barHeight / 2.0f + y_shift);
                ((Path2D)p).lineTo((float)this.legendWidth - this.barHeight, y_shift);
                ((Path2D)p).lineTo(0.0, y_shift);
                p.closePath();
                g.draw(p);
                break;
            }
            default: {
                g.draw(new Rectangle2D.Double(0.0, y_shift, this.barWidth * (float)bNum, this.barHeight));
            }
        }
        float tickLen = this.tickLength;
        if (this.insideTick && this.barHeight < tickLen) {
            tickLen = (int)this.barHeight;
        }
        g.setStroke(new BasicStroke(this.tickWidth));
        g.setFont(this.tickLabelFont);
        g.setColor(this.tickColor);
        aP.Y = this.barHeight + y_shift;
        for (int i = 0; i < this.tickLocations.size(); ++i) {
            sP.X = x_shift + minMaxWidth * normalize.apply((Number)this.tickLocations.get(i)).floatValue();
            sP.Y = aP.Y;
            g.setColor(this.tickColor);
            this.drawTickLine(g, sP, tickLen, true, 0.0f);
            String label = this.tickLabels.get(i).getText();
            g.setColor(this.tickLabelColor);
            if (this.tickLabelAngle == 0.0f) {
                Draw.drawString((Graphics2D)g, (float)sP.X, (float)sP.Y, (String)label, (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
            } else if (this.tickLabelAngle < 45.0f) {
                Draw.drawString((Graphics2D)g, (float)sP.X, (float)sP.Y, (String)label, (XAlign)XAlign.RIGHT, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
            } else {
                Draw.drawString((Graphics2D)g, (float)sP.X, (float)sP.Y, (String)label, (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
            }
            if (!this.drawMinorTick || i == this.tickLocations.size() - 1) continue;
            float minorTickLen = tickLen - 2.0f;
            double v1 = this.tickLocations.get(i);
            double v2 = this.tickLocations.get(i + 1);
            double step = (v2 - v1) / (double)this.minorTickNum;
            g.setColor(this.tickColor);
            for (int j = 1; j < this.minorTickNum; ++j) {
                double v = v1 + step * (double)j;
                sP.X = x_shift + minMaxWidth * normalize.apply((Number)v).floatValue();
                sP.Y = aP.Y;
                this.drawTickLine(g, sP, minorTickLen, true, 0.0f);
            }
        }
        if (this.label != null) {
            g.setFont(this.label.getFont());
            g.setColor(this.label.getColor());
            switch (this.labelLocation) {
                case "top": 
                case "in": {
                    double sx = (double)this.legendWidth * 0.5;
                    double sy = 2.0;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (boolean)this.label.isUseExternalFont());
                    break;
                }
                case "right": {
                    double sx = this.legendWidth + 5;
                    double sy = (double)this.barHeight * 0.5;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (boolean)this.label.isUseExternalFont());
                    break;
                }
                case "left": {
                    double sx = -5.0;
                    double sy = (double)this.barHeight * 0.5;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (boolean)this.label.isUseExternalFont());
                    break;
                }
                default: {
                    double sx = (double)this.legendWidth * 0.5;
                    double sy = this.height - 2;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.CENTER, (YAlign)YAlign.BOTTOM, (boolean)this.label.isUseExternalFont());
                }
            }
        }
    }

    private void drawHorizontalBarLegend(Graphics2D g, LegendScheme aLS) {
        Object aPGB;
        PointD aP = new PointD(0.0, 0.0);
        PointD sP = new PointD(0.0, 0.0);
        boolean DrawShape = true;
        boolean DrawFill = true;
        boolean DrawOutline = false;
        Color FillColor = Color.red;
        Color OutlineColor = Color.black;
        int bNum = aLS.getBreakNum();
        if (((ColorBreak)aLS.getLegendBreaks().get(bNum - 1)).isNoData()) {
            --bNum;
        }
        ArrayList<Integer> labelIdxs = new ArrayList<Integer>();
        ArrayList<String> tLabels = new ArrayList<String>();
        int tickGap = this.getTickGap(g);
        if (this.autoTick) {
            int sIdx = bNum % tickGap / 2;
            int labNum = bNum;
            switch (this.extendType) {
                case MAX: 
                case NONE: 
                case NEITHER: {
                    sIdx = 0;
                }
            }
            while (sIdx < labNum) {
                labelIdxs.add(sIdx);
                sIdx += tickGap;
            }
        } else {
            for (int i = 0; i < bNum; ++i) {
                double v;
                ColorBreak cb = (ColorBreak)aLS.getLegendBreaks().get(i);
                if (i == bNum - 1 && cb.getStartValue().equals(cb.getEndValue()) || !this.tickLocations.contains(v = Double.parseDouble(cb.getEndValue().toString()))) continue;
                labelIdxs.add(i);
                int tickIdx = this.tickLocations.indexOf(v);
                tLabels.add(this.tickLabels.get(tickIdx).getText());
            }
        }
        this.barHeight = (float)this.legendWidth / (float)this.aspect;
        int extendNum = 0;
        switch (this.extendType) {
            case BOTH: {
                extendNum = 2;
                break;
            }
            case MIN: 
            case MAX: {
                extendNum = 1;
            }
        }
        float extendLength = 0.0f;
        if (extendNum == 0) {
            this.barWidth = (float)this.legendWidth / (float)bNum;
        } else {
            switch (this.extendFraction) {
                case NONE: {
                    extendLength = (float)this.legendWidth * 0.05f;
                    this.barWidth = ((float)this.legendWidth - extendLength * (float)extendNum) / (float)(bNum - extendNum);
                    break;
                }
                case AUTO: {
                    extendLength = this.barWidth = (float)this.legendWidth / (float)bNum;
                    break;
                }
                case LENGTH: {
                    this.barWidth = (float)this.legendWidth / ((float)bNum + (this.extendFraction.fraction - 1.0f) * (float)extendNum);
                    extendLength = this.barWidth * this.extendFraction.fraction;
                }
            }
        }
        float y_shift = 0.0f;
        if (this.label != null) {
            switch (this.labelLocation) {
                case "top": 
                case "in": {
                    y_shift = this.label.getDimension((Graphics2D)g).height + 5;
                }
            }
        }
        aP.Y = y_shift;
        for (int i = 0; i < bNum; ++i) {
            int idx = i;
            switch (aLS.getShapeType()) {
                case POINT: {
                    PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPB.isDrawShape();
                    DrawFill = aPB.isDrawFill();
                    FillColor = aPB.getColor();
                    break;
                }
                case POLYLINE: {
                    PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPLB.isDrawPolyline();
                    FillColor = aPLB.getColor();
                    break;
                }
                case POLYGON: {
                    aPGB = (PolygonBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPGB.isDrawShape();
                    DrawFill = aPGB.isDrawFill();
                    FillColor = aPGB.getColor();
                    break;
                }
                case IMAGE: {
                    ColorBreak aCB = (ColorBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = true;
                    DrawFill = true;
                    FillColor = aCB.getColor();
                }
            }
            if (DrawShape) {
                PolygonBreak aPGB2;
                PointD[] Points;
                PolygonBreak aPGB3;
                if (this.extendRect && this.extendType == ExtendType.NONE) {
                    if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                        aPGB3 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                        aPGB3.setDrawOutline(false);
                        Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (double)this.barWidth, (double)this.barHeight, (PolygonBreak)aPGB3, (Graphics2D)g);
                    } else {
                        Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (Color)FillColor, (Color)OutlineColor, (double)this.barWidth, (double)this.barHeight, (Boolean)DrawFill, (Boolean)DrawOutline, (Graphics2D)g);
                    }
                } else if (i == 0) {
                    switch (this.extendType) {
                        case MIN: 
                        case BOTH: {
                            Points = new PointD[]{new PointD(0.0, aP.Y + (double)this.barHeight * 0.5), new PointD((double)extendLength, aP.Y), new PointD((double)extendLength, aP.Y + (double)this.barHeight), new PointD(0.0, aP.Y + (double)this.barHeight * 0.5)};
                            if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                                aPGB2 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                                aPGB2.setDrawOutline(false);
                                Draw.drawPolygon((PointD[])Points, (PolygonBreak)aPGB2, (Graphics2D)g);
                            } else {
                                Draw.drawPolygon((PointD[])Points, (Color)FillColor, (Color)OutlineColor, (boolean)DrawFill, (boolean)DrawOutline, (Graphics2D)g);
                            }
                            aP.X += (double)(extendLength - this.barWidth);
                            break;
                        }
                        default: {
                            if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                                aPGB2 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                                aPGB2.setDrawOutline(false);
                                Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (double)this.barWidth, (double)this.barHeight, (PolygonBreak)aPGB2, (Graphics2D)g);
                                break;
                            }
                            Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (Color)FillColor, (Color)OutlineColor, (double)this.barWidth, (double)this.barHeight, (Boolean)DrawFill, (Boolean)DrawOutline, (Graphics2D)g);
                            break;
                        }
                    }
                } else if (i == bNum - 1) {
                    switch (this.extendType) {
                        case MAX: 
                        case BOTH: {
                            Points = new PointD[]{new PointD((double)((float)this.legendWidth - extendLength), aP.Y + (double)this.barHeight), new PointD((double)((float)this.legendWidth - extendLength), aP.Y), new PointD((double)this.legendWidth, aP.Y + (double)this.barHeight * 0.5), new PointD((double)((float)this.legendWidth - extendLength), aP.Y + (double)this.barHeight)};
                            if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                                aPGB2 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                                aPGB2.setDrawOutline(false);
                                Draw.drawPolygon((PointD[])Points, (PolygonBreak)aPGB2, (Graphics2D)g);
                                break;
                            }
                            Draw.drawPolygon((PointD[])Points, (Color)FillColor, (Color)OutlineColor, (boolean)DrawFill, (boolean)DrawOutline, (Graphics2D)g);
                            break;
                        }
                        default: {
                            if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                                aPGB2 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                                aPGB2.setDrawOutline(false);
                                Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (double)this.barWidth, (double)this.barHeight, (PolygonBreak)aPGB2, (Graphics2D)g);
                                break;
                            }
                            Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (Color)FillColor, (Color)OutlineColor, (double)this.barWidth, (double)this.barHeight, (Boolean)DrawFill, (Boolean)DrawOutline, (Graphics2D)g);
                            break;
                        }
                    }
                } else if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                    aPGB3 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                    aPGB3.setDrawOutline(false);
                    Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (double)this.barWidth, (double)this.barHeight, (PolygonBreak)aPGB3, (Graphics2D)g);
                } else {
                    Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (Color)FillColor, (Color)OutlineColor, (double)this.barWidth, (double)this.barHeight, (Boolean)DrawFill, (Boolean)DrawOutline, (Graphics2D)g);
                }
            }
            aP.X += (double)this.barWidth;
        }
        g.setStroke(new BasicStroke(this.neatLineSize));
        g.setColor(this.neatLineColor);
        if (this.extendRect && this.extendType == ExtendType.NONE) {
            g.draw(new Rectangle2D.Double(0.0, y_shift, this.barWidth * (float)bNum, this.barHeight));
        } else {
            switch (this.extendType) {
                case BOTH: {
                    Path2D.Double p = new Path2D.Double();
                    ((Path2D)p).moveTo(0.0, this.barHeight / 2.0f + y_shift);
                    ((Path2D)p).lineTo(extendLength, y_shift);
                    ((Path2D)p).lineTo(this.barWidth * (float)(bNum - 2) + extendLength, y_shift);
                    ((Path2D)p).lineTo(this.barWidth * (float)(bNum - 2) + extendLength * 2.0f, this.barHeight / 2.0f + y_shift);
                    ((Path2D)p).lineTo(this.barWidth * (float)(bNum - 2) + extendLength, this.barHeight + y_shift);
                    ((Path2D)p).lineTo(extendLength, this.barHeight + y_shift);
                    p.closePath();
                    g.draw(p);
                    break;
                }
                case MAX: {
                    Path2D.Double p = new Path2D.Double();
                    ((Path2D)p).moveTo(0.0, y_shift);
                    ((Path2D)p).lineTo(this.barWidth * (float)(bNum - 1), y_shift);
                    ((Path2D)p).lineTo(this.barWidth * (float)(bNum - 1) + extendLength, this.barHeight / 2.0f + y_shift);
                    ((Path2D)p).lineTo(this.barWidth * (float)(bNum - 1), this.barHeight + y_shift);
                    ((Path2D)p).lineTo(0.0, this.barHeight + y_shift);
                    p.closePath();
                    g.draw(p);
                    break;
                }
                case MIN: {
                    Path2D.Double p = new Path2D.Double();
                    ((Path2D)p).moveTo(0.0, this.barHeight / 2.0f + y_shift);
                    ((Path2D)p).lineTo(extendLength, y_shift);
                    ((Path2D)p).lineTo(this.barWidth * (float)(bNum - 1) + extendLength, y_shift);
                    ((Path2D)p).lineTo(this.barWidth * (float)(bNum - 1) + extendLength, this.barHeight + y_shift);
                    ((Path2D)p).lineTo(extendLength, this.barHeight + y_shift);
                    p.closePath();
                    g.draw(p);
                    break;
                }
                default: {
                    g.draw(new Rectangle2D.Double(0.0, y_shift, this.barWidth * (float)bNum, this.barHeight));
                }
            }
        }
        sP.X = 0.0;
        sP.Y = aLS.getLegendType() == LegendType.UNIQUE_VALUE ? (double)(this.barHeight + y_shift + 5.0f) : (double)(this.barHeight + y_shift);
        float tickLen = this.tickLength;
        if (this.insideTick && this.barHeight < tickLen) {
            tickLen = (int)this.barHeight;
        }
        g.setStroke(new BasicStroke(this.tickWidth));
        g.setFont(this.tickLabelFont);
        g.setColor(this.tickColor);
        int idx = 0;
        double sX = sP.X;
        switch (this.extendType) {
            case MIN: 
            case BOTH: {
                sX = sX - (double)this.barWidth + (double)extendLength;
            }
        }
        aPGB = labelIdxs.iterator();
        while (aPGB.hasNext()) {
            int i = (Integer)aPGB.next();
            sP.X = sX + (double)(this.barWidth * (float)(i + 1));
            ColorBreak cb = (ColorBreak)aLS.getLegendBreaks().get(i);
            String caption = this.autoTick ? (aLS.getLegendType() == LegendType.UNIQUE_VALUE ? cb.getCaption() : DataConvert.removeTailingZeros((String)cb.getEndValue().toString())) : (String)tLabels.get(idx);
            if (aLS.getLegendType() == LegendType.UNIQUE_VALUE) {
                aP.X = sP.X - (double)(this.barWidth / 2.0f);
                g.setColor(this.tickLabelColor);
                if (this.tickLabelAngle == 0.0f) {
                    Draw.drawString((Graphics2D)g, (double)aP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                } else if (this.tickLabelAngle < 45.0f) {
                    Draw.drawString((Graphics2D)g, (double)aP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                } else {
                    Draw.drawString((Graphics2D)g, (double)aP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                }
            } else if (this.autoTick) {
                if (i < bNum - 1) {
                    g.setColor(this.tickColor);
                    aP = this.drawTickLine(g, sP.X, sP.Y, tickLen, true, 0.0);
                    g.setColor(this.tickLabelColor);
                    if (this.tickLabelAngle == 0.0f) {
                        Draw.drawString((Graphics2D)g, (double)aP.X, (double)aP.Y, (String)caption, (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                    } else if (this.tickLabelAngle < 45.0f) {
                        Draw.drawString((Graphics2D)g, (double)aP.X, (double)aP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                    } else {
                        Draw.drawString((Graphics2D)g, (double)aP.X, (double)aP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                    }
                    if (i == 0) {
                        switch (this.extendType) {
                            case MAX: 
                            case NEITHER: {
                                if (tickGap != 1) break;
                                g.setColor(this.tickColor);
                                aP = this.drawTickLine(g, sP.X, sP.Y, tickLen, true, -this.barWidth);
                                caption = DataConvert.removeTailingZeros((String)cb.getStartValue().toString());
                                g.setColor(this.tickLabelColor);
                                if (this.tickLabelAngle == 0.0f) {
                                    Draw.drawString((Graphics2D)g, (double)(aP.X - (double)this.barWidth), (double)aP.Y, (String)caption, (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                                    break;
                                }
                                if (this.tickLabelAngle < 45.0f) {
                                    Draw.drawString((Graphics2D)g, (double)(aP.X - (double)this.barWidth), (double)aP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                                    break;
                                }
                                Draw.drawString((Graphics2D)g, (double)(aP.X - (double)this.barWidth), (double)aP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                            }
                        }
                    }
                } else {
                    switch (this.extendType) {
                        case MIN: 
                        case NEITHER: {
                            g.setColor(this.tickColor);
                            aP = this.drawTickLine(g, sP.X, sP.Y, tickLen, true, 0.0);
                            g.setColor(this.tickLabelColor);
                            if (this.tickLabelAngle == 0.0f) {
                                Draw.drawString((Graphics2D)g, (double)aP.X, (double)aP.Y, (String)caption, (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                                break;
                            }
                            if (this.tickLabelAngle < 45.0f) {
                                Draw.drawString((Graphics2D)g, (double)aP.X, (double)aP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                                break;
                            }
                            Draw.drawString((Graphics2D)g, (double)aP.X, (double)aP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                        }
                    }
                }
            } else if (i == 0 && this.tickLocations.get(idx) == Double.parseDouble(cb.getStartValue().toString())) {
                g.setColor(this.tickColor);
                aP = this.drawTickLine(g, sP.X, sP.Y, tickLen, true, -this.barWidth);
                g.setColor(this.tickLabelColor);
                if (this.tickLabelAngle == 0.0f) {
                    Draw.drawString((Graphics2D)g, (double)(aP.X - (double)this.barWidth), (double)aP.Y, (String)caption, (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                } else if (this.tickLabelAngle < 45.0f) {
                    Draw.drawString((Graphics2D)g, (double)(aP.X - (double)this.barWidth), (double)aP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                } else {
                    Draw.drawString((Graphics2D)g, (double)(aP.X - (double)this.barWidth), (double)aP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                }
            } else {
                g.setColor(this.tickColor);
                aP = this.drawTickLine(g, sP.X, sP.Y, tickLen, true, 0.0);
                g.setColor(this.tickLabelColor);
                if (this.tickLabelAngle == 0.0f) {
                    Draw.drawString((Graphics2D)g, (double)aP.X, (double)aP.Y, (String)caption, (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                } else if (this.tickLabelAngle < 45.0f) {
                    Draw.drawString((Graphics2D)g, (double)aP.X, (double)aP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.TOP, (float)this.tickLabelAngle, (boolean)true);
                } else {
                    Draw.drawString((Graphics2D)g, (double)aP.X, (double)aP.Y, (String)caption, (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                }
            }
            ++idx;
        }
        if (this.label != null) {
            g.setFont(this.label.getFont());
            g.setColor(this.label.getColor());
            switch (this.labelLocation) {
                case "top": 
                case "in": {
                    double sx = (double)this.legendWidth * 0.5;
                    double sy = 2.0;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (boolean)this.label.isUseExternalFont());
                    break;
                }
                case "right": {
                    double sx = this.legendWidth + 5;
                    double sy = (double)this.barHeight * 0.5;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (boolean)this.label.isUseExternalFont());
                    break;
                }
                case "left": {
                    double sx = -5.0;
                    double sy = (double)this.barHeight * 0.5;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.RIGHT, (YAlign)YAlign.CENTER, (boolean)this.label.isUseExternalFont());
                    break;
                }
                default: {
                    double sx = (double)this.legendWidth * 0.5;
                    double sy = this.height - 2;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.CENTER, (YAlign)YAlign.BOTTOM, (boolean)this.label.isUseExternalFont());
                }
            }
        }
    }

    private void drawVertical(Graphics2D g, LegendScheme ls) {
        PointF aP = new PointF(0.0f, 0.0f);
        PointF sP = new PointF(0.0f, 0.0f);
        ColorMap colorMap = ls.getColorMap();
        Normalize normalize = ls.getNormalize();
        int bNum = colorMap.getColorCount();
        if (normalize instanceof BoundaryNorm) {
            bNum = ((BoundaryNorm)normalize).getNRegions();
        }
        this.barWidth = (float)this.legendHeight / (float)this.aspect;
        float minMaxHeight = this.legendHeight;
        float y_shift = 0.0f;
        switch (this.extendType) {
            case MIN: {
                minMaxHeight -= this.barWidth;
                y_shift += this.barWidth;
                break;
            }
            case MAX: {
                minMaxHeight -= this.barWidth;
                break;
            }
            case BOTH: {
                minMaxHeight -= this.barWidth * 2.0f;
                y_shift += this.barWidth;
            }
        }
        this.barHeight = minMaxHeight / (float)bNum;
        float x_shift = 0.0f;
        if (this.label != null) {
            switch (this.labelLocation) {
                case "left": 
                case "in": {
                    x_shift = this.label.getDimension((Graphics2D)g).height + 5;
                }
            }
        }
        aP.X = x_shift;
        aP.Y = this.legendHeight;
        Color[] colors = colorMap.getColors(bNum);
        switch (this.extendType) {
            case MIN: 
            case BOTH: {
                g.setColor(colors[0]);
                Path2D.Float p = new Path2D.Float();
                ((Path2D)p).moveTo(aP.X + this.barWidth / 2.0f, aP.Y);
                ((Path2D)p).lineTo(aP.X + this.barWidth, aP.Y - this.barWidth);
                ((Path2D)p).lineTo(aP.X, aP.Y - this.barWidth);
                ((Path2D)p).lineTo(aP.X + this.barWidth / 2.0f, aP.Y);
                p.closePath();
                g.fill(p);
                aP.Y -= this.barWidth;
            }
        }
        for (int i = 0; i < bNum; ++i) {
            aP.Y -= this.barHeight;
            g.setColor(colors[i]);
            Rectangle2D.Float rect = i == bNum - 1 ? new Rectangle2D.Float(aP.X, aP.Y - 1.0f, this.barWidth, this.barHeight + 2.0f) : new Rectangle2D.Float(aP.X, aP.Y, this.barWidth, this.barHeight + 1.0f);
            g.fill(rect);
        }
        switch (this.extendType) {
            case MAX: 
            case BOTH: {
                g.setColor(colors[bNum - 1]);
                Path2D.Float p = new Path2D.Float();
                ((Path2D)p).moveTo(aP.X, aP.Y);
                ((Path2D)p).lineTo(aP.X + this.barWidth, aP.Y);
                ((Path2D)p).lineTo(aP.X + this.barWidth / 2.0f, aP.Y - this.barWidth);
                ((Path2D)p).lineTo(aP.X, aP.Y);
                p.closePath();
                g.fill(p);
            }
        }
        g.setStroke(new BasicStroke(this.neatLineSize));
        g.setColor(this.neatLineColor);
        switch (this.extendType) {
            case BOTH: {
                Path2D.Double p = new Path2D.Double();
                ((Path2D)p).moveTo(this.barWidth / 2.0f + x_shift, 0.0);
                ((Path2D)p).lineTo(x_shift, this.barWidth);
                ((Path2D)p).lineTo(x_shift, (float)this.legendHeight - this.barWidth);
                ((Path2D)p).lineTo(this.barWidth / 2.0f + x_shift, this.legendHeight);
                ((Path2D)p).lineTo(this.barWidth + x_shift, (float)this.legendHeight - this.barWidth);
                ((Path2D)p).lineTo(this.barWidth + x_shift, this.barWidth);
                p.closePath();
                g.draw(p);
                break;
            }
            case MIN: {
                Path2D.Double p = new Path2D.Double();
                ((Path2D)p).moveTo(x_shift, 0.0);
                ((Path2D)p).lineTo(this.barWidth + x_shift, 0.0);
                ((Path2D)p).lineTo(this.barWidth + x_shift, (float)this.legendHeight - this.barWidth);
                ((Path2D)p).lineTo(this.barWidth / 2.0f + x_shift, this.legendHeight);
                ((Path2D)p).lineTo(x_shift, (float)this.legendHeight - this.barWidth);
                ((Path2D)p).lineTo(x_shift, 0.0);
                p.closePath();
                g.draw(p);
                break;
            }
            case MAX: {
                Path2D.Double p = new Path2D.Double();
                ((Path2D)p).moveTo(this.barWidth / 2.0f + x_shift, 0.0);
                ((Path2D)p).lineTo(x_shift, this.barWidth);
                ((Path2D)p).lineTo(x_shift, this.legendHeight);
                ((Path2D)p).lineTo(this.barWidth + x_shift, this.legendHeight);
                ((Path2D)p).lineTo(this.barWidth + x_shift, this.barWidth);
                ((Path2D)p).lineTo(this.barWidth / 2.0f + x_shift, 0.0);
                p.closePath();
                g.draw(p);
                break;
            }
            default: {
                g.draw(new Rectangle2D.Double(x_shift, 0.0, this.barWidth, this.legendHeight));
            }
        }
        float tickLen = this.tickLength;
        if (this.insideTick && this.barWidth < tickLen) {
            tickLen = (int)this.barWidth;
        }
        g.setStroke(new BasicStroke(this.tickWidth));
        g.setFont(this.tickLabelFont);
        g.setColor(this.tickColor);
        aP.X = this.barWidth + x_shift;
        for (int i = 0; i < this.tickLocations.size(); ++i) {
            sP.X = aP.X;
            sP.Y = (float)this.legendHeight - y_shift - minMaxHeight * normalize.apply((Number)this.tickLocations.get(i)).floatValue();
            g.setColor(this.tickColor);
            this.drawTickLine(g, sP, tickLen, false, 0.0f);
            String label = this.tickLabels.get(i).getText();
            g.setColor(this.tickLabelColor);
            Draw.drawString((Graphics2D)g, (float)sP.X, (float)sP.Y, (String)label, (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
            if (!this.drawMinorTick || i == this.tickLocations.size() - 1) continue;
            float minorTickLen = tickLen - 2.0f;
            double v1 = this.tickLocations.get(i);
            double v2 = this.tickLocations.get(i + 1);
            double step = (v2 - v1) / (double)this.minorTickNum;
            g.setColor(this.tickColor);
            for (int j = 1; j < this.minorTickNum; ++j) {
                double v = v1 + step * (double)j;
                sP.X = aP.X;
                sP.Y = (float)this.legendHeight - y_shift - minMaxHeight * normalize.apply((Number)v).floatValue();
                this.drawTickLine(g, sP, minorTickLen, false, 0.0f);
            }
        }
        if (this.label != null) {
            g.setFont(this.label.getFont());
            g.setColor(this.label.getColor());
            Dimension dim = Draw.getStringDimension((String)this.label.getText(), (Graphics2D)g);
            switch (this.labelLocation) {
                case "top": {
                    double sx = 0.0;
                    double sy = -5.0;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.LEFT, (YAlign)YAlign.BOTTOM, (boolean)this.label.isUseExternalFont());
                    break;
                }
                case "bottom": {
                    double sx = 0.0;
                    double sy = this.legendHeight + 5;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.LEFT, (YAlign)YAlign.TOP, (boolean)this.label.isUseExternalFont());
                    break;
                }
                case "left": 
                case "in": {
                    double sx = 0.0;
                    double sy = (double)this.legendHeight * 0.5;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)90.0f, (boolean)this.label.isUseExternalFont());
                    break;
                }
                default: {
                    double sx = this.width - dim.height;
                    double sy = (double)this.legendHeight * 0.5;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)90.0f, (boolean)this.label.isUseExternalFont());
                }
            }
        }
    }

    private void drawVerticalBarLegend(Graphics2D g, LegendScheme aLS) {
        Object aPGB;
        PointD aP = new PointD(0.0, 0.0);
        PointD sP = new PointD(0.0, 0.0);
        boolean DrawShape = true;
        boolean DrawFill = true;
        boolean DrawOutline = false;
        Color FillColor = Color.red;
        Color OutlineColor = Color.black;
        int bNum = aLS.getBreakNum();
        if (((ColorBreak)aLS.getLegendBreaks().get(bNum - 1)).isNoData()) {
            --bNum;
        }
        ArrayList<Integer> labelIdxs = new ArrayList<Integer>();
        ArrayList<String> tLabels = new ArrayList<String>();
        int tickGap = this.getTickGap(g);
        if (this.autoTick) {
            int sIdx = bNum % tickGap / 2;
            int labNum = bNum;
            switch (this.extendType) {
                case MAX: 
                case NONE: 
                case NEITHER: {
                    sIdx = 0;
                }
            }
            while (sIdx < labNum) {
                labelIdxs.add(sIdx);
                sIdx += tickGap;
            }
        } else {
            for (int i = 0; i < bNum; ++i) {
                int tickIdx;
                ColorBreak cb = (ColorBreak)aLS.getLegendBreaks().get(i);
                if (i == bNum - 1 && cb.getStartValue().equals(cb.getEndValue())) continue;
                double v = Double.parseDouble(cb.getEndValue().toString());
                if (this.tickLocations.contains(v)) {
                    labelIdxs.add(i);
                    tickIdx = this.tickLocations.indexOf(v);
                    tLabels.add(this.tickLabels.get(tickIdx).getText());
                }
                if (i != 0 || !this.tickLocations.contains(v = Double.parseDouble(cb.getStartValue().toString()))) continue;
                labelIdxs.add(i);
                tickIdx = this.tickLocations.indexOf(v);
                tLabels.add(0, this.tickLabels.get(tickIdx).getText());
            }
        }
        this.barWidth = (float)this.legendHeight / (float)this.aspect;
        int extendNum = 0;
        switch (this.extendType) {
            case BOTH: {
                extendNum = 2;
                break;
            }
            case MIN: 
            case MAX: {
                extendNum = 1;
            }
        }
        float extendLength = 0.0f;
        if (extendNum == 0) {
            this.barHeight = (float)this.legendHeight / (float)bNum;
        } else {
            switch (this.extendFraction) {
                case NONE: {
                    extendLength = (float)this.legendHeight * 0.05f;
                    this.barHeight = ((float)this.legendHeight - extendLength * (float)extendNum) / (float)(bNum - extendNum);
                    break;
                }
                case AUTO: {
                    extendLength = this.barHeight = (float)this.legendHeight / (float)bNum;
                    break;
                }
                case LENGTH: {
                    this.barHeight = (float)this.legendHeight / ((float)bNum + (this.extendFraction.fraction - 1.0f) * (float)extendNum);
                    extendLength = this.barHeight * this.extendFraction.fraction;
                }
            }
        }
        aP.Y = this.legendHeight;
        float x_shift = 0.0f;
        if (this.label != null) {
            switch (this.labelLocation) {
                case "left": 
                case "in": {
                    x_shift = this.label.getDimension((Graphics2D)g).height + 5;
                }
            }
        }
        aP.X = x_shift;
        for (int i = 0; i < bNum; ++i) {
            PolygonBreak aPGB2;
            PointD[] Points;
            PolygonBreak aPGB3;
            int idx = i;
            switch (aLS.getShapeType()) {
                case POINT: {
                    PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPB.isDrawShape();
                    DrawFill = aPB.isDrawFill();
                    FillColor = aPB.getColor();
                    break;
                }
                case POLYLINE: {
                    PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPLB.isDrawPolyline();
                    FillColor = aPLB.getColor();
                    break;
                }
                case POLYGON: {
                    aPGB = (PolygonBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = aPGB.isDrawShape();
                    DrawFill = aPGB.isDrawFill();
                    FillColor = aPGB.getColor();
                    break;
                }
                case IMAGE: {
                    ColorBreak aCB = (ColorBreak)aLS.getLegendBreaks().get(idx);
                    DrawShape = true;
                    DrawFill = true;
                    FillColor = aCB.getColor();
                }
            }
            if (!DrawShape) continue;
            if (this.extendRect && this.extendType == ExtendType.NONE) {
                aP.Y -= (double)this.barHeight;
                if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                    aPGB3 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                    aPGB3.setDrawOutline(false);
                    Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (double)this.barWidth, (double)this.barHeight, (PolygonBreak)aPGB3, (Graphics2D)g);
                    continue;
                }
                Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (Color)FillColor, (Color)OutlineColor, (double)this.barWidth, (double)this.barHeight, (Boolean)DrawFill, (Boolean)DrawOutline, (Graphics2D)g);
                continue;
            }
            if (i == 0) {
                switch (this.extendType) {
                    case MIN: 
                    case BOTH: {
                        aP.Y -= (double)extendLength;
                        Points = new PointD[]{new PointD(aP.X + (double)this.barWidth * 0.5, (double)this.legendHeight), new PointD(aP.X, aP.Y), new PointD(aP.X + (double)this.barWidth, aP.Y), new PointD(aP.X + (double)this.barWidth * 0.5, (double)this.legendHeight)};
                        if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                            aPGB2 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                            aPGB2.setDrawOutline(false);
                            Draw.drawPolygon((PointD[])Points, (PolygonBreak)aPGB2, (Graphics2D)g);
                            break;
                        }
                        Draw.drawPolygon((PointD[])Points, (Color)FillColor, (Color)OutlineColor, (boolean)DrawFill, (boolean)DrawOutline, (Graphics2D)g);
                        break;
                    }
                    default: {
                        aP.Y -= (double)this.barHeight;
                        if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                            aPGB2 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                            aPGB2.setDrawOutline(false);
                            Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (double)this.barWidth, (double)this.barHeight, (PolygonBreak)aPGB2, (Graphics2D)g);
                            break;
                        }
                        Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (Color)FillColor, (Color)OutlineColor, (double)this.barWidth, (double)this.barHeight, (Boolean)DrawFill, (Boolean)DrawOutline, (Graphics2D)g);
                        break;
                    }
                }
                continue;
            }
            if (i == bNum - 1) {
                aP.Y -= (double)this.barHeight;
                switch (this.extendType) {
                    case MAX: 
                    case BOTH: {
                        Points = new PointD[]{new PointD(aP.X, (double)extendLength), new PointD(aP.X + (double)this.barWidth, (double)extendLength), new PointD(aP.X + (double)this.barWidth * 0.5, 0.0), new PointD(aP.X, (double)extendLength)};
                        if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                            aPGB2 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                            aPGB2.setDrawOutline(false);
                            Draw.drawPolygon((PointD[])Points, (PolygonBreak)aPGB2, (Graphics2D)g);
                            break;
                        }
                        Draw.drawPolygon((PointD[])Points, (Color)FillColor, (Color)OutlineColor, (boolean)DrawFill, (boolean)DrawOutline, (Graphics2D)g);
                        break;
                    }
                    default: {
                        if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                            aPGB2 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                            aPGB2.setDrawOutline(false);
                            Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (double)this.barWidth, (double)this.barHeight, (PolygonBreak)aPGB2, (Graphics2D)g);
                            break;
                        }
                        Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (Color)FillColor, (Color)OutlineColor, (double)this.barWidth, (double)this.barHeight, (Boolean)DrawFill, (Boolean)DrawOutline, (Graphics2D)g);
                        break;
                    }
                }
                continue;
            }
            aP.Y -= (double)this.barHeight;
            if (aLS.getShapeType() == ShapeTypes.POLYGON) {
                aPGB3 = (PolygonBreak)((ColorBreak)aLS.getLegendBreaks().get(idx)).clone();
                aPGB3.setDrawOutline(false);
                Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (double)this.barWidth, (double)this.barHeight, (PolygonBreak)aPGB3, (Graphics2D)g);
                continue;
            }
            Draw.drawPolygonSymbol((double)aP.X, (double)aP.Y, (Color)FillColor, (Color)OutlineColor, (double)this.barWidth, (double)this.barHeight, (Boolean)DrawFill, (Boolean)DrawOutline, (Graphics2D)g);
        }
        g.setStroke(new BasicStroke(this.neatLineSize));
        g.setColor(this.neatLineColor);
        if (this.extendRect && this.extendType == ExtendType.NONE) {
            g.draw(new Rectangle2D.Double(x_shift, 0.0, this.barWidth, this.barHeight * (float)bNum));
        } else {
            switch (this.extendType) {
                case BOTH: {
                    Path2D.Double p = new Path2D.Double();
                    ((Path2D)p).moveTo(this.barWidth / 2.0f + x_shift, 0.0);
                    ((Path2D)p).lineTo(x_shift, extendLength);
                    ((Path2D)p).lineTo(x_shift, extendLength + this.barHeight * (float)(bNum - 2));
                    ((Path2D)p).lineTo(this.barWidth / 2.0f + x_shift, this.legendHeight);
                    ((Path2D)p).lineTo(this.barWidth + x_shift, extendLength + this.barHeight * (float)(bNum - 2));
                    ((Path2D)p).lineTo(this.barWidth + x_shift, extendLength);
                    p.closePath();
                    g.draw(p);
                    break;
                }
                case MAX: {
                    Path2D.Double p = new Path2D.Double();
                    ((Path2D)p).moveTo(this.barWidth / 2.0f + x_shift, 0.0);
                    ((Path2D)p).lineTo(x_shift, extendLength);
                    ((Path2D)p).lineTo(x_shift, this.legendHeight);
                    ((Path2D)p).lineTo(this.barWidth + x_shift, this.legendHeight);
                    ((Path2D)p).lineTo(this.barWidth + x_shift, extendLength);
                    p.closePath();
                    g.draw(p);
                    break;
                }
                case MIN: {
                    Path2D.Double p = new Path2D.Double();
                    ((Path2D)p).moveTo(x_shift, 0.0);
                    ((Path2D)p).lineTo(x_shift, this.barHeight * (float)(bNum - 1));
                    ((Path2D)p).lineTo(this.barWidth / 2.0f + x_shift, this.barHeight * (float)(bNum - 1) + extendLength);
                    ((Path2D)p).lineTo(this.barWidth + x_shift, this.barHeight * (float)(bNum - 1));
                    ((Path2D)p).lineTo(this.barWidth + x_shift, 0.0);
                    p.closePath();
                    g.draw(p);
                    break;
                }
                default: {
                    g.draw(new Rectangle2D.Double(x_shift, 0.0, this.barWidth, this.barHeight * (float)bNum));
                }
            }
        }
        g.setStroke(new BasicStroke(this.tickWidth));
        aP.X = this.barWidth / 2.0f + x_shift;
        if (aLS.getLegendType() == LegendType.UNIQUE_VALUE) {
            aP.Y = (float)this.legendHeight + this.barHeight / 2.0f;
            sP.X = aP.X + (double)(this.barWidth / 2.0f) + 5.0;
        } else {
            aP.Y = this.legendHeight;
            sP.X = aP.X + (double)(this.barWidth / 2.0f);
        }
        sP.Y = aP.Y;
        float tickLen = this.tickLength;
        if (this.insideTick && this.barWidth < tickLen) {
            tickLen = (int)this.barWidth;
        }
        g.setFont(this.tickLabelFont);
        int idx = 0;
        double sY = sP.Y;
        switch (this.extendType) {
            case MIN: 
            case BOTH: {
                sY = sY + (double)this.barHeight - (double)extendLength;
            }
        }
        aPGB = labelIdxs.iterator();
        while (aPGB.hasNext()) {
            int i = (Integer)aPGB.next();
            sP.Y = sY - (double)(this.barHeight * (float)(i + 1));
            ColorBreak cb = (ColorBreak)aLS.getLegendBreaks().get(i);
            String caption = this.autoTick ? (aLS.getLegendType() == LegendType.UNIQUE_VALUE ? cb.getCaption() : DataConvert.removeTailingZeros((String)cb.getEndValue().toString())) : (String)tLabels.get(idx);
            if (aLS.getLegendType() == LegendType.UNIQUE_VALUE) {
                g.setColor(this.tickLabelColor);
                Draw.drawString((Graphics2D)g, (double)sP.X, (double)sP.Y, (String)caption, (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
            } else if (this.autoTick) {
                if (i < bNum - 1) {
                    g.setColor(this.tickColor);
                    aP = this.drawTickLine(g, sP.X, sP.Y, tickLen, false, 0.0);
                    g.setColor(this.tickLabelColor);
                    Draw.drawString((Graphics2D)g, (double)aP.X, (double)aP.Y, (String)caption, (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                    if (i == 0) {
                        switch (this.extendType) {
                            case MAX: 
                            case NEITHER: {
                                if (tickGap != 1) break;
                                g.setColor(this.tickColor);
                                aP = this.drawTickLine(g, sP.X, sP.Y, tickLen, false, this.barHeight);
                                caption = DataConvert.removeTailingZeros((String)cb.getStartValue().toString());
                                g.setColor(this.tickLabelColor);
                                Draw.drawString((Graphics2D)g, (double)aP.X, (double)(aP.Y + (double)this.barHeight), (String)caption, (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                            }
                        }
                    }
                } else {
                    switch (this.extendType) {
                        case MIN: 
                        case NEITHER: {
                            g.setColor(this.tickColor);
                            aP = this.drawTickLine(g, sP.X, sP.Y, tickLen, false, 0.0);
                            g.setColor(this.tickLabelColor);
                            Draw.drawString((Graphics2D)g, (double)aP.X, (double)aP.Y, (String)caption, (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
                        }
                    }
                }
            } else if (i == 0 && this.tickLocations.get(idx) == Double.parseDouble(cb.getStartValue().toString())) {
                g.setColor(this.tickColor);
                aP = this.drawTickLine(g, sP.X, sP.Y, tickLen, false, this.barHeight);
                g.setColor(this.tickLabelColor);
                Draw.drawString((Graphics2D)g, (double)aP.X, (double)(aP.Y + (double)this.barHeight), (String)caption, (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
            } else {
                g.setColor(this.tickColor);
                aP = this.drawTickLine(g, sP.X, sP.Y, tickLen, false, 0.0);
                g.setColor(this.tickLabelColor);
                Draw.drawString((Graphics2D)g, (double)aP.X, (double)aP.Y, (String)caption, (XAlign)XAlign.LEFT, (YAlign)YAlign.CENTER, (float)this.tickLabelAngle, (boolean)true);
            }
            ++idx;
        }
        if (this.label != null) {
            g.setFont(this.label.getFont());
            g.setColor(this.label.getColor());
            Dimension dim = Draw.getStringDimension((String)this.label.getText(), (Graphics2D)g);
            switch (this.labelLocation) {
                case "top": {
                    double sx = 0.0;
                    double sy = -5.0;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.LEFT, (YAlign)YAlign.BOTTOM, (boolean)this.label.isUseExternalFont());
                    break;
                }
                case "bottom": {
                    double sx = 0.0;
                    double sy = this.legendHeight + 5;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.LEFT, (YAlign)YAlign.TOP, (boolean)this.label.isUseExternalFont());
                    break;
                }
                case "left": 
                case "in": {
                    double sx = 0.0;
                    double sy = (double)this.legendHeight * 0.5;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)90.0f, (boolean)this.label.isUseExternalFont());
                    break;
                }
                default: {
                    double sx = this.width - dim.height;
                    double sy = (double)this.legendHeight * 0.5;
                    Draw.drawString((Graphics2D)g, (double)sx, (double)sy, (String)this.label.getText(), (XAlign)XAlign.CENTER, (YAlign)YAlign.TOP, (float)90.0f, (boolean)this.label.isUseExternalFont());
                }
            }
        }
    }

    @Override
    public Dimension getLegendDimension(Graphics2D g, Dimension limitDim) {
        if (this.legendScheme != null) {
            block0 : switch (this.orientation) {
                case VERTICAL: {
                    this.width = (int)((float)this.getTickWidth(g) + (float)limitDim.height * this.shrink / (float)this.aspect + 5.0f);
                    if (!this.insideTick) {
                        this.width = (int)((float)this.width + this.tickLength);
                    }
                    this.legendWidth = this.width;
                    this.legendHeight = this.height;
                    if (this.label == null) break;
                    g.setFont(this.label.getFont());
                    Dimension dim = Draw.getStringDimension((String)this.label.getText(), (Graphics2D)g);
                    switch (this.labelLocation) {
                        case "top": 
                        case "bottom": {
                            this.width = Math.max(this.width, dim.width);
                            break block0;
                        }
                    }
                    this.width = (int)((float)this.width + ((float)dim.height + this.labelShift));
                    break;
                }
                default: {
                    g.setFont(this.tickLabelFont);
                    this.height = (int)((float)this.getTickHeight(g) + (float)limitDim.width * this.shrink / (float)this.aspect + 5.0f);
                    if (!this.insideTick) {
                        this.height = (int)((float)this.height + this.tickLength);
                    }
                    this.legendWidth = this.width;
                    this.legendHeight = this.height;
                    if (this.label == null) break;
                    g.setFont(this.label.getFont());
                    Dimension dim = Draw.getStringDimension((String)this.label.getText(), (Graphics2D)g);
                    switch (this.labelLocation) {
                        case "right": 
                        case "left": {
                            break block0;
                        }
                    }
                    this.height = (int)((float)this.height + ((float)dim.height + this.labelShift));
                }
            }
        }
        return new Dimension(this.width, this.height);
    }
}

