/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.optim;

import org.apache.commons.math4.legacy.core.IntegerSequence;
import org.apache.commons.math4.legacy.exception.TooManyEvaluationsException;
import org.apache.commons.math4.legacy.exception.TooManyIterationsException;
import org.apache.commons.math4.legacy.optim.ConvergenceChecker;
import org.apache.commons.math4.legacy.optim.OptimizationProblem;

public abstract class AbstractOptimizationProblem<PAIR>
implements OptimizationProblem<PAIR> {
    private static final MaxEvalCallback MAX_EVAL_CALLBACK = new MaxEvalCallback();
    private static final MaxIterCallback MAX_ITER_CALLBACK = new MaxIterCallback();
    private final int maxEvaluations;
    private final int maxIterations;
    private final ConvergenceChecker<PAIR> checker;

    protected AbstractOptimizationProblem(int maxEvaluations, int maxIterations, ConvergenceChecker<PAIR> checker) {
        this.maxEvaluations = maxEvaluations;
        this.maxIterations = maxIterations;
        this.checker = checker;
    }

    @Override
    public IntegerSequence.Incrementor getEvaluationCounter() {
        return IntegerSequence.Incrementor.create().withMaximalCount(this.maxEvaluations).withCallback((IntegerSequence.Incrementor.MaxCountExceededCallback)MAX_EVAL_CALLBACK);
    }

    @Override
    public IntegerSequence.Incrementor getIterationCounter() {
        return IntegerSequence.Incrementor.create().withMaximalCount(this.maxIterations).withCallback((IntegerSequence.Incrementor.MaxCountExceededCallback)MAX_ITER_CALLBACK);
    }

    @Override
    public ConvergenceChecker<PAIR> getConvergenceChecker() {
        return this.checker;
    }

    private static class MaxIterCallback
    implements IntegerSequence.Incrementor.MaxCountExceededCallback {
        private MaxIterCallback() {
        }

        public void trigger(int max) {
            throw new TooManyIterationsException((Number)max);
        }
    }

    private static class MaxEvalCallback
    implements IntegerSequence.Incrementor.MaxCountExceededCallback {
        private MaxEvalCallback() {
        }

        public void trigger(int max) {
            throw new TooManyEvaluationsException((Number)max);
        }
    }
}

