#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

PARAMS_COUNT_MIN=3
PARAMS_COUNT_MAX=99

. "${RestrictedDir}"/nxfunct.sh

isRunByNodeOrPlayer

#
# Depending on what is available we will use
# nftables or iptables for network filtering.
#

NETFILTER_MODE=""

if test -x "/sbin/nft"; then
  NETFILTER_MODE="NFT"
  COMMAND_NFT="/sbin/nft"
elif test -x "/usr/sbin/nft"; then
  NETFILTER_MODE="NFT"
  COMMAND_NFT="/usr/sbin/nft"

elif test -x "/sbin/iptables"; then
  NETFILTER_MODE="IPTABLES"
  COMMAND_IPTABLES="/sbin/iptables"
elif test -x "/usr/sbin/iptables"; then
  NETFILTER_MODE="IPTABLES"
  COMMAND_IPTABLES="/usr/sbin/iptables"

else
  ${COMMAND_ECHO} "NX> 500 Error: Network filtering command not found."
  exit 1
fi

#
# We detect whether firewalld or ufw is used as firewall tool.
# We assume that there is only one or another active.
#
# If available, we will use it
# to add virtual interface as trusted.
#

FIREWALL_MODE=""

if test -x "/bin/firewall-cmd"; then
  COMMAND_FIREWALL_CMD="/bin/firewall-cmd"
elif test -x "/usr/bin/firewall-cmd"; then
  COMMAND_FIREWALL_CMD="/usr/bin/firewall-cmd"
fi

if test -x "/sbin/ufw"; then
  COMMAND_UFW="/sbin/ufw"
elif test -x "/usr/sbin/ufw"; then
  COMMAND_UFW="/usr/sbin/ufw"
fi

if [ "${COMMAND_FIREWALL_CMD}" != "" ]; then

  FIREWALLD_OUTPUT="$(${COMMAND_FIREWALL_CMD} --state)"

  if [ "${FIREWALLD_OUTPUT}" == "running" ]; then
    FIREWALL_MODE="FIREWALLD"
  fi

fi

if [ "${FIREWALL_MODE}" == "" ] && \
       [ "${COMMAND_UFW}" != "" ]; then

  #
  # UFW needs PATH to be set correctly,
  # which is not always the case when script is called.
  #

  if [ -z "${PATH}" ]; then
    export PATH="/sbin:/bin:/usr/sbin:/usr/bin"
  fi

  UFW_OUTPUT="$(${COMMAND_UFW} status | \
      ${COMMAND_GREP} -E "Status: active|Status: inactive")"

  if [ "${UFW_OUTPUT}" == "Status: active" ]; then
    FIREWALL_MODE="UFW"
  fi

fi

#
# User parameters.
#

TAP_INTERFACE="${3}"

for par in "${@:4}"; do
  if test "x${par}" != "x--skip_iptables"; then
    GATEWAYS[${#GATEWAYS[*]}]=${par}
  fi
done

#
# Table name for nftables.
#

if [ "${NETFILTER_MODE}" == "NFT" ]; then
  TABLE_NAME="nxvpn_${TAP_INTERFACE}"
fi

#
# Directory to backup current / restore old settings.
#

NX_VPN_TEMP="${NX_ROOT}/var/tmp/nxvpn"

if [ ! -d "${NX_VPN_TEMP}" ]; then
  ${COMMAND_MKDIR} "${NX_VPN_TEMP}"
fi

IP_FORWARD="/proc/sys/net/ipv4/ip_forward"
NX_IP_FORWARD="${NX_VPN_TEMP}/nxtemp_ip_forward_${TAP_INTERFACE}"
