#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxsshhostcertrestore.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=4

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

ALGORITHM=$3
TYPE=$4

SSH_HOST_DSA_KEY="/etc/ssh/ssh_host_dsa_key"
SSH_HOST_RSA_KEY="/etc/ssh/ssh_host_rsa_key"
SSH_HOST_ECDSA_KEY="/etc/ssh/ssh_host_ecdsa_key"
SSH_HOST_ED25519_KEY="/etc/ssh/ssh_host_ed25519_key"

if [[ "$ALGORITHM" == "DSA" ]]; then
  FILE=$SSH_HOST_DSA_KEY
elif [[ "$ALGORITHM" == "RSA" ]]; then
  FILE=$SSH_HOST_RSA_KEY
elif [[ "$ALGORITHM" == "ECDSA" ]]; then
  FILE=$SSH_HOST_ECDSA_KEY
elif [[ "$ALGORITHM" == "ED25519" ]]; then
  FILE=$SSH_HOST_ED25519_KEY
else
  errorMsg "Unknow ssh host key." "1"
fi

MODE="600"

if [[ "$TYPE" == "public" ]]; then
  MODE="644"
  FILE="${FILE}.pub"
fi

FILE_EMPTY="$FILE.empty"
FILE_BACKUP="$FILE.backup"

if [ -f "$FILE_EMPTY" ]; then
  ${COMMAND_RM} -f "$FILE" "$FILE_EMPTY"

  if [ $? -eq 0 ]; then
    ${COMMAND_ECHO} "File '$FILE' removed successfully."
  else
    errorMsg "Failed to remove the file '$FILE' $?" "1"
  fi
elif [ -f "$FILE_BACKUP" ]; then
  ${COMMAND_MV} -f "$FILE_BACKUP" "$FILE"

  if [ $? -eq 0 ]; then
    ${COMMAND_ECHO} "File '$FILE' restored successfully."

    ${COMMAND_CHMOD} "$MODE" "$FILE"

    if [ $? -eq 0 ]; then
      ${COMMAND_ECHO} "File '$FILE' permissions changed successfully."
    else
      errorMsg "Failed to change the file permissions '$FILE' $?" "1"
    fi
  else
    errorMsg "Failed to restore the file '$FILE' $?" "1"
  fi
else
  ${COMMAND_ECHO} "Nothing to restore for the file '$FILE'."
fi

exit 0;



