#!/bin/bash

#
# This script accepts any of the following IDs as input parameters.
#
# The custom message specified in the script will be displayed at the end of the NoMachine default message and will be not translated.
#
# The list of the customizable messages and their ID is:
#
# 1  - Reached the maximum number of concurrent virtual sessions on all nodes.
# 2  - Reached the maximum number of concurrent virtual sessions on this server.
# 3  - Maximum number of virtual sessions reached for user: <user>.
# 4  - Reached the maximum number of concurrent virtual sessions on node <node>.
# 5  - Reached the maximum number of concurrent sessions on this server.
# 6  - Reached the maximum number of concurrent sessions on node <node>.
# 7  - Reached the maximum number of allowed users on this server.
# 8  - Not enough X resources.
# 9  - Reached the maximum number of concurrent guest users on this server.
# 10 - Reached the maximum number of allowed guests.
# 11 - Reached the maximum number of sessions for this guest user.
#

messageId=$1

#
# If error message is related to limits.
#

if [[ $messageId -ge 1 ]] && [[ $messageId -le 11 ]]; then
  echo "Custom message."
fi

exit 0