#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxamixer.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=5

. "${RestrictedDir}"/nxfunct.sh

isRunByServerOrNode

COMMAND_AMIXER="none"

if [ -x "/bin/amixer" ];
then
  COMMAND_AMIXER="/bin/amixer"
elif [ -x "/usr/bin/amixer" ];
then
  COMMAND_AMIXER="/usr/bin/amixer"
elif [ -x "/usr/sbin/amixer" ];
then
  COMMAND_AMIXER="/usr/sbin/amixer"
elif [ -x "/usr/local/bin/amixer" ];
then
  COMMAND_AMIXER="/usr/local/bin/amixer"
fi

if [ "$COMMAND_AMIXER" = "none" ];
then
  exit 1
fi

ACTION="$3"
IDS="$4"
VOLUMES="$5"

RETIDS=""
RETVOLUMES=""

RET=1

if [ "x$ACTION" = "xmute" ];
then
  #geting corresponding card id
  for dev in $($COMMAND_LS /dev/snd | $COMMAND_GREP controlC | $COMMAND_SED -e 's/controlC//g');
  do

    if [ "x$RETIDS" = "x" ];
    then
      RETIDS=$dev
    else
      RETIDS="$RETIDS,$dev"
    fi

    vol=""

    #
    #actully, alsa card volume consists all the volumes of
    #card's controls which names coontains "Playback volume"
    #number of that kind of controls differs in different cards
    # ex:
    #
    # numid=12,iface=MIXER,name='Master Playback Volume'
    # numid=56,iface=MIXER,name='PCM Playback Volume'
    # numid=1,iface=MIXER,name='Front Playback Volume'
    # numid=3,iface=MIXER,name='Bass Speaker Playback Volume'


    #
    #getting for each card corresponding controls and
    #their previous values nad concatenate it into vol variable
    #then set each control volume to 0%
    #
    # getting values ex:
    # amixer -c 0 cget numid=12|grep ": values"|sed -e 's/,.*//'
    #
    # cget output example:
    # amixer -c 0 cget numid=56
    # numid=56,iface=MIXER,name='PCM Playback Volume'
    #   ; type=INTEGER,access=rw---RW-,values=2,min=0,max=255,step=0
    #   : values=255,255
    #   | dBscale-min=-51.00dB,step=0.20dB,mute=0
    #
    #vol will be "numid=56%255,255"

    # alsa card also consists IEC958 card's which controls digital 
    # audio ex:
    # for speaker connected via HDMI

    for numid in $($COMMAND_AMIXER -c $dev controls | $COMMAND_GREP "Playback Volume" | $COMMAND_SED -e 's/,.*//');
    do
      values=$($COMMAND_AMIXER -c $dev cget $numid | $COMMAND_GREP ": values" | $COMMAND_SED -e 's/.*=//')
      values="$numid%$values"

      if [ "x$vol" = "x" ];
      then
        vol=$values
      else
        vol="$vol-$values"
      fi

      $COMMAND_AMIXER -c $dev cset $numid 0% 2>&1 1>/dev/null
    done

    # mute IEC958 if present
    if $COMMAND_AMIXER get IEC958 >/dev/null 2>&1;
    then
      $COMMAND_AMIXER set IEC958 mute 2>&1 1>/dev/null 
    fi

    if [ "x$RETVOLUMES" = "x" ];
    then
      RETVOLUMES=$vol
    else
      RETVOLUMES="$RETVOLUMES.$vol"
    fi

  RET=0
  done

  $COMMAND_ECHO $RETIDS $RETVOLUMES

elif [ "x$ACTION" = "xunmute" ];
then

  COUNT=0
  ARRID[$COUNT]=""

  # getting cards ids
  for id in ${IDS//,/ };
  do
    ARRID[$COUNT]=$id

    COUNT=$((COUNT + 1))
  done

  COUNT=0

  #
  #correspindig card controls and their values
  #previously concatenated using "."
  #spliting it for each card
  #

  for vol in ${VOLUMES//\./ };
  do
    #
    #vol example:
    #numid=56%255,255-numid=12%29
    #
    #spliting it into controls id and corresponding values
    #and restore previous values
    #

    for val in ${vol//-/ };
    do
      numid=${val//%*/}
      values=${val//*%/}

      $COMMAND_AMIXER -c ${ARRID[$COUNT]} cset $numid $values unmute 2>&1 1>/dev/null
    done

    # If IEC958 exists on this card, unmute it
    if $COMMAND_AMIXER get IEC958 >/dev/null 2>&1; 
    then
      $COMMAND_AMIXER set IEC958 unmute 2>&1 1>/dev/null
    fi

    COUNT=$((COUNT + 1))
  done

  RET=0

fi

exit $RET
