#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2002, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxtun.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT_MIN=5
PARAMS_COUNT_MAX=6


. "${RestrictedDir}"/nxfunct.sh

isRunByNodeOrPlayer

if test -x "/sbin/ip"; then
  COMMAND_IP="/sbin/ip"
elif test -x "/bin/ip"; then
  COMMAND_IP="/bin/ip"
elif test -x "/usr/sbin/ip"; then
  COMMAND_IP="/usr/sbin/ip"
else
  if test -x "/sbin/ifconfig"; then
    COMMAND_IP=""
    COMMAND_IFCONFIG="/sbin/ifconfig"
  else
    echo "NX> 500 Error: ifconfig nor ip command not found."
    exit 1
  fi
fi

if test -x "/sbin/sleep"; then
  COMMAND_SLEEP="/sbin/sleep"
elif test -x "/bin/sleep"; then
  COMMAND_SLEEP="/bin/sleep"
else
  errorCommandNotFound "sleep" "1"
fi

errorMsg ()
{
  ${COMMAND_ECHO} "NX> 500 Error: $1"
  if test "x$2" = "x1"; then
    exit 1
  fi
}

if test -e "/etc/NX/player/localhost/player.cfg"; then
  BIN_DIR=$($COMMAND_AWK -F'"' '/^PlayerRoot/ {print $2}' /etc/NX/player/localhost/player.cfg)
elif test -e "/etc/NX/server/localhost/node.cfg"; then
  BIN_DIR=$($COMMAND_AWK -F'"' '/^NodeRoot/ {print $2}' /etc/NX/server/localhost/node.cfg)
elif test -e "/etc/NX/node/localhost/node.cfg"; then
  BIN_DIR=$($COMMAND_AWK -F'"' '/^NodeRoot/ {print $2}' /etc/NX/node/localhost/node.cfg)
else
  errorMsg "Cannot stat files: /etc/NX/player/localhost/player.cfg and /etc/NX/server/localhost/node.cfg." "1"
fi

NX_BIN="/bin/"

NXTUNCTL_NAME="nxtunctl"
NXTUNCTL_NAME_PATH="$BIN_DIR$NX_BIN$NXTUNCTL_NAME"

addInterface()
{
  MASK="$3"

  if [[ "$MASK" == "" ]]; then
    MASK="255.255.255.252"
  fi

  STATUS=`$NXTUNCTL_NAME_PATH -u $1 -b`
  ${COMMAND_SLEEP} 1

  if test "x$STATUS" == "x"; then
    errorMsg "nxtunctl running error." "1"
  else
    if test "${COMMAND_IP}" != ""; then
      #
      # Use ip command.
      #

      ${COMMAND_IP} link set dev ${STATUS} up
      ${COMMAND_IP} addr add ${2}/$MASK dev ${STATUS}

      #
      # Get MAC address of created interface.
      #

      mac=$(${COMMAND_IP} addr)

      mac=${mac#*${STATUS}*link/ether}
    else
      #
      # Use ifconfig command.
      #

      ${COMMAND_IFCONFIG} $STATUS $2 netmask $MASK up

      #
      # Get MAC address of created interface.
      #

      mac=$(${COMMAND_IFCONFIG})

      #
      # Depends on distribution, there are
      # different keywords in front of MAC address.
      #

      if [[ ${mac} == *"HWaddr"* ]]; then
        mac=${mac#*${STATUS}*HWaddr}
      elif [[ ${mac} == *"ether"* ]]; then
        mac=${mac#*${STATUS}*ether}
      else
        echo "NX> 500 Error: Cannot find MAC address"
        exit 1
      fi
    fi

    mac=$(${COMMAND_ECHO} $mac | ${COMMAND_CUT} -d ' ' -f 1)

    mac=${mac//":"/""}

    ${COMMAND_ECHO} "$STATUS|$mac"
  fi

  return 0;
}

changeName()
{
  #
  # Bring interface down.
  #

  ${COMMAND_IP} link set dev $1 down

  #
  # Set new name on interface.
  #

  ${COMMAND_IP} link set dev $1 name $2

  #
  # Bring interface up with new name.
  #

  ${COMMAND_IP} link set dev $2 up

  return 0;
}

setStaticArp()
{
  #
  # Check if virtual interface exists.
  #

  if test "$1" = "" || test "$2" = "" || test "$3" = ""; then
    ${COMMAND_ECHO} "NX> 500 Error: One or more of the args are empty."
  exit 1
  fi

  #
  # Check if the ARP table includes an entry for the virtual interface.
  #

  COUNTARP=`${COMMAND_IP} neigh | \
          ${COMMAND_GREP} -c $3`

  if test "${COUNTARP}" == "0"; then
    ${COMMAND_ECHO} "Cannot find device $3 in ARP table. Adding ARP entry."

    ${COMMAND_IP} neigh add $1 lladdr $2 dev $3 nud permanent
  else
    ${COMMAND_IP} neigh replace $1 lladdr $2 dev $3 nud permanent
  fi

  return 0;
}

case "$3" in
'--add')       addInterface "$4" "$5" "$6"       ;;
'--change')    changeName "$4" "$5"              ;;
'--arp')       setStaticArp "$4" "$5" "$6"       ;;
esac

