#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxlsof.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=3

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

if test -x "/bin/lsof"; then
  COMMAND_LSOF="/bin/lsof"
elif test -x "/usr/bin/lsof"; then
  COMMAND_LSOF="/usr/bin/lsof"
elif test -x "/usr/sbin/lsof"; then
  COMMAND_LSOF="/usr/sbin/lsof"
else
  errorCommandNotFound "lsof" "1"
fi

DIRECTORY="$3"
FILE_NAME="nxserver.log.1"

if test "x${DIRECTORY}" = "x"; then
  errorMsg "Missing file directory parameter." "1"
fi

if test ! -d "${DIRECTORY}"; then
  errorMsg "Directory ${DIRECTORY} does not exist." "1"
fi

FILE_PATH="${DIRECTORY}/${FILE_NAME}"

if test -f "${FILE_PATH}"; then
  ${COMMAND_LSOF} -V -F p "${FILE_PATH}"
else
  errorMsg "File ${FILE_PATH} does not exist." "1"
fi

exit $?
