/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2011-2019 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
2017-05-18 Jeff Heylmun:    Added support of polydisperse phase models
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::dragModels::SyamlalOBrien

Description
    Syamlal et al. (1993) drag law.

    Reference
    \verbatim
        "MFIX documentation, Theory Guide"
        Syamlal, M., Rogers, W. and O'Brien, T. J. 
        Technical Note DOE/METC-94/1004. Morgantown, West Virginia, USA, 1993
    \endverbatim

SourceFiles
    SyamlalOBrien.C

\*---------------------------------------------------------------------------*/

#ifndef SyamlalOBrien_H
#define SyamlalOBrien_H

#include "dragModel.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

class phasePair;

namespace dragModels
{

/*---------------------------------------------------------------------------*\
                           Class SyamlalOBrien Declaration
\*---------------------------------------------------------------------------*/

class SyamlalOBrien
:
    public dragModel
{
public:

    //- Runtime type information
    TypeName("SyamlalOBrien");


    // Constructors

        //- Construct from a dictionary and a phase pair
        SyamlalOBrien
        (
            const dictionary& dict,
            const phasePair& pair,
            const bool registerObject
        );


    //- Destructor
    virtual ~SyamlalOBrien();


    // Member Functions

        //- Drag coefficient
        virtual tmp<volScalarField> CdRe(const label, const label) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace dragModels
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
