/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2025 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "sphericalTensor2D.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

template<>
const char* const
Foam::SphericalTensor2D<Foam::scalar>::vsType::typeName = "sphericalTensor2D";


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#undef  defineTraits
#define defineTraits(Type, Prefix)                                            \
                                                                              \
template<>                                                                    \
const char* const                                                             \
Foam::SphericalTensor2D<Type>::vsType::componentNames[] = { "ii" };           \
                                                                              \
template<>                                                                    \
const Foam::SphericalTensor2D<Type>                                           \
Foam::SphericalTensor2D<Type>::vsType::zero                                   \
(                                                                             \
    SphericalTensor2D<Type>::uniform(0)                                       \
);                                                                            \
                                                                              \
template<>                                                                    \
const Foam::SphericalTensor2D<Type>                                           \
Foam::SphericalTensor2D<Type>::vsType::one                                    \
(                                                                             \
    SphericalTensor2D<Type>::uniform(1)                                       \
);                                                                            \
                                                                              \
template<>                                                                    \
const Foam::SphericalTensor2D<Type>                                           \
Foam::SphericalTensor2D<Type>::vsType::max                                    \
(                                                                             \
    SphericalTensor2D<Type>::uniform(Prefix##VGREAT)                          \
);                                                                            \
                                                                              \
template<>                                                                    \
const Foam::SphericalTensor2D<Type>                                           \
Foam::SphericalTensor2D<Type>::vsType::min                                    \
(                                                                             \
    SphericalTensor2D<Type>::uniform(-Prefix##VGREAT)                         \
);                                                                            \
                                                                              \
template<>                                                                    \
const Foam::SphericalTensor2D<Type>                                           \
Foam::SphericalTensor2D<Type>::vsType::rootMax                                \
(                                                                             \
    SphericalTensor2D<Type>::uniform(Prefix##ROOTVGREAT)                      \
);                                                                            \
                                                                              \
template<>                                                                    \
const Foam::SphericalTensor2D<Type>                                           \
Foam::SphericalTensor2D<Type>::vsType::rootMin                                \
(                                                                             \
    SphericalTensor2D<Type>::uniform(-Prefix##ROOTVGREAT)                     \
);                                                                            \
                                                                              \
                                                                              \
template<>                                                                    \
const Foam::SphericalTensor2D<Type>                                           \
Foam::SphericalTensor2D<Type>::I(1);                                          \
                                                                              \
template<>                                                                    \
const Foam::SphericalTensor2D<Type>                                           \
Foam::SphericalTensor2D<Type>::oneThirdI(1.0/3.0);                            \
                                                                              \
template<>                                                                    \
const Foam::SphericalTensor2D<Type>                                           \
Foam::SphericalTensor2D<Type>::twoThirdsI(2.0/3.0);


// defineTraits(float, floatScalar);
// defineTraits(double, doubleScalar);

defineTraits(Foam::scalar, );

#undef defineTraits

// ************************************************************************* //
