/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2025 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

// template<class Type>
// Foam::tmp<Foam::Field<Type>> Foam::decompositionGAMGAgglomeration::sum
// (
//     const UList<Type>& fld,
//     const label nCoarse,
//     const labelUList& oldToNew
// )
// {
//     if (fld.empty())
//     {
//         return nullptr;
//     }
//     tmp<Field<Type>> tresult(new Field<Type>(nCoarse, Zero));
//     auto& result = tresult.ref();

//     forAll(oldToNew, celli)
//     {
//         const label compactCelli = oldToNew[celli];
//         if (compactCelli != -1)
//         {
//             result[compactCelli] += fld[celli];
//         }
//     }
//     return tresult;
// }


template<class Type>
Foam::tmp<Foam::Field<Type>> Foam::decompositionGAMGAgglomeration::avg
(
    const UList<Type>& fld,
    const label nCoarse,
    const labelUList& oldToNew
)
{
    if (fld.empty())
    {
        return nullptr;
    }

    auto tresult = tmp<Field<Type>>::New(nCoarse, Zero);
    auto& result = tresult.ref();
    labelList n(nCoarse, 0);

    forAll(oldToNew, celli)
    {
        const label compactCelli = oldToNew[celli];
        if (compactCelli != -1)
        {
            result[compactCelli] += fld[celli];
            n[compactCelli]++;
        }
    }

    forAll(result, i)
    {
        result[i] /= n[i];
    }

    return tresult;
}


// ************************************************************************* //
