/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2020 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::fileFormats::ABAQUSsurfaceFormatCore

Description
    Internal class used by the ABAQUSsurfaceFormat

SourceFiles
    ABAQUSsurfaceFormatCore.C

\*---------------------------------------------------------------------------*/

#ifndef ABAQUSsurfaceFormatCore_H
#define ABAQUSsurfaceFormatCore_H

#include "Fstream.H"
#include "Ostream.H"
#include "MeshedSurface.H"
#include "DynamicList.H"
#include "ABAQUSCore.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace fileFormats
{

/*---------------------------------------------------------------------------*\
            Class fileFormats::ABAQUSsurfaceFormatCore Declaration
\*---------------------------------------------------------------------------*/

class ABAQUSsurfaceFormatCore
:
    public ABAQUSCore
{
protected:

    // Protected Static Member Functions
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fileFormats
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
