/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2011-2025 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "dispersedWallLubricationModel.H"
#include "fvcCurl.H"
#include "fvcFlux.H"
#include "surfaceInterpolate.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::wallLubricationModels::dispersedWallLubricationModel::
dispersedWallLubricationModel
(
    const dictionary& dict,
    const phaseInterface& interface
)
:
    wallLubricationModel(dict, interface),
    interface_
    (
        interface.modelCast<wallLubricationModel, dispersedPhaseInterface>()
    )
{}


// * * * * * * * * * * * * * * * * Destructor  * * * * * * * * * * * * * * * //

Foam::wallLubricationModels::dispersedWallLubricationModel::
~dispersedWallLubricationModel()
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

Foam::tmp<Foam::volVectorField>
Foam::wallLubricationModels::dispersedWallLubricationModel::F() const
{
    return
        interface_.sign()
       *interface_.dispersed()
       *Fi();
}


Foam::tmp<Foam::surfaceScalarField>
Foam::wallLubricationModels::dispersedWallLubricationModel::Ff() const
{
    return
        interface_.sign()
       *fvc::interpolate(interface_.dispersed())
       *fvc::flux(Fi());
}


// ************************************************************************* //
