/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2022 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::polyMeshMap

Description
    Class containing mesh-to-mesh mapping information.

SourceFiles
    polyMeshMap.C

\*---------------------------------------------------------------------------*/

#ifndef polyMeshMap_H
#define polyMeshMap_H

#include "polyMesh.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

class meshToMesh;

/*---------------------------------------------------------------------------*\
                       Class polyMeshMap Declaration
\*---------------------------------------------------------------------------*/

class polyMeshMap
{
    // Private Data

        //- Reference to polyMesh
        const polyMesh& mesh_;

        //- Reference to the meshToMesh mapper
        const meshToMesh& mapper_;


public:

    // Constructors

        //- Construct for mesh
        polyMeshMap(const polyMesh& mesh, const meshToMesh& mapper);

        //- Disallow default bitwise copy construction
        polyMeshMap(const polyMeshMap&) = delete;


    // Member Functions

        //- Return polyMesh
        const polyMesh& mesh() const
        {
            return mesh_;
        }

        //- Return meshToMesh mapper
        const meshToMesh& mapper() const
        {
            return mapper_;
        }
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
