/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2025 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

InNamespace
    Foam

Description
    Function with which to merge one dictionary into another. Intended for
    user-facing dictionary merging (e.g., by foamDictionary or similar).

    Supports prepending entries in the source dictionary with '~' to indicate
    that they should be removed in the result. Also supports deactivating
    wildcards and treating regex keywords as literal strings. Also permits a
    table of shortcuts to be provided with which to rename entries.

    Returns whether or not anything changed.

SourceFiles
    mergeDictionaries.C

\*---------------------------------------------------------------------------*/

#ifndef mergeDictionaries_H
#define mergeDictionaries_H

#include "dictionary.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

bool mergeDictionaries
(
    dictionary& tgtDict,
    const dictionary& srcDict,
    const bool wildcards = true,
    const HashTable<wordList, word>& shortcuts = HashTable<wordList, word>(0)
);

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
