/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2023-2025 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::pureThermo

Description
    Base-class for multi-component thermodynamic properties.

See also
    Foam::basicThermo

SourceFiles
    pureThermo.C

\*---------------------------------------------------------------------------*/

#ifndef pureThermo_H
#define pureThermo_H

#include "basicThermo.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                     Class pureThermo Declaration
\*---------------------------------------------------------------------------*/

class pureThermo
:
    virtual public basicThermo
{
public:

    //- Destructor
    virtual ~pureThermo();


    // Member Functions

        //- Get the slicer
        inline nil Yslicer() const;

        //- Get the composition of an internal cell
        inline nil cellComposition
        (
            const nil,
            const label celli
        ) const;

        //- Get the composition of a boundary face
        inline nil patchFaceComposition
        (
            const nil,
            const label patchi,
            const label facei
        ) const;

        //- Get the slicer for the given source
        inline nil Yslicer
        (
            const fvSource& model,
            const volScalarField::Internal& source
        ) const;

        //- Get the slicer for the given source
        inline nil Yslicer
        (
            const fvSource& model,
            const scalarField& source,
            const labelUList& cells
        ) const;

        //- Get the composition of a source cell
        inline nil sourceCellComposition(const nil, const label i) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#include "pureThermoI.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
