/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcVariable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.write.Ncdump;

public final class NcDump {
    private static String SYSTEM_EOL = System.getProperty("line.separator");

    public static void exportCdl(File outputFile, NcDataset ncd) throws IOException {
        NetcdfDataset njdataset = ncd.getNjDatasetUnenhanced();
        if (njdataset == null) {
            njdataset = ncd.getNjDataset();
        }
        PrintWriter writer = new PrintWriter(outputFile);
        String command = "-vall";
        Ncdump.ncdump(njdataset, "-vall", writer, null);
        writer.close();
    }

    public static void exportCdl(File outputFile, NcVariable ncv) throws IOException {
        NcDataset ncd = (NcDataset)ncv.getParent();
        NetcdfDataset ncfile = ncd.getNjDataset();
        VariableDS njvarDS = (VariableDS)ncv.getObject();
        String varFname = njvarDS.getFullName();
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile), 0x100000);
        String command = "-v " + varFname;
        Ncdump.ncdump(ncfile, command, writer, null);
        writer.close();
    }

    public static void exportCsv(File f, NcVariable ncv) throws InvalidRangeException, IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(f), 0x100000);
        VariableDS njvarDS = (VariableDS)ncv.getObject();
        int rank = njvarDS.getRank();
        switch (rank) {
            case 0: {
                NcDump.exportScalar(writer, ncv);
                break;
            }
            case 1: {
                NcDump.exportCsv1D(writer, ncv);
                break;
            }
            default: {
                NcDump.exportCsv2DPlus(writer, ncv);
            }
        }
        writer.close();
    }

    private static final void exportScalar(Writer writer, NcVariable ncv) throws InvalidRangeException, IOException {
        VariableDS njvarDS = (VariableDS)ncv.getObject();
        Array array = njvarDS.read();
        Object o = array.getObject(0);
        NcDump.printObject(writer, o);
        writer.write(SYSTEM_EOL);
    }

    private static final void exportCsv1D(Writer writer, NcVariable ncv) throws InvalidRangeException, IOException {
        VariableDS njvarDS = (VariableDS)ncv.getObject();
        int[] shape = njvarDS.getShape();
        int numCols = shape[0];
        int[] sOrigin = new int[]{0};
        int[] sShape = new int[]{numCols};
        Array slice = njvarDS.read();
        for (int j = 0; j < numCols; ++j) {
            Object o = slice.getObject(j);
            writer.write(o.toString());
            if (j >= numCols - 1) continue;
            writer.write(",");
        }
        writer.write(SYSTEM_EOL);
    }

    private static final void exportCsv2DPlus(Writer writer, NcVariable ncv) throws InvalidRangeException, IOException {
        int rowsThisSlice;
        VariableDS njvarDS = (VariableDS)ncv.getObject();
        int[] shape = njvarDS.getShape();
        int rank = njvarDS.getRank();
        int rankM1 = rank - 1;
        int rankM2 = rank - 2;
        int numRows = shape[rankM2];
        int numCols = shape[rankM1];
        int totalRows = 1;
        for (int i = 0; i < rankM1; ++i) {
            totalRows *= shape[i];
        }
        int[] sOrigin = new int[rank];
        int[] sShape = new int[rank];
        for (int i = 0; i < rankM1; ++i) {
            sOrigin[i] = 0;
            sShape[i] = 1;
        }
        sOrigin[rankM1] = 0;
        sShape[rankM1] = numCols;
        int rowsPerSlice = numRows;
        if (numRows * numCols > 10000000 && (rowsPerSlice = 10000000 / numCols) % 4 > 0) {
            rowsPerSlice -= rowsPerSlice % 4;
        }
        for (int rowNum = 0; rowNum < totalRows; rowNum += rowsThisSlice) {
            if (rankM2 > 0) {
                for (int ii = rankM2; ii > 0; --ii) {
                    if (sOrigin[ii] < shape[ii]) continue;
                    int n = ii - 1;
                    sOrigin[n] = sOrigin[n] + 1;
                    sOrigin[ii] = 0;
                }
                if (sOrigin[rankM2] == 0 && rowNum > 0) {
                    writer.write(SYSTEM_EOL);
                }
            }
            sShape[rankM2] = rowsThisSlice = Math.min(16, numRows - sOrigin[rankM2]);
            Array slice = njvarDS.read(sOrigin, sShape).reduce();
            for (int j = 0; j < rowsThisSlice; ++j) {
                for (int i = 0; i < numCols; ++i) {
                    Object o = slice.getObject(j * numCols + i);
                    writer.write(o.toString());
                    if (i >= numCols - 1) continue;
                    writer.write(",");
                }
                writer.write(SYSTEM_EOL);
            }
            int n = rankM2;
            sOrigin[n] = sOrigin[n] + rowsThisSlice;
        }
    }

    public static void exportLabeledText(File f, NcVariable ncv) throws InvalidRangeException, IOException {
        VariableDS njvarDS = (VariableDS)ncv.getObject();
        int rank = njvarDS.getRank();
        BufferedWriter writer = new BufferedWriter(new FileWriter(f), 0x100000);
        switch (rank) {
            case 0: {
                NcDump.exportScalar(writer, ncv);
                break;
            }
            case 1: {
                NcDump.exportLabeledText1D(writer, ncv);
                break;
            }
            default: {
                NcDump.exportLabeledText2DPlus(writer, ncv);
            }
        }
        writer.close();
    }

    private static final void exportLabeledText1D(Writer writer, NcVariable ncv) throws InvalidRangeException, IOException {
        VariableDS njvarDS = (VariableDS)ncv.getObject();
        int[] shape = njvarDS.getShape();
        NcDimension[] ncdims = ncv.getDimensions();
        Dimension d = njvarDS.getDimension(0);
        writer.write(d.getShortName() + "\t");
        writer.write(njvarDS.getFullName());
        writer.write(SYSTEM_EOL);
        int numCols = shape[0];
        int[] sOrigin = new int[]{0};
        int[] sShape = new int[]{numCols};
        Array slice = njvarDS.read();
        for (int j = 0; j < numCols; ++j) {
            Object o = slice.getObject(j);
            NcDump.printObject(writer, ncdims[0].valueAt(j));
            writer.write("\t");
            NcDump.printObject(writer, o);
            writer.write(SYSTEM_EOL);
        }
    }

    private static final void exportLabeledText2DPlus(Writer writer, NcVariable ncv) throws InvalidRangeException, IOException {
        int rowsThisSlice;
        VariableDS njvarDS = (VariableDS)ncv.getObject();
        int rank = njvarDS.getRank();
        int[] shape = njvarDS.getShape();
        int rankM1 = rank - 1;
        int rankM2 = rank - 2;
        int numRows = shape[rankM2];
        int numCols = shape[rankM1];
        int totalRows = 1;
        for (int i = 0; i < rankM1; ++i) {
            totalRows *= shape[i];
        }
        int[] sOrigin = new int[rank];
        int[] sShape = new int[rank];
        for (int i = 0; i < rankM1; ++i) {
            sOrigin[i] = 0;
            sShape[i] = 1;
        }
        sOrigin[rankM1] = 0;
        sShape[rankM1] = numCols;
        NcDimension[] ncdims = ncv.getDimensions();
        Object[][] dimvals = new Object[rank][];
        for (int i = 0; i < rank; ++i) {
            Dimension d = njvarDS.getDimension(i);
            writer.write(d.getShortName() + "\t");
            dimvals[i] = ncdims[i].getValues();
        }
        writer.write(njvarDS.getFullName());
        writer.write(SYSTEM_EOL);
        int rowsPerSlice = numRows;
        if (numRows * numCols > 10000000 && (rowsPerSlice = 10000000 / numCols) % 4 > 0) {
            rowsPerSlice -= rowsPerSlice % 4;
        }
        for (int rowNum = 0; rowNum < totalRows; rowNum += rowsThisSlice) {
            if (rankM2 > 0) {
                for (int ii = rankM2; ii > 0; --ii) {
                    if (sOrigin[ii] < shape[ii]) continue;
                    int n = ii - 1;
                    sOrigin[n] = sOrigin[n] + 1;
                    sOrigin[ii] = 0;
                }
            }
            sShape[rankM2] = rowsThisSlice = Math.min(16, numRows - sOrigin[rankM2]);
            Array slice = njvarDS.read(sOrigin, sShape).reduce();
            for (int j = 0; j < rowsThisSlice; ++j) {
                for (int i = 0; i < numCols; ++i) {
                    Object o = slice.getObject(j * numCols + i);
                    for (int ii = 0; ii < rankM2; ++ii) {
                        NcDump.printObject(writer, dimvals[ii][sOrigin[ii]]);
                        writer.write("\t");
                    }
                    NcDump.printObject(writer, dimvals[rankM2][sOrigin[rankM2] + j]);
                    writer.write("\t");
                    NcDump.printObject(writer, dimvals[rankM1][i]);
                    writer.write("\t");
                    NcDump.printObject(writer, o);
                    writer.write(SYSTEM_EOL);
                }
            }
            int n = rankM2;
            sOrigin[n] = sOrigin[n] + rowsThisSlice;
        }
    }

    private static final void printObject(Writer writer, Object o) throws IOException {
        if (!(o instanceof Number)) {
            writer.write("\"");
        }
        writer.write(o.toString());
        if (!(o instanceof Number)) {
            writer.write("\"");
        }
    }

    private NcDump() {
    }
}

