/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanStrokePattern implements DescribedItem
{
    NONE("None", null),
    SOLID("Solid", null),
    LONGDASHES("Long Dashes", 10.0f, 4.0f),
    SHORTDASHES("Short Dashes", 5.0f, 3.0f),
    MIXEDDASHES("Mixed Dashes", 10.0f, 3.0f, 5.0f, 3.0f),
    DOTS("Dots", 2.5f, 2.5f),
    DOTDASH("Dot-Dash", 5.0f, 2.5f, 2.5f, 2.5f);

    private final String description_;
    private final float[] pattern_;

    private PanStrokePattern(String description, float ... pattern) {
        this.description_ = description;
        this.pattern_ = pattern;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public float[] getPattern() {
        if (this.pattern_ == null) {
            return null;
        }
        float[] pcopy = new float[this.pattern_.length];
        for (int i = 0; i < this.pattern_.length; ++i) {
            pcopy[i] = this.pattern_[i];
        }
        return pcopy;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    public static PanStrokePattern matching(String str) {
        for (PanStrokePattern item : PanStrokePattern.values()) {
            if (!item.matches(str)) continue;
            return item;
        }
        return SHORTDASHES;
    }
}

