/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import gov.nasa.giss.util.DescribedItem;

public enum SizeVariant implements DescribedItem
{
    REGULAR("regular", 1.0f),
    SMALL("small", 0.9f),
    MINI("mini", 0.9f);

    final String description_;
    final float fontScaling_;

    private SizeVariant(String description, float fontScaling) {
        this.description_ = description;
        this.fontScaling_ = fontScaling;
    }

    public float getFontScaling() {
        return this.fontScaling_;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    public static SizeVariant matching(String str) {
        for (SizeVariant item : SizeVariant.values()) {
            if (!item.matches(str)) continue;
            return item;
        }
        return null;
    }
}

