/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVarVisibility;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcDatasetList
extends NcDataNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public NcDatasetList() {
        super(null);
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public String getName() {
        return "root";
    }

    @Override
    public String getNcType() {
        return "Root";
    }

    @Override
    public String getNjPath() {
        return "[root]";
    }

    @Override
    public String getLongName() {
        return "Root ddataset list";
    }

    @Override
    public String getShortName() {
        return "";
    }

    @Override
    public String getDetail(boolean enhanced) {
        return "";
    }

    @Override
    public String getDetailType() {
        return "text/plain";
    }

    public int addDataset(NcDataset ncd, NcVarVisibility visibleVarClass) {
        ncd.setVisibleVarClass(null, visibleVarClass);
        return this.addSorted(ncd);
    }

    public boolean removeDataset(NcDataset ncd) {
        int index = this.getIndex(ncd);
        if (index < 0) {
            LOGGER.warn("Trying to remove NcDataNode which is not child of dataset list.");
            return false;
        }
        try {
            this.remove(index);
            return true;
        }
        catch (Exception exc) {
            LOGGER.error(exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return false;
        }
    }

    @Override
    protected int addSorted(NcDataNode node) {
        if (!(node instanceof NcDataset)) {
            throw new NcException("Node must be an NcDataset in order to add it to NcDatalist.");
        }
        return super.addSorted(node);
    }
}

