/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class Eckert3
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Eckert III";
    private static final double CONST_A = 2.0 / Math.sqrt(22.43597501544853);
    private static final double INV_A = 1.0 / CONST_A;
    private static final double MAX_X_OVER_RS = 2.0 * CONST_A * Math.PI;
    private static final double MAX_Y_OVER_RS = CONST_A * Math.PI;

    public Eckert3(int width, int height) {
        this(width, height, 0, 0);
    }

    public Eckert3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double twoPhiOverPi = phiRad * 0.6366197723675814;
        double x = CONST_A * lambdaRad * (1.0 + Math.sqrt(1.0 - twoPhiOverPi * twoPhiOverPi));
        double y = CONST_A * 2.0 * phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = y * 0.5 * this.invRS_ * INV_A;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double twoPhiOverPi = phiRad * 0.6366197723675814;
        double lambdaRad = x * INV_A * this.invRS_ / (1.0 + Math.sqrt(1.0 - twoPhiOverPi * twoPhiOverPi));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Eckert3 eckert3 = this;
        synchronized (eckert3) {
            double y;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = (y = (double)iy + 0.5) * 0.5 * this.invRS_ * INV_A) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double twoPhiOverPi = phiRad * 0.6366197723675814;
                double xFactor = INV_A * this.invRS_ / (1.0 + Math.sqrt(1.0 - twoPhiOverPi * twoPhiOverPi));
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda > 179.99999) {
            return;
        }
        Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
        if (dotEq == null) {
            return;
        }
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        if (Math.abs(dotN.x - dotEq.x) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
            return;
        }
        Point2D.Double dotNP = maxLat > 89.99999 ? dotN : this.transformLL2XY(lon, 90.0);
        Point2D.Double dotSP = maxLat > 89.99999 ? dotS : this.transformLL2XY(lon, -90.0);
        double hw = Math.abs(dotEq.x - dotNP.x);
        double rectX = dotNP.x - hw;
        double rectW = 2.0 * hw;
        double rectH = dotSP.y - dotNP.y;
        if (dotEq.x > dotN.x) {
            GraphicUtils.drawEllipticArc(g2d, rectX, dotNP.y, rectW, rectH, dotS, dotN);
        } else {
            GraphicUtils.drawEllipticArc(g2d, rectX, dotNP.y, rectW, rectH, dotN, dotS);
        }
    }
}

