/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.cl;

import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.cl.PCLVariable;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.task.PanOpenDatasetTask;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class PCLDataset {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Marker FATAL = MarkerFactory.getMarker("FATAL");
    private NcDataset ncd_;

    public PCLDataset(String address) {
        try {
            this.ncd_ = PCLDataset.getDataset(address);
        }
        catch (Exception exc) {
            LOGGER.error(FATAL, "Failed to open dataset at {} -- {}", (Object)address, (Object)exc);
            System.exit(2);
        }
        if (this.ncd_ == null) {
            LOGGER.error(FATAL, "Failed to open dataset at {}.", (Object)address);
            System.exit(2);
        }
    }

    public NcDataset getNcDataset() {
        return this.ncd_;
    }

    public PCLVariable getVariable(String name) {
        NcVariable ncv = this.ncd_.getVariableAtPath(name);
        return new PCLVariable(ncv);
    }

    public boolean close() {
        try {
            this.ncd_.close();
        }
        catch (Exception exc) {
            LOGGER.warn("Could not close dataset: {}", (Object)exc.toString());
        }
        return true;
    }

    static NcDataset getDataset(String address) {
        Objects.requireNonNull(address, "Address cannot be null.");
        try {
            PanFileUtils.convertStringToAddress(address);
        }
        catch (Exception exc) {
            throw new RuntimeException("Address string does not look like a File, URL or DatasetUrl.");
        }
        PanOpenDatasetTask task = new PanOpenDatasetTask(address);
        task.openDataset(false);
        NcDataset ncd = task.getDataset();
        if (ncd == null) {
            String errmsg = task.getErrorMessage();
            LOGGER.debug("Could not create NcDataset from {}: {}", (Object)address, (Object)errmsg);
        }
        return ncd;
    }
}

