/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanPlotWidthFactor implements DescribedItem
{
    WIDTH_025(25, "Width 25%", "width-025"),
    WIDTH_050(50, "Width 50%", "width-050"),
    WIDTH_075(75, "Width 75%", "width-075"),
    WIDTH_100(100, "Width 100%", "width-100");

    private int ratio_;
    private String description_;
    private String actionID_;

    private PanPlotWidthFactor(int ratio, String description, String actionID) {
        this.ratio_ = ratio;
        this.description_ = description;
        this.actionID_ = actionID;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    public int getWidthFactor() {
        return this.ratio_;
    }

    public String getActionID() {
        return this.actionID_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text) || this.actionID_ != null && this.actionID_.equalsIgnoreCase(text);
    }

    public static PanPlotWidthFactor matching(String str) {
        for (PanPlotWidthFactor item : PanPlotWidthFactor.values()) {
            if (!item.matches(str)) continue;
            return item;
        }
        return null;
    }

    public static PanPlotWidthFactor matching(int wfactor) {
        for (PanPlotWidthFactor item : PanPlotWidthFactor.values()) {
            if (item.getWidthFactor() != wfactor) continue;
            return item;
        }
        return null;
    }
}

