/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.dpx;

import org.jcodec.containers.dpx.DPXReader;
import org.jcodec.containers.dpx.FileHeader;
import org.jcodec.containers.dpx.FilmHeader;
import org.jcodec.containers.dpx.ImageHeader;
import org.jcodec.containers.dpx.ImageSourceHeader;
import org.jcodec.containers.dpx.TelevisionHeader;

public class DPXMetadata {
    public static final String V2 = "V2.0";
    public static final String V1 = "V1.0";
    public FileHeader file;
    public ImageHeader image;
    public ImageSourceHeader imageSource;
    public FilmHeader film;
    public TelevisionHeader television;
    public String userId;

    private static String smpteTC(int tcsmpte, boolean prevent_dropframe) {
        int ff = DPXReader.bcd2uint(tcsmpte & 0x3F);
        int ss = DPXReader.bcd2uint(tcsmpte >> 8 & 0x7F);
        int mm = DPXReader.bcd2uint(tcsmpte >> 16 & 0x7F);
        int hh = DPXReader.bcd2uint(tcsmpte >> 24 & 0x3F);
        boolean drop = (long)(tcsmpte & 0x40000000) > 0L && !prevent_dropframe;
        return String.format("%02d:%02d:%02d%c%02d", hh, mm, ss, Character.valueOf(drop ? (char)';' : ':'), ff);
    }

    public String getTimecodeString() {
        return DPXMetadata.smpteTC(this.television.timecode, false);
    }
}

