#!/usr/bin/python
if __name__ == '__main__':
  import sys
  import os
  sys.path.insert(0, os.path.abspath('config'))
  import configure
  configure_options = [
    '--COPTFLAGS=-O3',
    '--CXXOPTFLAGS=-O3',
    '--FOPTFLAGS=-O3',
    '--prefix=/opt/petsc/linux-c-opt',
    '--with-bison=0',
    '--with-cmake=0',
    '--with-fftw=1',
    '--with-gsl=1',
    '--with-hdf5-fortran-bindings=1',
    '--with-hdf5=1',
    '--with-libjpeg=1',
    '--with-metis=1',
    '--with-mpi-dir=/usr',
    '--with-mpi-f90module-visibility=0',
    '--with-mumps=1',
    '--with-netcdf=1',
    '--with-parmetis=1',
    '--with-petsc4py=1',
    '--with-ptscotch-include=/usr/include',
    '--with-ptscotch-lib=[libesmumps.so,libptscotch.so,libptscotcherr.so,libscotch.so,libscotcherr.so,libbz2.so]',
    '--with-ptscotch=1',
    '--with-scalapack=1',
    '--with-scalar-type=complex',
    '--with-shared-libraries=1',
    '--with-suitesparse=1',
    '--with-superlu-include=/usr/include/superlu',
    '--with-superlu-lib=-lsuperlu',
    '--with-yaml=1',
    '--with-zfp=0',
    '--with-zlib=1',
    '-march=native',
    'PETSC_ARCH=arch-linux-c-opt',
  ]
  configure.petsc_configure(configure_options)
