/*
 * Decompiled with CFR 0.152.
 */
package plplot.core;

import java.io.File;
import plplot.core.PLCallbackCT;
import plplot.core.PLCallbackLabel;
import plplot.core.PLCallbackMapform;
import plplot.core.PLGraphicsIn;
import plplot.core.plplotjavac;
import plplot.core.plplotjavacConstants;

public class PLStream
implements plplotjavacConstants {
    int stream_id = -1;
    static int active_streams = 0;

    public PLStream() {
        int[] nArray = new int[1];
        if (active_streams == 0) {
            this.openlib();
        }
        plplotjavac.plmkstrm(nArray);
        if (nArray[0] != -1) {
            this.stream_id = nArray[0];
            ++active_streams;
        } else {
            System.err.println("Error creating plplot stream");
            this.stream_id = -1;
        }
    }

    public int set_stream() {
        if (this.stream_id == -1 || active_streams == 0) {
            System.err.println("Error: This stream is not active");
            return -1;
        }
        plplotjavac.plsstrm(this.stream_id);
        return 0;
    }

    public void openlib() {
        File file = null;
        try {
            String string = System.getProperty("plplot.libdir");
            file = new File(string + File.separatorChar + "libplplotjavac_wrap.so");
            if (!file.exists()) {
                file = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null && !(file = new File("/usr/lib/jni" + File.separatorChar + "libplplotjavac_wrap.so")).exists()) {
            file = null;
        }
        if (file != null) {
            try {
                System.load(file.getAbsolutePath());
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println("Native code library failed to load. See the chapter on Dynamic Linking Problems in the SWIG Java documentation for help.\n" + String.valueOf(unsatisfiedLinkError));
                System.exit(1);
            }
        } else {
            System.err.println("Unable to find native code library.\n");
            System.exit(1);
        }
    }

    public void setcontlabelformat(int n, int n2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.pl_setcontlabelformat(n, n2);
    }

    public void setcontlabelparam(double d, double d2, double d3, int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.pl_setcontlabelparam(d, d2, d3, n);
    }

    public void adv(int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.pladv(n);
    }

    public void arc(double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plarc(d, d2, d3, d4, d5, d6, d7, bl);
    }

    public void axes(double d, double d2, String string, double d3, int n, String string2, double d4, int n2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plaxes(d, d2, string, d3, n, string2, d4, n2);
    }

    public void bin(double[] dArray, double[] dArray2, int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plbin(dArray, dArray2, n);
    }

    public void bop() {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plbop();
    }

    public void box(String string, double d, int n, String string2, double d2, int n2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plbox(string, d, n, string2, d2, n2);
    }

    public void box3(String string, String string2, double d, int n, String string3, String string4, double d2, int n2, String string5, String string6, double d3, int n3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plbox3(string, string2, d, n, string3, string4, d2, n2, string5, string6, d3, n3);
    }

    public void btime(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, double[] dArray, double d) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plbtime(nArray, nArray2, nArray3, nArray4, nArray5, dArray, d);
    }

    public void calc_world(double d, double d2, double[] dArray, double[] dArray2, int[] nArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plcalc_world(d, d2, dArray, dArray2, nArray);
    }

    public void clear() {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plclear();
    }

    public void col0(int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plcol0(n);
    }

    public void col1(double d) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plcol1(d);
    }

    public void configtime(double d, double d2, double d3, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, double d4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plconfigtime(d, d2, d3, n, bl, n2, n3, n4, n5, n6, d4);
    }

    public void cont(double[][] dArray, int n, int n2, int n3, int n4, double[] dArray2, double[][] dArray3, double[][] dArray4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plcont(dArray, n, n2, n3, n4, dArray2, dArray3, dArray4);
    }

    public void cpstrm(PLStream pLStream, boolean bl) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plcpstrm(pLStream.stream_id, bl);
    }

    public void ctime(int n, int n2, int n3, int n4, int n5, double d, double[] dArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plctime(n, n2, n3, n4, n5, d, dArray);
    }

    public void end() {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plend();
        active_streams = 0;
        this.stream_id = -1;
    }

    public void end1() {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plend1();
        --active_streams;
        this.stream_id = -1;
    }

    public void env(double d, double d2, double d3, double d4, int n, int n2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plenv(d, d2, d3, d4, n, n2);
    }

    public void env0(double d, double d2, double d3, double d4, int n, int n2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plenv0(d, d2, d3, d4, n, n2);
    }

    public void eop() {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.pleop();
    }

    public void errx(double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plerrx(dArray, dArray2, dArray3);
    }

    public void erry(double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plerry(dArray, dArray2, dArray3);
    }

    public void famadv() {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plfamadv();
    }

    public void fill(double[] dArray, double[] dArray2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plfill(dArray, dArray2);
    }

    public void fill3(double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plfill3(dArray, dArray2, dArray3);
    }

    public void flush() {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plflush();
    }

    public void font(int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plfont(n);
    }

    public void fontld(int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plfontld(n);
    }

    public void gchr(double[] dArray, double[] dArray2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgchr(dArray, dArray2);
    }

    public void gcol0(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgcol0(n, nArray, nArray2, nArray3);
    }

    public void gcol0a(int n, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgcol0a(n, nArray, nArray2, nArray3, dArray);
    }

    public void gcolbg(int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgcolbg(nArray, nArray2, nArray3);
    }

    public void gcolbga(int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgcolbga(nArray, nArray2, nArray3, dArray);
    }

    public void gcompression(int[] nArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgcompression(nArray);
    }

    public void gdev(StringBuffer stringBuffer) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgdev(stringBuffer);
    }

    public void gdidev(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgdidev(dArray, dArray2, dArray3, dArray4);
    }

    public void gdiori(double[] dArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgdiori(dArray);
    }

    public void gdiplt(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgdiplt(dArray, dArray2, dArray3, dArray4);
    }

    public int getCursor(PLGraphicsIn pLGraphicsIn) {
        if (this.set_stream() == -1) {
            return 0;
        }
        return plplotjavac.plGetCursor(pLGraphicsIn);
    }

    public void gfam(int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgfam(nArray, nArray2, nArray3);
    }

    public void gfci(long[] lArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgfci(lArray);
    }

    public void gfnam(StringBuffer stringBuffer) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgfnam(stringBuffer);
    }

    public void gfont(int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgfont(nArray, nArray2, nArray3);
    }

    public void glevel(int[] nArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plglevel(nArray);
    }

    public void gpage(double[] dArray, double[] dArray2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgpage(dArray, dArray2, nArray, nArray2, nArray3, nArray4);
    }

    public void gra() {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgra();
    }

    public void gradient(double[] dArray, double[] dArray2, double d) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgradient(dArray, dArray2, d);
    }

    public void griddata(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[][] dArray6, int n, double d) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgriddata(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, n, d);
    }

    public void gspa(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgspa(dArray, dArray2, dArray3, dArray4);
    }

    public void gver(StringBuffer stringBuffer) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgver(stringBuffer);
    }

    public void gvpd(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgvpd(dArray, dArray2, dArray3, dArray4);
    }

    public void gvpw(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgvpw(dArray, dArray2, dArray3, dArray4);
    }

    public void gxax(int[] nArray, int[] nArray2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgxax(nArray, nArray2);
    }

    public void gyax(int[] nArray, int[] nArray2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgyax(nArray, nArray2);
    }

    public void gzax(int[] nArray, int[] nArray2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgzax(nArray, nArray2);
    }

    public void hist(double[] dArray, double d, double d2, int n, int n2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plhist(dArray, d, d2, n, n2);
    }

    public void image(double[][] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plimage(dArray, d, d2, d3, d4, d5, d6, d7, d8, d9, d10);
    }

    public void imagefr(double[][] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double[][] dArray2, double[][] dArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plimagefr(dArray, d, d2, d3, d4, d5, d6, d7, d8, dArray2, dArray3);
    }

    public void init() {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plinit();
    }

    public void join(double d, double d2, double d3, double d4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.pljoin(d, d2, d3, d4);
    }

    public void lab(String string, String string2, String string3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.pllab(string, string2, string3);
    }

    public void legend(double[] dArray, double[] dArray2, int n, int n2, double d, double d2, double d3, int n3, int n4, int n5, int n6, int n7, int[] nArray, double d4, double d5, double d6, double d7, int[] nArray2, String[] stringArray, int[] nArray3, int[] nArray4, double[] dArray3, double[] dArray4, int[] nArray5, int[] nArray6, double[] dArray5, int[] nArray7, double[] dArray6, int[] nArray8, String[] stringArray2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.pllegend(dArray, dArray2, n, n2, d, d2, d3, n3, n4, n5, n6, n7, nArray, d4, d5, d6, d7, nArray2, stringArray, nArray3, nArray4, dArray3, dArray4, nArray5, nArray6, dArray5, nArray7, dArray6, nArray8, stringArray2);
    }

    public void colorbar(double[] dArray, double[] dArray2, int n, int n2, double d, double d2, double d3, double d4, int n3, int n4, int n5, double d5, double d6, int n6, double d7, int[] nArray, String[] stringArray, String[] stringArray2, double[] dArray3, int[] nArray2, int[] nArray3, double[][] dArray4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plcolorbar(dArray, dArray2, n, n2, d, d2, d3, d4, n3, n4, n5, d5, d6, n6, d7, nArray, stringArray, stringArray2, dArray3, nArray2, nArray3, dArray4);
    }

    public void lightsource(double d, double d2, double d3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.pllightsource(d, d2, d3);
    }

    public void line(double[] dArray, double[] dArray2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plline(dArray, dArray2);
    }

    public void line3(double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plline3(dArray, dArray2, dArray3);
    }

    public void lsty(int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.pllsty(n);
    }

    public void map(PLCallbackMapform pLCallbackMapform, String string, double d, double d2, double d3, double d4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plmap(pLCallbackMapform, string, d, d2, d3, d4);
    }

    public void mapline(PLCallbackMapform pLCallbackMapform, String string, double d, double d2, double d3, double d4, int[] nArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plmapline(pLCallbackMapform, string, d, d2, d3, d4, nArray);
    }

    public void mapstring(PLCallbackMapform pLCallbackMapform, String string, String string2, double d, double d2, double d3, double d4, int[] nArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plmapstring(pLCallbackMapform, string, string2, d, d2, d3, d4, nArray);
    }

    public void maptex(PLCallbackMapform pLCallbackMapform, String string, double d, double d2, double d3, String string2, double d4, double d5, double d6, double d7, int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plmaptex(pLCallbackMapform, string, d, d2, d3, string2, d4, d5, d6, d7, n);
    }

    public void mapfill(PLCallbackMapform pLCallbackMapform, String string, double d, double d2, double d3, double d4, int[] nArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plmapfill(pLCallbackMapform, string, d, d2, d3, d4, nArray);
    }

    public void meridians(PLCallbackMapform pLCallbackMapform, double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plmeridians(pLCallbackMapform, d, d2, d3, d4, d5, d6);
    }

    public void minMax2dGrid(double[][] dArray, double[] dArray2, double[] dArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plMinMax2dGrid(dArray, dArray2, dArray3);
    }

    public void mesh(double[] dArray, double[] dArray2, double[][] dArray3, int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plmesh(dArray, dArray2, dArray3, n);
    }

    public void meshc(double[] dArray, double[] dArray2, double[][] dArray3, int n, double[] dArray4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plmeshc(dArray, dArray2, dArray3, n, dArray4);
    }

    public void mtex(String string, double d, double d2, double d3, String string2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plmtex(string, d, d2, d3, string2);
    }

    public void mtex3(String string, double d, double d2, double d3, String string2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plmtex3(string, d, d2, d3, string2);
    }

    public void plot3d(double[] dArray, double[] dArray2, double[][] dArray3, int n, boolean bl) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plot3d(dArray, dArray2, dArray3, n, bl);
    }

    public void plot3dc(double[] dArray, double[] dArray2, double[][] dArray3, int n, double[] dArray4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plot3dc(dArray, dArray2, dArray3, n, dArray4);
    }

    public void plot3dcl(double[] dArray, double[] dArray2, double[][] dArray3, int n, double[] dArray4, int n2, int[] nArray, int[] nArray2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plot3dcl(dArray, dArray2, dArray3, n, dArray4, n2, nArray, nArray2);
    }

    public void surf3d(double[] dArray, double[] dArray2, double[][] dArray3, int n, double[] dArray4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsurf3d(dArray, dArray2, dArray3, n, dArray4);
    }

    public void surf3dl(double[] dArray, double[] dArray2, double[][] dArray3, int n, double[] dArray4, int n2, int[] nArray, int[] nArray2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsurf3dl(dArray, dArray2, dArray3, n, dArray4, n2, nArray, nArray2);
    }

    public int parseopts(String[] stringArray, int n) {
        if (this.set_stream() == -1) {
            return 0;
        }
        return plplotjavac.plparseopts(stringArray, n);
    }

    public void pat(int[] nArray, int[] nArray2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plpat(nArray, nArray2);
    }

    public void path(int n, double d, double d2, double d3, double d4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plpath(n, d, d2, d3, d4);
    }

    public void poin(double[] dArray, double[] dArray2, int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plpoin(dArray, dArray2, n);
    }

    public void poin3(double[] dArray, double[] dArray2, double[] dArray3, int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plpoin3(dArray, dArray2, dArray3, n);
    }

    public void poly3(double[] dArray, double[] dArray2, double[] dArray3, boolean[] blArray, boolean bl) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plpoly3(dArray, dArray2, dArray3, blArray, bl);
    }

    public void prec(int n, int n2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plprec(n, n2);
    }

    public void psty(int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plpsty(n);
    }

    public void ptex(double d, double d2, double d3, double d4, double d5, String string) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plptex(d, d2, d3, d4, d5, string);
    }

    public void ptex3(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, String string) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plptex3(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, string);
    }

    public double randd() {
        if (this.set_stream() == -1) {
            return 0.0;
        }
        return plplotjavac.plrandd();
    }

    public void replot() {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plreplot();
    }

    public void schr(double d, double d2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plschr(d, d2);
    }

    public void scmap0(int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscmap0(nArray, nArray2, nArray3);
    }

    public void scmap0a(int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscmap0a(nArray, nArray2, nArray3, dArray);
    }

    public void scmap0n(int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscmap0n(n);
    }

    public void scmap1(int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscmap1(nArray, nArray2, nArray3);
    }

    public void scmap1a(int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscmap1a(nArray, nArray2, nArray3, dArray);
    }

    public void scmap1l(boolean bl, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, boolean[] blArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscmap1l(bl, dArray, dArray2, dArray3, dArray4, blArray);
    }

    public void scmap1l(boolean bl, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscmap1l(bl, dArray, dArray2, dArray3, dArray4, null);
    }

    public void scmap1la(boolean bl, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, boolean[] blArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscmap1la(bl, dArray, dArray2, dArray3, dArray4, dArray5, blArray);
    }

    public void scmap1la(boolean bl, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscmap1la(bl, dArray, dArray2, dArray3, dArray4, dArray5, null);
    }

    public void scmap1n(int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscmap1n(n);
    }

    public void scmap1_range(double d, double d2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscmap1_range(d, d2);
    }

    public void gcmap1_range(double[] dArray, double[] dArray2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plgcmap1_range(dArray, dArray2);
    }

    public void scol0(int n, int n2, int n3, int n4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscol0(n, n2, n3, n4);
    }

    public void scol0a(int n, int n2, int n3, int n4, double d) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscol0a(n, n2, n3, n4, d);
    }

    public void scolbg(int n, int n2, int n3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscolbg(n, n2, n3);
    }

    public void scolbga(int n, int n2, int n3, double d) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscolbga(n, n2, n3, d);
    }

    public void scolor(int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscolor(n);
    }

    public void scompression(int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plscompression(n);
    }

    public void sdev(String string) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsdev(string);
    }

    public void sdidev(double d, double d2, double d3, double d4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsdidev(d, d2, d3, d4);
    }

    public void sdimap(int n, int n2, int n3, int n4, double d, double d2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsdimap(n, n2, n3, n4, d, d2);
    }

    public void sdiori(double d) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsdiori(d);
    }

    public void sdiplt(double d, double d2, double d3, double d4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsdiplt(d, d2, d3, d4);
    }

    public void sdiplz(double d, double d2, double d3, double d4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsdiplz(d, d2, d3, d4);
    }

    public void seed(long l) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plseed(l);
    }

    public void sesc(char c) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsesc(c);
    }

    public int setopt(String string, String string2) {
        if (this.set_stream() == -1) {
            return 0;
        }
        return plplotjavac.plsetopt(string, string2);
    }

    public void sfam(int n, int n2, int n3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsfam(n, n2, n3);
    }

    public void sfci(long l) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsfci(l);
    }

    public void sfnam(String string) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsfnam(string);
    }

    public void sfont(int n, int n2, int n3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsfont(n, n2, n3);
    }

    public void shades(double[][] dArray, double d, double d2, double d3, double d4, double[] dArray2, double d5, int n, double d6, boolean bl, double[][] dArray3, double[][] dArray4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plshades(dArray, d, d2, d3, d4, dArray2, d5, n, d6, bl, dArray3, dArray4);
    }

    public void shade(double[][] dArray, double d, double d2, double d3, double d4, double d5, double d6, int n, double d7, double d8, int n2, double d9, int n3, double d10, boolean bl, double[][] dArray2, double[][] dArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plshade(dArray, d, d2, d3, d4, d5, d6, n, d7, d8, n2, d9, n3, d10, bl, dArray2, dArray3);
    }

    public void slabelfunc(PLCallbackLabel pLCallbackLabel, Object object) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plslabelfunc(pLCallbackLabel, object);
    }

    public void slabelfunc(PLCallbackLabel pLCallbackLabel) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plslabelfunc(pLCallbackLabel, null);
    }

    public void smaj(double d, double d2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsmaj(d, d2);
    }

    public void smin(double d, double d2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsmin(d, d2);
    }

    public void sori(int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsori(n);
    }

    public void spage(double d, double d2, int n, int n2, int n3, int n4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plspage(d, d2, n, n2, n3, n4);
    }

    public void spal0(String string) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plspal0(string);
    }

    public void spal1(String string, boolean bl) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plspal1(string, bl);
    }

    public void spause(boolean bl) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plspause(bl);
    }

    public void sstrm(int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsstrm(n);
    }

    public void ssub(int n, int n2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plssub(n, n2);
    }

    public void ssym(double d, double d2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plssym(d, d2);
    }

    public void star(int n, int n2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plstar(n, n2);
    }

    public void start(String string, int n, int n2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plstart(string, n, n2);
    }

    public void stransform(PLCallbackCT pLCallbackCT, Object object) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plstransform(pLCallbackCT, object);
    }

    public void string(double[] dArray, double[] dArray2, String string) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plstring(dArray, dArray2, string);
    }

    public void string3(double[] dArray, double[] dArray2, double[] dArray3, String string) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plstring3(dArray, dArray2, dArray3, string);
    }

    public void stripa(int n, int n2, double d, double d2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plstripa(n, n2, d, d2);
    }

    public void stripc(int[] nArray, String string, String string2, double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, boolean bl2, int n, int n2, int[] nArray2, int[] nArray3, String[] stringArray, String string3, String string4, String string5) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plstripc(nArray, string, string2, d, d2, d3, d4, d5, d6, d7, bl, bl2, n, n2, nArray2, nArray3, stringArray, string3, string4, string5);
    }

    public void stripd(int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plstripd(n);
    }

    public void styl(int[] nArray, int[] nArray2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plstyl(nArray, nArray2);
    }

    public void svect(double[] dArray, double[] dArray2, boolean bl) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsvect(dArray, dArray2, bl);
    }

    public void svpa(double d, double d2, double d3, double d4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsvpa(d, d2, d3, d4);
    }

    public void sxax(int n, int n2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsxax(n, n2);
    }

    public void syax(int n, int n2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsyax(n, n2);
    }

    public void sym(double[] dArray, double[] dArray2, int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsym(dArray, dArray2, n);
    }

    public void szax(int n, int n2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plszax(n, n2);
    }

    public void text() {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.pltext();
    }

    public void timefmt(String string) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.pltimefmt(string);
    }

    public void vasp(double d) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plvasp(d);
    }

    public void vect(double[][] dArray, double[][] dArray2, double d, double[][] dArray3, double[][] dArray4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plvect(dArray, dArray2, d, dArray3, dArray4);
    }

    public void vpas(double d, double d2, double d3, double d4, double d5) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plvpas(d, d2, d3, d4, d5);
    }

    public void vpor(double d, double d2, double d3, double d4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plvpor(d, d2, d3, d4);
    }

    public void vsta() {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plvsta();
    }

    public void w3d(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plw3d(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11);
    }

    public void width(double d) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plwidth(d);
    }

    public void width(int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plwidth(n);
    }

    public void wind(double d, double d2, double d3, double d4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plwind(d, d2, d3, d4);
    }

    public void xormod(boolean bl, boolean[] blArray) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plxormod(bl, blArray);
    }

    public void ClearOpts() {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plClearOpts();
    }

    public void ResetOpts() {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plResetOpts();
    }

    public void SetUsage(String string, String string2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plSetUsage(string, string2);
    }

    public void OptUsage() {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plOptUsage();
    }

    public void hlsrgb(double d, double d2, double d3, double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plhlsrgb(d, d2, d3, dArray, dArray2, dArray3);
    }

    public void rgbhls(double d, double d2, double d3, double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plrgbhls(d, d2, d3, dArray, dArray2, dArray3);
    }

    public void cpstrm(int n, int n2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plcpstrm(n, n2 != 0);
    }

    public void plot3d(double[] dArray, double[] dArray2, double[][] dArray3, int n, int n2) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plot3d(dArray, dArray2, dArray3, n, n2 != 0);
    }

    public void poly3(double[] dArray, double[] dArray2, double[] dArray3, int[] nArray, int n) {
        if (this.set_stream() == -1) {
            return;
        }
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            blArray[i] = nArray[i] != 0;
        }
        plplotjavac.plpoly3(dArray, dArray2, dArray3, blArray, n != 0);
    }

    public void scmap1l(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int[] nArray) {
        if (this.set_stream() == -1) {
            return;
        }
        boolean[] blArray = null;
        if (nArray != null) {
            blArray = new boolean[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                blArray[i] = nArray[i] != 0;
            }
        }
        plplotjavac.plscmap1l(n != 0, dArray, dArray2, dArray3, dArray4, blArray);
    }

    public void shades(double[][] dArray, double d, double d2, double d3, double d4, double[] dArray2, double d5, int n, double d6, int n2, double[][] dArray3, double[][] dArray4) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plshades(dArray, d, d2, d3, d4, dArray2, d5, n, d6, n2 != 0, dArray3, dArray4);
    }

    public void shade(double[][] dArray, double d, double d2, double d3, double d4, double d5, double d6, int n, double d7, double d8, int n2, double d9, int n3, double d10, int n4, double[][] dArray2, double[][] dArray3) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plshade(dArray, d, d2, d3, d4, d5, d6, n, d7, d8, n2, d9, n3, d10, n4 != 0, dArray2, dArray3);
    }

    public void spause(int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plspause(n != 0);
    }

    public void stripc(int[] nArray, String string, String string2, double d, double d2, double d3, double d4, double d5, double d6, double d7, int n, int n2, int n3, int n4, int[] nArray2, int[] nArray3, String[] stringArray, String string3, String string4, String string5) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plstripc(nArray, string, string2, d, d2, d3, d4, d5, d6, d7, n != 0, n2 != 0, n3, n4, nArray2, nArray3, stringArray, string3, string4, string5);
    }

    public void svect(double[] dArray, double[] dArray2, int n) {
        if (this.set_stream() == -1) {
            return;
        }
        plplotjavac.plsvect(dArray, dArray2, n != 0);
    }

    public void xormod(int n, int[] nArray) {
        if (this.set_stream() == -1) {
            return;
        }
        boolean[] blArray = new boolean[1];
        plplotjavac.plxormod(n != 0, blArray);
        nArray[0] = blArray[0] ? 1 : 0;
    }
}

