#!/usr/bin/bash
# Test suite for lua examples.
#
# Copyright (C) 2008 Andrew Ross
# Copyright (C) 2018 Alan W. Irwin
#
# This file is part of PLplot.
#
# PLplot is free software; you can redistribute it and/or modify
# it under the terms of the GNU Library General Public License as published
# by the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# PLplot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public License
# along with PLplot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

# This is called from plplot-test.sh with $luadir, $device, $dsuffix,
# $options, and possibly $verbose_test defined.

# Do the standard non-interactive examples.
lang="lua"
# First save directory
topdir="$(pwd)"
# Lua examples must be run from the directory where they exist.
cd "${OUTPUT_DIR}"
# On Windows systems the sed stanza converts from leading slash form
# to drive-letter form.  This distinction matters for all prompted
# filenames (e.g., example 14) but does not matter for -o options.
results="$(pwd |sed 's?^/\(.\)/?\1:/?')"
export results
cd "$topdir"
cd "$luadir"
for index in 00 01 02 03 04 05 06 07 08 09 10 11 12 13 15 16 18 19 20 21 22 23 24 25 26 27 28 30 31 33 ${critical_examples} ; do
    if [ "$verbose_test" ] ; then
	echo "x${index}"
    fi
    if [ "$index" = "14" ] ; then
	echo "${results}"/x${index}a${lang}%n.$dsuffix | \
	/usr/bin/lua5.3 x${index}.${lang} -dev $device -o "${results}"/x${index}${lang}%n.$dsuffix \
	    $options 2> lua_${device}_test.error >| "${results}"/x${index}${lang}_${dsuffix}.txt
	# Look for any status codes (segfaults, plexit) from the examples themselves.
	status_code=$?
    else
	/usr/bin/lua5.3 x${index}.${lang} -dev $device -o "${results}"/x${index}${lang}%n.$dsuffix \
	    $options 2> lua_${device}_test.error >| "${results}"/x${index}${lang}_${dsuffix}.txt
    # Look for any status codes (segfaults, plexit) from the examples themselves.
	status_code=$?
    fi
    cat lua_${device}_test.error
    if [ "$status_code" -ne 0 ] ; then
	exit $status_code
    fi
  # Look for any PLPLOT ERROR messages from plwarn that do not result in an
  # exit code.
    is_error=`grep -l 'PLPLOT ERROR' lua_${device}_test.error`
    if [ -n "$is_error" ] ; then
	exit 1
    fi
done
