import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { CreateAutomatedReasoningPolicyRequestFilterSensitiveLog, CreateAutomatedReasoningPolicyResponseFilterSensitiveLog, } from "../models/models_0";
import { de_CreateAutomatedReasoningPolicyCommand, se_CreateAutomatedReasoningPolicyCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class CreateAutomatedReasoningPolicyCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "CreateAutomatedReasoningPolicy", {})
    .n("BedrockClient", "CreateAutomatedReasoningPolicyCommand")
    .f(CreateAutomatedReasoningPolicyRequestFilterSensitiveLog, CreateAutomatedReasoningPolicyResponseFilterSensitiveLog)
    .ser(se_CreateAutomatedReasoningPolicyCommand)
    .de(de_CreateAutomatedReasoningPolicyCommand)
    .build() {
}
