import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListCustomModelDeploymentsCommand, se_ListCustomModelDeploymentsCommand } from "../protocols/Aws_restJson1";
export { $Command };
export class ListCustomModelDeploymentsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "ListCustomModelDeployments", {})
    .n("BedrockClient", "ListCustomModelDeploymentsCommand")
    .f(void 0, void 0)
    .ser(se_ListCustomModelDeploymentsCommand)
    .de(de_ListCustomModelDeploymentsCommand)
    .build() {
}
