import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { UpdateAutomatedReasoningPolicyRequestFilterSensitiveLog, UpdateAutomatedReasoningPolicyResponseFilterSensitiveLog, } from "../models/models_0";
import { de_UpdateAutomatedReasoningPolicyCommand, se_UpdateAutomatedReasoningPolicyCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class UpdateAutomatedReasoningPolicyCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "UpdateAutomatedReasoningPolicy", {})
    .n("BedrockClient", "UpdateAutomatedReasoningPolicyCommand")
    .f(UpdateAutomatedReasoningPolicyRequestFilterSensitiveLog, UpdateAutomatedReasoningPolicyResponseFilterSensitiveLog)
    .ser(se_UpdateAutomatedReasoningPolicyCommand)
    .de(de_UpdateAutomatedReasoningPolicyCommand)
    .build() {
}
