import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { EvaluationConfigFilterSensitiveLog, EvaluationModelConfigFilterSensitiveLog, ExternalSourcesRetrieveAndGenerateConfigurationFilterSensitiveLog, GenerationConfigurationFilterSensitiveLog, GuardrailContentPolicyConfigFilterSensitiveLog, GuardrailContextualGroundingPolicyConfigFilterSensitiveLog, GuardrailTopicPolicyConfigFilterSensitiveLog, ImplicitFilterConfigurationFilterSensitiveLog, TrainingDataConfigFilterSensitiveLog, VectorSearchRerankingConfigurationFilterSensitiveLog, } from "./models_0";
export const GuardrailManagedWordsType = {
    PROFANITY: "PROFANITY",
};
export const GuardrailStatus = {
    CREATING: "CREATING",
    DELETING: "DELETING",
    FAILED: "FAILED",
    READY: "READY",
    UPDATING: "UPDATING",
    VERSIONING: "VERSIONING",
};
export var InferenceProfileModelSource;
(function (InferenceProfileModelSource) {
    InferenceProfileModelSource.visit = (value, visitor) => {
        if (value.copyFrom !== undefined)
            return visitor.copyFrom(value.copyFrom);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(InferenceProfileModelSource || (InferenceProfileModelSource = {}));
export const InferenceProfileStatus = {
    ACTIVE: "ACTIVE",
};
export const InferenceProfileType = {
    APPLICATION: "APPLICATION",
    SYSTEM_DEFINED: "SYSTEM_DEFINED",
};
export const ModelCopyJobStatus = {
    COMPLETED: "Completed",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
};
export const ModelImportJobStatus = {
    COMPLETED: "Completed",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
};
export const S3InputFormat = {
    JSONL: "JSONL",
};
export var ModelInvocationJobInputDataConfig;
(function (ModelInvocationJobInputDataConfig) {
    ModelInvocationJobInputDataConfig.visit = (value, visitor) => {
        if (value.s3InputDataConfig !== undefined)
            return visitor.s3InputDataConfig(value.s3InputDataConfig);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(ModelInvocationJobInputDataConfig || (ModelInvocationJobInputDataConfig = {}));
export var ModelInvocationJobOutputDataConfig;
(function (ModelInvocationJobOutputDataConfig) {
    ModelInvocationJobOutputDataConfig.visit = (value, visitor) => {
        if (value.s3OutputDataConfig !== undefined)
            return visitor.s3OutputDataConfig(value.s3OutputDataConfig);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(ModelInvocationJobOutputDataConfig || (ModelInvocationJobOutputDataConfig = {}));
export const ModelInvocationJobStatus = {
    COMPLETED: "Completed",
    EXPIRED: "Expired",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    PARTIALLY_COMPLETED: "PartiallyCompleted",
    SCHEDULED: "Scheduled",
    STOPPED: "Stopped",
    STOPPING: "Stopping",
    SUBMITTED: "Submitted",
    VALIDATING: "Validating",
};
export const ModelCustomization = {
    CONTINUED_PRE_TRAINING: "CONTINUED_PRE_TRAINING",
    DISTILLATION: "DISTILLATION",
    FINE_TUNING: "FINE_TUNING",
};
export const InferenceType = {
    ON_DEMAND: "ON_DEMAND",
    PROVISIONED: "PROVISIONED",
};
export const ModelModality = {
    EMBEDDING: "EMBEDDING",
    IMAGE: "IMAGE",
    TEXT: "TEXT",
};
export const FoundationModelLifecycleStatus = {
    ACTIVE: "ACTIVE",
    LEGACY: "LEGACY",
};
export const PromptRouterStatus = {
    AVAILABLE: "AVAILABLE",
};
export const PromptRouterType = {
    CUSTOM: "custom",
    DEFAULT: "default",
};
export const CommitmentDuration = {
    ONE_MONTH: "OneMonth",
    SIX_MONTHS: "SixMonths",
};
export const ProvisionedModelStatus = {
    CREATING: "Creating",
    FAILED: "Failed",
    IN_SERVICE: "InService",
    UPDATING: "Updating",
};
export const SortByProvisionedModels = {
    CREATION_TIME: "CreationTime",
};
export const AuthorizationStatus = {
    AUTHORIZED: "AUTHORIZED",
    NOT_AUTHORIZED: "NOT_AUTHORIZED",
};
export const EntitlementAvailability = {
    AVAILABLE: "AVAILABLE",
    NOT_AVAILABLE: "NOT_AVAILABLE",
};
export const RegionAvailability = {
    AVAILABLE: "AVAILABLE",
    NOT_AVAILABLE: "NOT_AVAILABLE",
};
export const OfferType = {
    ALL: "ALL",
    PUBLIC: "PUBLIC",
};
export const ModelCustomizationJobStatus = {
    COMPLETED: "Completed",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    STOPPED: "Stopped",
    STOPPING: "Stopping",
};
export const JobStatusDetails = {
    COMPLETED: "Completed",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    NOT_STARTED: "NotStarted",
    STOPPED: "Stopped",
    STOPPING: "Stopping",
};
export const FineTuningJobStatus = {
    COMPLETED: "Completed",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    STOPPED: "Stopped",
    STOPPING: "Stopping",
};
export var RetrievalFilter;
(function (RetrievalFilter) {
    RetrievalFilter.visit = (value, visitor) => {
        if (value.equals !== undefined)
            return visitor.equals(value.equals);
        if (value.notEquals !== undefined)
            return visitor.notEquals(value.notEquals);
        if (value.greaterThan !== undefined)
            return visitor.greaterThan(value.greaterThan);
        if (value.greaterThanOrEquals !== undefined)
            return visitor.greaterThanOrEquals(value.greaterThanOrEquals);
        if (value.lessThan !== undefined)
            return visitor.lessThan(value.lessThan);
        if (value.lessThanOrEquals !== undefined)
            return visitor.lessThanOrEquals(value.lessThanOrEquals);
        if (value.in !== undefined)
            return visitor.in(value.in);
        if (value.notIn !== undefined)
            return visitor.notIn(value.notIn);
        if (value.startsWith !== undefined)
            return visitor.startsWith(value.startsWith);
        if (value.listContains !== undefined)
            return visitor.listContains(value.listContains);
        if (value.stringContains !== undefined)
            return visitor.stringContains(value.stringContains);
        if (value.andAll !== undefined)
            return visitor.andAll(value.andAll);
        if (value.orAll !== undefined)
            return visitor.orAll(value.orAll);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(RetrievalFilter || (RetrievalFilter = {}));
export var KnowledgeBaseConfig;
(function (KnowledgeBaseConfig) {
    KnowledgeBaseConfig.visit = (value, visitor) => {
        if (value.retrieveConfig !== undefined)
            return visitor.retrieveConfig(value.retrieveConfig);
        if (value.retrieveAndGenerateConfig !== undefined)
            return visitor.retrieveAndGenerateConfig(value.retrieveAndGenerateConfig);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(KnowledgeBaseConfig || (KnowledgeBaseConfig = {}));
export var RAGConfig;
(function (RAGConfig) {
    RAGConfig.visit = (value, visitor) => {
        if (value.knowledgeBaseConfig !== undefined)
            return visitor.knowledgeBaseConfig(value.knowledgeBaseConfig);
        if (value.precomputedRagSourceConfig !== undefined)
            return visitor.precomputedRagSourceConfig(value.precomputedRagSourceConfig);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(RAGConfig || (RAGConfig = {}));
export var EvaluationInferenceConfig;
(function (EvaluationInferenceConfig) {
    EvaluationInferenceConfig.visit = (value, visitor) => {
        if (value.models !== undefined)
            return visitor.models(value.models);
        if (value.ragConfigs !== undefined)
            return visitor.ragConfigs(value.ragConfigs);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(EvaluationInferenceConfig || (EvaluationInferenceConfig = {}));
export const GuardrailManagedWordsConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inputAction && { inputAction: SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: SENSITIVE_STRING }),
});
export const GuardrailWordConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inputAction && { inputAction: SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: SENSITIVE_STRING }),
});
export const GuardrailWordPolicyConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.wordsConfig && { wordsConfig: obj.wordsConfig.map((item) => GuardrailWordConfigFilterSensitiveLog(item)) }),
    ...(obj.managedWordListsConfig && {
        managedWordListsConfig: obj.managedWordListsConfig.map((item) => GuardrailManagedWordsConfigFilterSensitiveLog(item)),
    }),
});
export const CreateGuardrailRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
    ...(obj.topicPolicyConfig && {
        topicPolicyConfig: GuardrailTopicPolicyConfigFilterSensitiveLog(obj.topicPolicyConfig),
    }),
    ...(obj.contentPolicyConfig && {
        contentPolicyConfig: GuardrailContentPolicyConfigFilterSensitiveLog(obj.contentPolicyConfig),
    }),
    ...(obj.wordPolicyConfig && { wordPolicyConfig: GuardrailWordPolicyConfigFilterSensitiveLog(obj.wordPolicyConfig) }),
    ...(obj.contextualGroundingPolicyConfig && {
        contextualGroundingPolicyConfig: GuardrailContextualGroundingPolicyConfigFilterSensitiveLog(obj.contextualGroundingPolicyConfig),
    }),
    ...(obj.blockedInputMessaging && { blockedInputMessaging: SENSITIVE_STRING }),
    ...(obj.blockedOutputsMessaging && { blockedOutputsMessaging: SENSITIVE_STRING }),
});
export const CreateGuardrailVersionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const GuardrailContentFilterFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inputModalities && { inputModalities: SENSITIVE_STRING }),
    ...(obj.outputModalities && { outputModalities: SENSITIVE_STRING }),
    ...(obj.inputAction && { inputAction: SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: SENSITIVE_STRING }),
});
export const GuardrailContentFiltersTierFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.tierName && { tierName: SENSITIVE_STRING }),
});
export const GuardrailContentPolicyFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.filters && { filters: obj.filters.map((item) => GuardrailContentFilterFilterSensitiveLog(item)) }),
    ...(obj.tier && { tier: GuardrailContentFiltersTierFilterSensitiveLog(obj.tier) }),
});
export const GuardrailContextualGroundingFilterFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.action && { action: SENSITIVE_STRING }),
});
export const GuardrailContextualGroundingPolicyFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.filters && {
        filters: obj.filters.map((item) => GuardrailContextualGroundingFilterFilterSensitiveLog(item)),
    }),
});
export const GuardrailTopicsTierFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.tierName && { tierName: SENSITIVE_STRING }),
});
export const GuardrailTopicFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.definition && { definition: SENSITIVE_STRING }),
    ...(obj.examples && { examples: SENSITIVE_STRING }),
    ...(obj.inputAction && { inputAction: SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: SENSITIVE_STRING }),
});
export const GuardrailTopicPolicyFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.topics && { topics: obj.topics.map((item) => GuardrailTopicFilterSensitiveLog(item)) }),
    ...(obj.tier && { tier: GuardrailTopicsTierFilterSensitiveLog(obj.tier) }),
});
export const GuardrailManagedWordsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inputAction && { inputAction: SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: SENSITIVE_STRING }),
});
export const GuardrailWordFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inputAction && { inputAction: SENSITIVE_STRING }),
    ...(obj.outputAction && { outputAction: SENSITIVE_STRING }),
});
export const GuardrailWordPolicyFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.words && { words: obj.words.map((item) => GuardrailWordFilterSensitiveLog(item)) }),
    ...(obj.managedWordLists && {
        managedWordLists: obj.managedWordLists.map((item) => GuardrailManagedWordsFilterSensitiveLog(item)),
    }),
});
export const GetGuardrailResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
    ...(obj.topicPolicy && { topicPolicy: GuardrailTopicPolicyFilterSensitiveLog(obj.topicPolicy) }),
    ...(obj.contentPolicy && { contentPolicy: GuardrailContentPolicyFilterSensitiveLog(obj.contentPolicy) }),
    ...(obj.wordPolicy && { wordPolicy: GuardrailWordPolicyFilterSensitiveLog(obj.wordPolicy) }),
    ...(obj.contextualGroundingPolicy && {
        contextualGroundingPolicy: GuardrailContextualGroundingPolicyFilterSensitiveLog(obj.contextualGroundingPolicy),
    }),
    ...(obj.statusReasons && { statusReasons: SENSITIVE_STRING }),
    ...(obj.failureRecommendations && { failureRecommendations: SENSITIVE_STRING }),
    ...(obj.blockedInputMessaging && { blockedInputMessaging: SENSITIVE_STRING }),
    ...(obj.blockedOutputsMessaging && { blockedOutputsMessaging: SENSITIVE_STRING }),
});
export const GuardrailSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const ListGuardrailsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.guardrails && { guardrails: obj.guardrails.map((item) => GuardrailSummaryFilterSensitiveLog(item)) }),
});
export const UpdateGuardrailRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.name && { name: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
    ...(obj.topicPolicyConfig && {
        topicPolicyConfig: GuardrailTopicPolicyConfigFilterSensitiveLog(obj.topicPolicyConfig),
    }),
    ...(obj.contentPolicyConfig && {
        contentPolicyConfig: GuardrailContentPolicyConfigFilterSensitiveLog(obj.contentPolicyConfig),
    }),
    ...(obj.wordPolicyConfig && { wordPolicyConfig: GuardrailWordPolicyConfigFilterSensitiveLog(obj.wordPolicyConfig) }),
    ...(obj.contextualGroundingPolicyConfig && {
        contextualGroundingPolicyConfig: GuardrailContextualGroundingPolicyConfigFilterSensitiveLog(obj.contextualGroundingPolicyConfig),
    }),
    ...(obj.blockedInputMessaging && { blockedInputMessaging: SENSITIVE_STRING }),
    ...(obj.blockedOutputsMessaging && { blockedOutputsMessaging: SENSITIVE_STRING }),
});
export const CreateInferenceProfileRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: SENSITIVE_STRING }),
    ...(obj.modelSource && { modelSource: obj.modelSource }),
});
export const GetInferenceProfileResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const InferenceProfileSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const ListInferenceProfilesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.inferenceProfileSummaries && {
        inferenceProfileSummaries: obj.inferenceProfileSummaries.map((item) => InferenceProfileSummaryFilterSensitiveLog(item)),
    }),
});
export const GetModelInvocationJobResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.message && { message: SENSITIVE_STRING }),
    ...(obj.inputDataConfig && { inputDataConfig: obj.inputDataConfig }),
    ...(obj.outputDataConfig && { outputDataConfig: obj.outputDataConfig }),
});
export const ModelInvocationJobSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.message && { message: SENSITIVE_STRING }),
    ...(obj.inputDataConfig && { inputDataConfig: obj.inputDataConfig }),
    ...(obj.outputDataConfig && { outputDataConfig: obj.outputDataConfig }),
});
export const ListModelInvocationJobsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.invocationJobSummaries && {
        invocationJobSummaries: obj.invocationJobSummaries.map((item) => ModelInvocationJobSummaryFilterSensitiveLog(item)),
    }),
});
export const CreatePromptRouterRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const GetPromptRouterResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const PromptRouterSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const ListPromptRoutersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.promptRouterSummaries && {
        promptRouterSummaries: obj.promptRouterSummaries.map((item) => PromptRouterSummaryFilterSensitiveLog(item)),
    }),
});
export const CreateModelCustomizationJobRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.trainingDataConfig && { trainingDataConfig: TrainingDataConfigFilterSensitiveLog(obj.trainingDataConfig) }),
    ...(obj.customizationConfig && { customizationConfig: obj.customizationConfig }),
});
export const GetModelCustomizationJobResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.trainingDataConfig && { trainingDataConfig: TrainingDataConfigFilterSensitiveLog(obj.trainingDataConfig) }),
    ...(obj.customizationConfig && { customizationConfig: obj.customizationConfig }),
});
export const RetrievalFilterFilterSensitiveLog = (obj) => {
    if (obj.equals !== undefined)
        return { equals: obj.equals };
    if (obj.notEquals !== undefined)
        return { notEquals: obj.notEquals };
    if (obj.greaterThan !== undefined)
        return { greaterThan: obj.greaterThan };
    if (obj.greaterThanOrEquals !== undefined)
        return { greaterThanOrEquals: obj.greaterThanOrEquals };
    if (obj.lessThan !== undefined)
        return { lessThan: obj.lessThan };
    if (obj.lessThanOrEquals !== undefined)
        return { lessThanOrEquals: obj.lessThanOrEquals };
    if (obj.in !== undefined)
        return { in: obj.in };
    if (obj.notIn !== undefined)
        return { notIn: obj.notIn };
    if (obj.startsWith !== undefined)
        return { startsWith: obj.startsWith };
    if (obj.listContains !== undefined)
        return { listContains: obj.listContains };
    if (obj.stringContains !== undefined)
        return { stringContains: obj.stringContains };
    if (obj.andAll !== undefined)
        return { andAll: SENSITIVE_STRING };
    if (obj.orAll !== undefined)
        return { orAll: SENSITIVE_STRING };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const KnowledgeBaseVectorSearchConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.filter && { filter: SENSITIVE_STRING }),
    ...(obj.implicitFilterConfiguration && {
        implicitFilterConfiguration: ImplicitFilterConfigurationFilterSensitiveLog(obj.implicitFilterConfiguration),
    }),
    ...(obj.rerankingConfiguration && {
        rerankingConfiguration: VectorSearchRerankingConfigurationFilterSensitiveLog(obj.rerankingConfiguration),
    }),
});
export const KnowledgeBaseRetrievalConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.vectorSearchConfiguration && {
        vectorSearchConfiguration: KnowledgeBaseVectorSearchConfigurationFilterSensitiveLog(obj.vectorSearchConfiguration),
    }),
});
export const KnowledgeBaseRetrieveAndGenerateConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.retrievalConfiguration && {
        retrievalConfiguration: KnowledgeBaseRetrievalConfigurationFilterSensitiveLog(obj.retrievalConfiguration),
    }),
    ...(obj.generationConfiguration && {
        generationConfiguration: GenerationConfigurationFilterSensitiveLog(obj.generationConfiguration),
    }),
});
export const RetrieveConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.knowledgeBaseRetrievalConfiguration && {
        knowledgeBaseRetrievalConfiguration: KnowledgeBaseRetrievalConfigurationFilterSensitiveLog(obj.knowledgeBaseRetrievalConfiguration),
    }),
});
export const RetrieveAndGenerateConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.knowledgeBaseConfiguration && {
        knowledgeBaseConfiguration: KnowledgeBaseRetrieveAndGenerateConfigurationFilterSensitiveLog(obj.knowledgeBaseConfiguration),
    }),
    ...(obj.externalSourcesConfiguration && {
        externalSourcesConfiguration: ExternalSourcesRetrieveAndGenerateConfigurationFilterSensitiveLog(obj.externalSourcesConfiguration),
    }),
});
export const KnowledgeBaseConfigFilterSensitiveLog = (obj) => {
    if (obj.retrieveConfig !== undefined)
        return { retrieveConfig: RetrieveConfigFilterSensitiveLog(obj.retrieveConfig) };
    if (obj.retrieveAndGenerateConfig !== undefined)
        return {
            retrieveAndGenerateConfig: RetrieveAndGenerateConfigurationFilterSensitiveLog(obj.retrieveAndGenerateConfig),
        };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const RAGConfigFilterSensitiveLog = (obj) => {
    if (obj.knowledgeBaseConfig !== undefined)
        return { knowledgeBaseConfig: KnowledgeBaseConfigFilterSensitiveLog(obj.knowledgeBaseConfig) };
    if (obj.precomputedRagSourceConfig !== undefined)
        return { precomputedRagSourceConfig: obj.precomputedRagSourceConfig };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const EvaluationInferenceConfigFilterSensitiveLog = (obj) => {
    if (obj.models !== undefined)
        return { models: obj.models.map((item) => EvaluationModelConfigFilterSensitiveLog(item)) };
    if (obj.ragConfigs !== undefined)
        return { ragConfigs: obj.ragConfigs.map((item) => RAGConfigFilterSensitiveLog(item)) };
    if (obj.$unknown !== undefined)
        return { [obj.$unknown[0]]: "UNKNOWN" };
};
export const CreateEvaluationJobRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.jobDescription && { jobDescription: SENSITIVE_STRING }),
    ...(obj.evaluationConfig && { evaluationConfig: EvaluationConfigFilterSensitiveLog(obj.evaluationConfig) }),
    ...(obj.inferenceConfig && { inferenceConfig: EvaluationInferenceConfigFilterSensitiveLog(obj.inferenceConfig) }),
});
export const GetEvaluationJobResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.jobDescription && { jobDescription: SENSITIVE_STRING }),
    ...(obj.evaluationConfig && { evaluationConfig: EvaluationConfigFilterSensitiveLog(obj.evaluationConfig) }),
    ...(obj.inferenceConfig && { inferenceConfig: EvaluationInferenceConfigFilterSensitiveLog(obj.inferenceConfig) }),
});
