# -*- coding: utf-8 -*-
from __future__ import annotations

from typing import TYPE_CHECKING

from pyglossary.option import (
	BoolOption,
	EncodingOption,
	IntOption,
	StrOption,
)

from .writer import Writer

if TYPE_CHECKING:
	from pyglossary.option import Option

__all__ = [
	"Writer",
	"description",
	"enable",
	"extensionCreate",
	"extensions",
	"kind",
	"lname",
	"name",
	"optionsProp",
	"singleFile",
	"website",
	"wiki",
]

enable = True
lname = "html_dir"
name = "HtmlDir"
description = "HTML Directory"
extensions = (".hdir",)
extensionCreate = ".hdir/"
singleFile = False
kind = "directory"
wiki = ""
website = None
optionsProp: dict[str, Option] = {
	"encoding": EncodingOption(),
	"resources": BoolOption(
		comment="Enable resources / data files",
	),
	"max_file_size": IntOption(
		comment="Maximum file size in bytes",
		minim=0,
		maxim=1_000_0000_000,
	),
	"filename_format": StrOption(
		comment="Filename format",
	),
	"escape_defi": BoolOption(
		comment="Escape definitions",
	),
	"dark": BoolOption(
		comment="Use dark style",
	),
	"css": StrOption(
		comment="Path to css file",
	),
	"word_title": BoolOption(
		comment="Add headwords title to beginning of definition",
	),
}
