import numpy as np
import matplotlib.pyplot as plt
from matplotlib.ticker import ScalarFormatter
import astropy.units as u

from dust_extinction.parameter_averages import G16

fig, ax = plt.subplots()

# temp model to get the correct x range
text_model = G16()

# generate the curves and plot them
x = np.arange(text_model.x_range[0], text_model.x_range[1],0.1)/u.micron

Rvs = [2.0, 3.0, 4.0, 5.0, 6.0]
for cur_Rv in Rvs:
   ext_model = G16(RvA=cur_Rv, fA=1.0)
   ax.plot(1./x,ext_model(x),label=r'$R_A(V) = ' + str(cur_Rv) + '$')

ax.set_xscale('log')
ax.xaxis.set_major_formatter(ScalarFormatter())

ax.set_xlabel(r'$\lambda$ [$\mu$m]')
ax.set_ylabel(r'$A(\lambda)/A(V)$')

ax.set_title('G16; $f_A = 1.0$; $R(V)_A$ variable')

ax.legend(loc='best', title=r'$f_A = 1.0$')
plt.tight_layout()
plt.show()