import numpy as np
import matplotlib.pyplot as plt
from astropy.modeling import models
from astropy import units as u
from specutils.spectra import Spectrum
from specutils.fitting import fit_lines
#
np.random.seed(42)
#
g1 = models.Gaussian1D(1, 4.6, 0.2)
g2 = models.Gaussian1D(2.5, 5.5, 0.1)
x = np.linspace(0, 10, 200)
y = g1(x) + g2(x) + np.random.normal(0., 0.2, x.shape)
#
spectrum = Spectrum(flux=y*u.Jy, spectral_axis=x*u.um)
#
gl_init = models.Gaussian1D(amplitude=1.*u.Jy, mean=4.8*u.um, stddev=0.2*u.um)
gr_init = models.Gaussian1D(amplitude=2.*u.Jy, mean=5.3*u.um, stddev=0.2*u.um)
gl_fit, gr_fit = fit_lines(spectrum, [gl_init, gr_init], window=[(4.6*u.um, 5.3*u.um), (5.3*u.um, 5.8*u.um)])
yl_fit = gl_fit(x*u.um)
yr_fit = gr_fit(x*u.um)
#
f, ax = plt.subplots()  # doctest: +IGNORE_OUTPUT
ax.plot(x, y)  # doctest: +IGNORE_OUTPUT
ax.plot(x, yl_fit)  # doctest: +IGNORE_OUTPUT
ax.plot(x, yr_fit)  # doctest: +IGNORE_OUTPUT
ax.set_title("Double Peak - Two Models and Two Windows")  # doctest: +IGNORE_OUTPUT
ax.grid(True)  # doctest: +IGNORE_OUTPUT
