/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variableeditor.actions;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabLAF;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.types.ScilabTypeEnumDescription;
import org.scilab.modules.ui_data.datatable.SwingEditvarTableModel;
import org.scilab.modules.ui_data.variablebrowser.SwingScilabVariableBrowser;
import org.scilab.modules.ui_data.variableeditor.SwingScilabVariableEditor;

public final class PlotAction
extends CommonCallBack {
    public static final int PLOT2D = 0;
    public static final int MATPLOT = 1;
    public static final int GRAYPLOT = 2;
    public static final int SGRAYPLOT = 3;
    public static final int CHAMP = 4;
    public static final int HISTPLOT = 5;
    public static final int MESH = 6;
    public static final int SURF = 7;
    public static final int BAR3D = 8;
    public static final int CONTOUR2D = 9;
    public static final int PIE = 10;
    private static final Map<String, Integer> map = new HashMap<String, Integer>();
    private static final String COM_PLOT2D = "plot2d(%s);";
    private static final String COM_MATPLOT = "Matplot(%s);";
    private static final String COM_GRAYPLOT = "grayplot(1:%s,1:%s,%s);";
    private static final String COM_SGRAYPLOT = "Sgrayplot(1:%s,1:%s,%s);";
    private static final String COM_CHAMP = "champ(1:%s,1:%s,real(%s),imag(%s));";
    private static final String COM_HISTPLOT = "histplot(10,%s);";
    private static final String COM_MESH = "mesh(%s);";
    private static final String COM_SURF = "surf(%s);";
    private static final String COM_BAR3D = "bar3d(%s);";
    private static final String COM_CONTOUR2D = "contour2d(1:%s,1:%s,%s,10);";
    private static final String COM_PIE = "L?8625083632641564278=%s;pie(L?8625083632641564278(find(L?8625083632641564278>0&L?8625083632641564278<>%%inf&L?8625083632641564278<>%%nan)));";
    private static final String[] COMMANDS;
    private static final String[] IMG;
    private static final String CREATE = "Create";
    private final SwingScilabDockablePanel editor;
    private final int type;
    private final boolean onSelection;

    public PlotAction(SwingScilabDockablePanel swingScilabDockablePanel, String string, boolean bl) {
        super(string);
        this.editor = swingScilabDockablePanel;
        this.type = map.get(string);
        this.onSelection = bl;
    }

    public void callBack() {
        Object object;
        Object object2 = null;
        int n = 0;
        int n2 = 0;
        String string = null;
        SwingEditvarTableModel swingEditvarTableModel = null;
        if (this.editor instanceof SwingScilabVariableEditor) {
            object = ((SwingScilabVariableEditor)this.editor).getCurrentTable();
            swingEditvarTableModel = (SwingEditvarTableModel)((JTable)object).getModel();
            string = swingEditvarTableModel.getType();
            if (!this.onSelection) {
                n = swingEditvarTableModel.getScilabMatrixRowCount();
                n2 = swingEditvarTableModel.getScilabMatrixColCount();
                object2 = swingEditvarTableModel.getVarName();
            } else {
                int[] nArray = ((JTable)object).getSelectedColumns();
                int[] nArray2 = ((JTable)object).getSelectedRows();
                if (nArray == null || nArray.length == 0 || nArray2 == null || nArray2.length == 0) {
                    n = swingEditvarTableModel.getScilabMatrixRowCount();
                    n2 = swingEditvarTableModel.getScilabMatrixColCount();
                    object2 = swingEditvarTableModel.getVarName();
                } else {
                    if (swingEditvarTableModel.getType().equals("String")) {
                        return;
                    }
                    int[] nArray3 = new int[1];
                    int[] nArray4 = new int[1];
                    object2 = swingEditvarTableModel.getScilabSubMatrix(nArray2, nArray, nArray3, nArray4);
                    if (object2 == null) {
                        return;
                    }
                    n = nArray3[0];
                    n2 = nArray4[0];
                }
            }
            if (!string.equals("Double")) {
                object2 = "double(" + (String)object2 + ")";
            }
        } else {
            int n3 = ((SwingScilabVariableBrowser)this.editor).getTable().getSelectedRow();
            if (n3 != -1) {
                n = Integer.parseInt(((SwingScilabVariableBrowser)this.editor).getTable().getModel().getValueAt(n3, 8).toString());
                n2 = Integer.parseInt(((SwingScilabVariableBrowser)this.editor).getTable().getModel().getValueAt(n3, 9).toString());
                object2 = ((SwingScilabVariableBrowser)this.editor).getTable().getValueAt(n3, 1).toString();
            }
            int n4 = ((SwingScilabVariableBrowser)this.editor).getTable().convertRowIndexToModel(n3);
            int n5 = Integer.parseInt(((SwingScilabVariableBrowser)this.editor).getTable().getModel().getValueAt(n4, 7).toString());
            if (!ScilabTypeEnumDescription.getTypeDescriptionFromId((int)n5).equals("Double")) {
                object2 = "double(" + (String)object2 + ")";
            }
        }
        if (n == 0 || n2 == 0) {
            return;
        }
        object = COMMANDS[this.type];
        switch (this.type) {
            case 0: 
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                object = String.format((String)object, object2);
                break;
            }
            case 2: 
            case 3: {
                object = String.format((String)object, n, n2, object2);
                break;
            }
            case 4: {
                object = String.format((String)object, n, n2, object2, object2);
                break;
            }
            case 9: {
                if (n >= 2 && n2 >= 2) {
                    object = String.format((String)object, n, n2, object2);
                    break;
                }
                return;
            }
        }
        if (this.editor instanceof SwingScilabVariableEditor) {
            swingEditvarTableModel.execCommand("scf();" + (String)object);
        } else {
            try {
                ScilabInterpreterManagement.asynchronousScilabExec(null, (String)("scf();" + (String)object));
            }
            catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
                System.err.println("An error in the interpreter has been catched: " + interpreterException.getLocalizedMessage());
            }
        }
    }

    public static JButton createButton(SwingScilabDockablePanel swingScilabDockablePanel, String string) {
        final JButton jButton = new JButton();
        ScilabLAF.setDefaultProperties((AbstractButton)jButton);
        jButton.setToolTipText(string);
        ImageIcon imageIcon = new ImageIcon(FindIconHelper.findIcon((String)"plot"));
        jButton.setIcon(imageIcon);
        final JPopupMenu jPopupMenu = new JPopupMenu(){

            @Override
            public void show(Component component, int n, int n2) {
                super.show(jButton, 0, jButton.getBounds(null).height);
            }
        };
        jPopupMenu.setBorderPainted(true);
        jPopupMenu.add((JMenuItem)PlotAction.createJMenuItem(swingScilabDockablePanel, "plot2d", true));
        jPopupMenu.add((JMenuItem)PlotAction.createJMenuItem(swingScilabDockablePanel, "Matplot", true));
        jPopupMenu.add((JMenuItem)PlotAction.createJMenuItem(swingScilabDockablePanel, "grayplot", true));
        jPopupMenu.add((JMenuItem)PlotAction.createJMenuItem(swingScilabDockablePanel, "Sgrayplot", true));
        jPopupMenu.add((JMenuItem)PlotAction.createJMenuItem(swingScilabDockablePanel, "champ", true));
        jPopupMenu.add((JMenuItem)PlotAction.createJMenuItem(swingScilabDockablePanel, "histplot", true));
        jPopupMenu.add((JMenuItem)PlotAction.createJMenuItem(swingScilabDockablePanel, "mesh", true));
        jPopupMenu.add((JMenuItem)PlotAction.createJMenuItem(swingScilabDockablePanel, "surf", true));
        jPopupMenu.add((JMenuItem)PlotAction.createJMenuItem(swingScilabDockablePanel, "bar3d", true));
        jPopupMenu.add((JMenuItem)PlotAction.createJMenuItem(swingScilabDockablePanel, "contour2d", true));
        jPopupMenu.add((JMenuItem)PlotAction.createJMenuItem(swingScilabDockablePanel, "pie", true));
        jPopupMenu.pack();
        jButton.addActionListener((ActionListener)new CommonCallBack(null){

            public void callBack() {
                if (!jPopupMenu.isVisible()) {
                    jPopupMenu.show(null, 0, 0);
                } else {
                    jPopupMenu.setVisible(false);
                }
            }
        });
        return jButton;
    }

    public static MenuItem createMenuItem(SwingScilabDockablePanel swingScilabDockablePanel, String string, boolean bl) {
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setCallback((CommonCallBack)new PlotAction(swingScilabDockablePanel, string, bl));
        menuItem.setText(string);
        ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).setIcon((Icon)new ImageIcon(FindIconHelper.findIcon((String)IMG[map.get(string)])));
        return menuItem;
    }

    public static SwingScilabMenuItem createJMenuItem(SwingScilabDockablePanel swingScilabDockablePanel, String string, boolean bl) {
        return (SwingScilabMenuItem)PlotAction.createMenuItem(swingScilabDockablePanel, string, bl).getAsSimpleMenuItem();
    }

    static {
        map.put("plot2d", 0);
        map.put("Matplot", 1);
        map.put("grayplot", 2);
        map.put("Sgrayplot", 3);
        map.put("champ", 4);
        map.put("histplot", 5);
        map.put("mesh", 6);
        map.put("surf", 7);
        map.put("bar3d", 8);
        map.put("contour2d", 9);
        map.put("pie", 10);
        COMMANDS = new String[]{COM_PLOT2D, COM_MATPLOT, COM_GRAYPLOT, COM_SGRAYPLOT, COM_CHAMP, COM_HISTPLOT, COM_MESH, COM_SURF, COM_BAR3D, COM_CONTOUR2D, COM_PIE};
        IMG = new String[]{"application-x-scilab-plot2d", "application-x-scilab-Matplot", "application-x-scilab-grayplot", "application-x-scilab-Sgrayplot", "application-x-scilab-champ", "application-x-scilab-histplot", "application-x-scilab-mesh", "application-x-scilab-surf", "application-x-scilab-bar3d", "application-x-scilab-contour2d", "application-x-scilab-pie"};
    }
}

