/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variableeditor.renderers;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;

public class ScilabComplexRenderer
extends DefaultTableCellRenderer {
    public static final int SHORT = 0;
    public static final int SHORTE = 1;
    public static final int LONG = 2;
    public static final int LONGE = 3;
    private static final NumberFormat NUMBERFORMAT = NumberFormat.getInstance();
    private static final DecimalFormatSymbols SYMBOLS = DecimalFormatSymbols.getInstance();
    private static final DecimalFormat SHORTFORMAT = new DecimalFormat("#.####");
    private static final DecimalFormat SHORTEFORMAT = new DecimalFormat("#.####E00");
    private static final DecimalFormat LONGFORMAT = new DecimalFormat("#.###############");
    private static final DecimalFormat LONGEFORMAT = new DecimalFormat("#.###############E00");
    private static final String I = "i";
    private static final String PLUS = "+";
    private static NumberFormat numberFormat;
    private static NumberFormat numberFormatE;
    private Map desktopFontHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
    private boolean areHintsSet = false;
    private int ascent = -1;
    private Font fontFori;

    public static void setFormat(int n) {
        switch (n) {
            case 0: {
                numberFormat = SHORTFORMAT;
                numberFormatE = SHORTFORMAT;
                break;
            }
            case 1: {
                numberFormat = SHORTEFORMAT;
                numberFormatE = SHORTEFORMAT;
                break;
            }
            case 2: {
                numberFormat = LONGFORMAT;
                numberFormatE = LONGEFORMAT;
                break;
            }
            case 3: {
                numberFormat = LONGEFORMAT;
                numberFormatE = LONGEFORMAT;
            }
        }
    }

    @Override
    protected void setValue(Object object) {
        if (object == null) {
            super.setValue("");
        } else if (object instanceof String) {
            super.setValue(object);
        } else {
            super.setValue(ScilabComplexRenderer.convertComplex((Double[])object));
        }
    }

    protected static String convertDouble(Double d) {
        double d2 = d;
        if (Math.abs(d2) < 1000.0 && Math.abs(d2) > 0.001 || d2 == 0.0) {
            return ScilabComplexRenderer.addSignToExponent(numberFormat.format(d2));
        }
        return ScilabComplexRenderer.addSignToExponent(numberFormatE.format(d2));
    }

    private static String addSignToExponent(String string) {
        return string.replaceAll("e([0-9])", "e+$1");
    }

    private static String convertComplex(Double[] doubleArray) {
        String string = "";
        String string2 = "";
        if (doubleArray[0] == 0.0 && doubleArray[1] == 0.0) {
            return "0";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (doubleArray[0] != 0.0) {
            stringBuilder.append(ScilabComplexRenderer.convertDouble(doubleArray[0]));
        }
        if (doubleArray[1] != 0.0) {
            if (doubleArray[1] == 1.0) {
                if (doubleArray[0] == 0.0) {
                    stringBuilder.append(I);
                } else {
                    stringBuilder.append("+i");
                }
            } else if (doubleArray[1] == -1.0) {
                stringBuilder.append("-i");
            } else if (doubleArray[1] < 0.0) {
                stringBuilder.append(ScilabComplexRenderer.convertDouble(doubleArray[1]));
                stringBuilder.append(I);
            } else {
                if (doubleArray[0] != 0.0) {
                    stringBuilder.append(PLUS);
                }
                stringBuilder.append(ScilabComplexRenderer.convertDouble(doubleArray[1]));
                stringBuilder.append(I);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.ascent = -1;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        String string = this.getText();
        if (!string.isEmpty() && string.charAt(string.length() - 1) == 'i') {
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            ((Graphics2D)graphics).addRenderingHints(this.desktopFontHints);
            if (this.ascent == -1) {
                this.ascent = fontMetrics.getAscent();
                this.fontFori = new Font("Serif", 3, font.getSize());
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(this.getForeground());
            graphics.setFont(font);
            String string2 = string.substring(0, string.length() - 1);
            int n = SwingUtilities.computeStringWidth(fontMetrics, string2);
            graphics.drawString(string2, 0, this.ascent);
            graphics.setFont(this.fontFori);
            graphics.drawString(I, n + 1, this.ascent);
        } else {
            super.paintComponent(graphics);
        }
    }

    protected static boolean isNull(Double[] doubleArray) {
        return doubleArray == null || doubleArray[0] == 0.0 && doubleArray[1] == 0.0;
    }

    static {
        SYMBOLS.setInfinity("\u221e");
        SYMBOLS.setNaN("Nan");
        SYMBOLS.setExponentSeparator("e");
        SHORTFORMAT.setDecimalFormatSymbols(SYMBOLS);
        SHORTEFORMAT.setDecimalFormatSymbols(SYMBOLS);
        LONGFORMAT.setDecimalFormatSymbols(SYMBOLS);
        LONGEFORMAT.setDecimalFormatSymbols(SYMBOLS);
        numberFormat = SHORTFORMAT;
        numberFormatE = SHORTEFORMAT;
    }
}

