/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.texture;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.implementation.g2d.G2DCanvas;
import org.scilab.forge.scirenderer.implementation.g2d.G2DDrawingTools;
import org.scilab.forge.scirenderer.texture.AbstractTexture;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDataProvider;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.forge.scirenderer.texture.TextureManager;

public class G2DTextureManager
implements TextureManager {
    private static Map<ImageBuffer, ImageBuffer> images = new HashMap<ImageBuffer, ImageBuffer>();

    public G2DTextureManager(G2DCanvas g2DCanvas) {
    }

    public static void clear() {
        images.clear();
    }

    public void draw(G2DDrawingTools g2DDrawingTools, Texture texture) throws SciRendererException {
        if (texture instanceof G2DTexture) {
            ((G2DTexture)texture).draw(g2DDrawingTools);
        }
    }

    @Override
    public Texture createTexture() {
        return new G2DTexture();
    }

    @Override
    public void dispose(Collection<Texture> collection) {
        for (Texture texture : collection) {
            this.dispose(texture);
        }
    }

    @Override
    public void dispose(Texture texture) {
        if (texture instanceof G2DTexture) {
            ((G2DTexture)texture).dispose();
        }
    }

    private static final int toColorComp(float f) {
        return f < 0.0f ? 0 : (f > 1.0f ? 255 : (int)(f * 255.0f));
    }

    public static class G2DTexture
    extends AbstractTexture
    implements Texture {
        private ImageBuffer image;
        private TextureDrawer drawer;

        public void dispose() {
            images.remove(this.image);
        }

        @Override
        public void setDrawer(TextureDrawer textureDrawer) {
            this.drawer = textureDrawer;
            super.setDrawer(textureDrawer);
        }

        public TextureDrawer getDrawer() {
            return this.drawer;
        }

        public void draw(G2DDrawingTools g2DDrawingTools) {
            g2DDrawingTools.getMotor3D().drawTexture(g2DDrawingTools, this.getImage(), this);
        }

        public BufferedImage getImage() {
            if (this.image == null) {
                ImageBuffer imageBuffer;
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                Dimension dimension = this.getDataProvider().getTextureSize();
                ByteBuffer byteBuffer = this.getDataProvider().getData();
                TextureDataProvider.ImageType imageType = this.getDataProvider().getImageType();
                int n6 = 1;
                int[] nArray = null;
                ByteOrder byteOrder = ByteOrder.nativeOrder();
                switch (imageType) {
                    case RGB: {
                        int n7;
                        n6 = 1;
                        nArray = new int[byteBuffer.capacity() / 3];
                        int n8 = 0;
                        for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 3) {
                            nArray[n8++] = (byteBuffer.get(n7) & 0xFF) << 16 | (byteBuffer.get(n7 + 1) & 0xFF) << 8 | byteBuffer.get(n7 + 2) & 0xFF;
                        }
                        break;
                    }
                    case RGB_RGBA: {
                        int n7;
                        n6 = 1;
                        nArray = new int[byteBuffer.capacity() / 4];
                        int n9 = 0;
                        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 4) {
                                nArray[n9++] = (byteBuffer.get(n7 + 3) & 0xFF) << 16 | (byteBuffer.get(n7 + 2) & 0xFF) << 8 | byteBuffer.get(n7 + 1) & 0xFF;
                            }
                        } else {
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 4) {
                                nArray[n9++] = (byteBuffer.get(n7) & 0xFF) << 16 | (byteBuffer.get(n7 + 1) & 0xFF) << 8 | byteBuffer.get(n7 + 2) & 0xFF;
                            }
                        }
                        break;
                    }
                    case BGR: {
                        int n7;
                        n6 = 4;
                        nArray = new int[byteBuffer.capacity() / 3];
                        int n10 = 0;
                        for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 3) {
                            nArray[n10++] = (byteBuffer.get(n7) & 0xFF) << 16 | (byteBuffer.get(n7 + 1) & 0xFF) << 8 | byteBuffer.get(n7 + 2) & 0xFF;
                        }
                        break;
                    }
                    case GRAY: {
                        int n7;
                        n6 = 1;
                        nArray = new int[byteBuffer.capacity()];
                        for (int i = 0; i < byteBuffer.capacity(); ++i) {
                            n7 = byteBuffer.get(i) & 0xFF;
                            nArray[i] = n7 << 16 | n7 << 8 | n7;
                        }
                        break;
                    }
                    case GRAY_16: {
                        int n7;
                        n6 = 1;
                        nArray = new int[byteBuffer.capacity() / 2];
                        int n11 = 0;
                        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 2) {
                                n5 = ((byteBuffer.get(n7 + 1) & 0xFF) << 8 | byteBuffer.get(n7) & 0xFF) / 257;
                                nArray[n11++] = n5 << 16 | n5 << 8 | n5;
                            }
                        } else {
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 2) {
                                n5 = ((byteBuffer.get(n7) & 0xFF) << 8 | byteBuffer.get(n7 + 1) & 0xFF) / 257;
                                nArray[n11++] = n5 << 16 | n5 << 8 | n5;
                            }
                        }
                        break;
                    }
                    case RGBA: {
                        int n7;
                        n6 = 2;
                        nArray = new int[byteBuffer.capacity() / 4];
                        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                            int n12 = 0;
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 4) {
                                nArray[n12++] = (byteBuffer.get(n7) & 0xFF) << 24 | (byteBuffer.get(n7 + 3) & 0xFF) << 16 | (byteBuffer.get(n7 + 2) & 0xFF) << 8 | byteBuffer.get(n7 + 1) & 0xFF;
                            }
                        } else {
                            int n13 = 0;
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 4) {
                                nArray[n13++] = (byteBuffer.get(n7 + 3) & 0xFF) << 24 | (byteBuffer.get(n7) & 0xFF) << 16 | (byteBuffer.get(n7 + 1) & 0xFF) << 8 | byteBuffer.get(n7 + 2) & 0xFF;
                            }
                        }
                        break;
                    }
                    case RGBA_REV: {
                        int n7;
                        n6 = 2;
                        nArray = new int[byteBuffer.capacity() / 4];
                        if (byteOrder == ByteOrder.BIG_ENDIAN) {
                            int n14 = 0;
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 4) {
                                nArray[n14++] = (byteBuffer.get(n7) & 0xFF) << 24 | (byteBuffer.get(n7 + 3) & 0xFF) << 16 | (byteBuffer.get(n7 + 2) & 0xFF) << 8 | byteBuffer.get(n7 + 1) & 0xFF;
                            }
                        } else {
                            int n15 = 0;
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 4) {
                                nArray[n15++] = (byteBuffer.get(n7 + 3) & 0xFF) << 24 | (byteBuffer.get(n7) & 0xFF) << 16 | (byteBuffer.get(n7 + 1) & 0xFF) << 8 | byteBuffer.get(n7 + 2) & 0xFF;
                            }
                        }
                        break;
                    }
                    case ABGR: {
                        int n7;
                        n6 = 2;
                        nArray = new int[byteBuffer.capacity() / 4];
                        int n16 = 0;
                        for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 4) {
                            nArray[n16++] = (byteBuffer.get(n7) & 0xFF) << 24 | (byteBuffer.get(n7 + 3) & 0xFF) << 16 | (byteBuffer.get(n7 + 2) & 0xFF) << 8 | byteBuffer.get(n7 + 1) & 0xFF;
                        }
                        break;
                    }
                    case RGB_332: {
                        int n7;
                        n6 = 1;
                        nArray = new int[byteBuffer.capacity()];
                        for (int i = 0; i < byteBuffer.capacity(); ++i) {
                            n7 = byteBuffer.get(i) & 0xFF;
                            nArray[i] = (n7 >> 5 & 7) * 255 / 7 << 16 | (n7 >> 2 & 7) * 255 / 7 << 8 | (n7 & 3) * 255 / 3;
                        }
                        break;
                    }
                    case RED: {
                        n6 = 1;
                        nArray = new int[byteBuffer.capacity()];
                        for (int i = 0; i < byteBuffer.capacity(); ++i) {
                            nArray[i] = (byteBuffer.get(i) & 0xFF) << 16;
                        }
                        break;
                    }
                    case GREEN: {
                        n6 = 1;
                        nArray = new int[byteBuffer.capacity()];
                        for (int i = 0; i < byteBuffer.capacity(); ++i) {
                            nArray[i] = (byteBuffer.get(i) & 0xFF) << 8;
                        }
                        break;
                    }
                    case BLUE: {
                        n6 = 1;
                        nArray = new int[byteBuffer.capacity()];
                        for (int i = 0; i < byteBuffer.capacity(); ++i) {
                            nArray[i] = byteBuffer.get(i) & 0xFF;
                        }
                        break;
                    }
                    case INTENSITY: {
                        int n7;
                        n6 = 2;
                        nArray = new int[byteBuffer.capacity()];
                        for (int i = 0; i < byteBuffer.capacity(); ++i) {
                            n7 = byteBuffer.get(i) & 0xFF;
                            nArray[i] = n7 << 24 | n7 << 16 | n7 << 8 | n7;
                        }
                        break;
                    }
                    case RGBA_4444: {
                        int n7;
                        n6 = 2;
                        nArray = new int[byteBuffer.capacity() / 2];
                        int n17 = 0;
                        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 2) {
                                n5 = byteBuffer.get(n7) & 0xFF;
                                n4 = (n5 >> 4 & 0xF) * 17;
                                n3 = (n5 & 0xF) * 17;
                                n5 = byteBuffer.get(n7 + 1) & 0xFF;
                                n2 = (n5 >> 4 & 0xF) * 17;
                                n = (n5 & 0xF) * 17;
                                nArray[n17++] = n3 << 24 | n2 << 16 | n << 8 | n4;
                            }
                        } else {
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 2) {
                                n5 = byteBuffer.get(n7 + 1) & 0xFF;
                                n4 = (n5 >> 4 & 0xF) * 47;
                                n3 = (n5 & 0xF) * 47;
                                n5 = byteBuffer.get(n7) & 0xFF;
                                n2 = (n5 >> 4 & 0xF) * 47;
                                n = (n5 & 0xF) * 47;
                                nArray[n17++] = n3 << 24 | n2 << 16 | n << 8 | n4;
                            }
                        }
                        break;
                    }
                    case RGBA_5551: {
                        int n7;
                        n6 = 2;
                        nArray = new int[byteBuffer.capacity() / 2];
                        int n18 = 0;
                        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 2) {
                                n5 = byteBuffer.get(n7) & 0xFF;
                                n4 = (n5 >> 1 & 0x1F) * 255 / 31;
                                n3 = (n5 & 1) * 255;
                                n2 = n5 >> 6 & 3;
                                n5 = byteBuffer.get(n7 + 1) & 0xFF;
                                n = (n5 >> 3 & 0x1F) * 255 / 31;
                                n2 = ((n5 & 7) << 2 | n2) * 255 / 31;
                                nArray[n18++] = n3 << 24 | n << 16 | n2 << 8 | n4;
                            }
                        } else {
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 2) {
                                n5 = byteBuffer.get(n7 + 1) & 0xFF;
                                n4 = (n5 >> 1 & 0x1F) * 255 / 31;
                                n3 = (n5 & 1) * 255;
                                n2 = n5 >> 6 & 3;
                                n5 = byteBuffer.get(n7) & 0xFF;
                                n = (n5 >> 3 & 0x1F) * 255 / 31;
                                n2 = ((n5 & 7) << 2 | n2) * 255 / 31;
                                nArray[n18++] = n3 << 24 | n << 16 | n2 << 8 | n4;
                            }
                        }
                        break;
                    }
                    case RGB_FLOAT: {
                        n6 = 1;
                        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                        nArray = new int[floatBuffer.capacity() / 3];
                        int n7 = 0;
                        for (n5 = 0; n5 < floatBuffer.capacity(); n5 += 3) {
                            nArray[n7++] = G2DTextureManager.toColorComp(floatBuffer.get(n5)) << 16 | G2DTextureManager.toColorComp(byteBuffer.get(n5 + 1)) << 8 | G2DTextureManager.toColorComp(byteBuffer.get(n5 + 2));
                        }
                        break;
                    }
                    case RGBA_FLOAT: {
                        n6 = 2;
                        byteBuffer.order(byteOrder);
                        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                        nArray = new int[floatBuffer.capacity() / 4];
                        int n7 = 0;
                        for (n5 = 0; n5 < floatBuffer.capacity(); n5 += 4) {
                            nArray[n7++] = G2DTextureManager.toColorComp(floatBuffer.get(n5 + 3)) << 24 | G2DTextureManager.toColorComp(floatBuffer.get(n5)) << 16 | G2DTextureManager.toColorComp(floatBuffer.get(n5 + 1)) << 8 | G2DTextureManager.toColorComp(floatBuffer.get(n5 + 2));
                        }
                        break;
                    }
                    case GRAY_FLOAT: {
                        int n7;
                        n6 = 1;
                        byteBuffer.order(byteOrder);
                        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                        nArray = new int[floatBuffer.capacity()];
                        for (n7 = 0; n7 < floatBuffer.capacity(); ++n7) {
                            n5 = G2DTextureManager.toColorComp(floatBuffer.get(n7));
                            nArray[n7] = n5 << 16 | n5 << 8 | n5;
                        }
                        break;
                    }
                    case RED_16: {
                        int n7;
                        n6 = 1;
                        nArray = new int[byteBuffer.capacity() / 2];
                        int n19 = 0;
                        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 2) {
                                n5 = ((byteBuffer.get(n7 + 1) & 0xFF) << 8 | byteBuffer.get(n7) & 0xFF) / 257;
                                nArray[n19++] = n5 << 16;
                            }
                        } else {
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 2) {
                                n5 = ((byteBuffer.get(n7) & 0xFF) << 8 | byteBuffer.get(n7 + 1) & 0xFF) / 257;
                                nArray[n19++] = n5 << 16;
                            }
                        }
                        break;
                    }
                    case GREEN_16: {
                        int n7;
                        n6 = 1;
                        nArray = new int[byteBuffer.capacity() / 2];
                        int n20 = 0;
                        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 2) {
                                n5 = ((byteBuffer.get(n7 + 1) & 0xFF) << 8 | byteBuffer.get(n7) & 0xFF) / 257;
                                nArray[n20++] = n5 << 8;
                            }
                        } else {
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 2) {
                                n5 = ((byteBuffer.get(n7) & 0xFF) << 8 | byteBuffer.get(n7 + 1) & 0xFF) / 257;
                                nArray[n20++] = n5 << 8;
                            }
                        }
                        break;
                    }
                    case BLUE_16: {
                        int n7;
                        n6 = 1;
                        nArray = new int[byteBuffer.capacity() / 2];
                        int n21 = 0;
                        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 2) {
                                n5 = ((byteBuffer.get(n7 + 1) & 0xFF) << 8 | byteBuffer.get(n7) & 0xFF) / 257;
                                nArray[n21++] = n5;
                            }
                        } else {
                            for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 2) {
                                n5 = ((byteBuffer.get(n7) & 0xFF) << 8 | byteBuffer.get(n7 + 1) & 0xFF) / 257;
                                nArray[n21++] = n5;
                            }
                        }
                        break;
                    }
                    case RED_FLOAT: {
                        int n7;
                        n6 = 1;
                        byteBuffer.order(byteOrder);
                        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                        nArray = new int[floatBuffer.capacity()];
                        for (n7 = 0; n7 < floatBuffer.capacity(); ++n7) {
                            nArray[n7] = G2DTextureManager.toColorComp(floatBuffer.get(n7)) << 16;
                        }
                        break;
                    }
                    case GREEN_FLOAT: {
                        int n7;
                        n6 = 1;
                        byteBuffer.order(byteOrder);
                        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                        nArray = new int[floatBuffer.capacity()];
                        for (n7 = 0; n7 < floatBuffer.capacity(); ++n7) {
                            nArray[n7] = G2DTextureManager.toColorComp(floatBuffer.get(n7)) << 8;
                        }
                        break;
                    }
                    case BLUE_FLOAT: {
                        int n7;
                        n6 = 1;
                        byteBuffer.order(byteOrder);
                        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                        nArray = new int[floatBuffer.capacity()];
                        for (n7 = 0; n7 < floatBuffer.capacity(); ++n7) {
                            nArray[n7] = G2DTextureManager.toColorComp(floatBuffer.get(n7));
                        }
                        break;
                    }
                    case RGBA_BYTE: {
                        int n7;
                        n6 = 2;
                        nArray = new int[byteBuffer.capacity() / 4];
                        int n22 = 0;
                        for (n7 = 0; n7 < byteBuffer.capacity(); n7 += 4) {
                            nArray[n22++] = (byteBuffer.get(n7 + 3) & 0xFF) << 24 | (byteBuffer.get(n7) & 0xFF) << 16 | (byteBuffer.get(n7 + 1) & 0xFF) << 8 | byteBuffer.get(n7 + 2) & 0xFF;
                        }
                        break;
                    }
                }
                if (this.getDataProvider().isRowMajorOrder()) {
                    imageBuffer = new ImageBuffer(n6, nArray, (int)dimension.getWidth(), (int)dimension.getHeight());
                } else {
                    int[] nArray2 = new int[nArray.length];
                    n5 = (int)dimension.getWidth();
                    n4 = (int)dimension.getHeight();
                    n3 = 0;
                    for (n2 = 0; n2 < n4; ++n2) {
                        for (n = 0; n < n5; ++n) {
                            nArray2[n3++] = nArray[n2 + n * n4];
                        }
                    }
                    imageBuffer = new ImageBuffer(n6, nArray2, n5, n4);
                }
                ImageBuffer imageBuffer2 = images.get(imageBuffer);
                if (imageBuffer2 == null) {
                    images.put(imageBuffer, imageBuffer);
                    imageBuffer2 = imageBuffer;
                }
                this.image = imageBuffer2;
            }
            return this.image.getImage();
        }
    }

    private static class ImageBuffer {
        private int[] buffer;
        private int hash;
        private int width;
        private int height;
        private BufferedImage image;
        private int type;

        ImageBuffer(int n, int[] nArray, int n2, int n3) {
            this.type = n;
            this.buffer = nArray;
            this.hash = Arrays.hashCode(nArray) * 31 + n;
            this.width = n2;
            this.height = n3;
        }

        BufferedImage getImage() {
            if (this.image == null) {
                this.image = new BufferedImage(this.width, this.height, this.type);
                this.image.setRGB(0, 0, this.width, this.height, this.buffer, 0, this.width);
            }
            return this.image;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object instanceof ImageBuffer) {
                ImageBuffer imageBuffer = (ImageBuffer)object;
                return this.type == imageBuffer.type && Arrays.equals(this.buffer, imageBuffer.buffer);
            }
            return false;
        }
    }
}

