/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.texture;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.scilab.forge.scirenderer.implementation.jogl.utils.G2DShortCuts;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.texture.TextEntity;
import org.scilab.forge.scirenderer.texture.TextureBufferedImage;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.forge.scirenderer.texture.TextureDrawingTools;

public class BufferedImageTextureDrawingTools
implements TextureDrawingTools {
    private Graphics2D g2d;
    private final TextureBufferedImage image;
    private final Dimension textureSize;
    private final AffineTransform baseTransform;

    public BufferedImageTextureDrawingTools(Dimension dimension) {
        this.image = new TextureBufferedImage(dimension.width, dimension.height);
        this.textureSize = dimension;
        double d = (double)(this.image.getWidth() - dimension.width) / 2.0;
        double d2 = (double)(this.image.getHeight() - dimension.height) / 2.0;
        this.baseTransform = AffineTransform.getTranslateInstance(d, d2);
    }

    public void accept(TextureDrawer textureDrawer) {
        this.g2d = this.image.createGraphics();
        this.g2d.setComposite(AlphaComposite.Src);
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.g2d.transform(this.baseTransform);
        if (textureDrawer.getOriginPosition() == TextureDrawer.OriginPosition.CENTER) {
            this.g2d.translate(this.textureSize.width / 2, this.textureSize.height / 2);
        }
        textureDrawer.draw(this);
        this.g2d.dispose();
    }

    @Override
    public void drawPlus(int n, Appearance appearance) {
        int n2 = n / 2;
        int[] nArray = new int[]{-n2, 0, n2, 0};
        this.drawPolyline(nArray, appearance);
        if (n2 != 0) {
            int[] nArray2 = new int[]{0, -n2, 0, n2};
            this.drawPolyline(nArray2, appearance);
        }
    }

    @Override
    public void drawMinus(int n, Appearance appearance) {
        int n2 = n / 2;
        int[] nArray = new int[]{-n2, 0, n2, 0};
        this.drawPolyline(nArray, appearance);
    }

    @Override
    public void drawVerticalLine(int n, Appearance appearance) {
        int n2 = n / 2;
        int[] nArray = new int[]{0, -n2, 0, n2};
        this.drawPolyline(nArray, appearance);
    }

    @Override
    public void drawPolyline(int[] nArray, Appearance appearance) {
        int n = nArray.length / 2;
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length; i += 2) {
            nArray2[n2] = nArray[i];
            nArray3[n2] = nArray[i + 1];
            ++n2;
        }
        G2DShortCuts.useLineAppearance(this.g2d, appearance);
        G2DShortCuts.useColor(this.g2d, appearance.getLineColor());
        this.g2d.drawPolyline(nArray2, nArray3, n);
    }

    @Override
    public void fillPolygon(int[] nArray, Appearance appearance) {
        int n;
        int n2 = nArray.length / 2;
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int n3 = 0;
        for (n = 0; n < nArray.length; n += 2) {
            nArray2[n3] = nArray[n];
            nArray3[n3] = nArray[n + 1];
            ++n3;
        }
        if (appearance.getFillColor().getAlphaAsFloat() != 0.0f) {
            G2DShortCuts.useColor(this.g2d, appearance.getFillColor());
            this.g2d.fillPolygon(nArray2, nArray3, n2);
        }
        if (!appearance.getLineColor().equals(appearance.getFillColor())) {
            n = nArray.length - nArray.length % 2;
            int[] nArray4 = new int[n + 2];
            System.arraycopy(nArray, 0, nArray4, 0, n);
            nArray4[n] = nArray[0];
            nArray4[n + 1] = nArray[1];
            this.drawPolyline(nArray4, appearance);
        }
    }

    @Override
    public void drawCircle(int n, int n2, int n3, Appearance appearance) {
        G2DShortCuts.useLineAppearance(this.g2d, appearance);
        G2DShortCuts.useColor(this.g2d, appearance.getLineColor());
        int n4 = n3 / 2;
        this.g2d.drawOval(n - n4, n2 - n4, n3, n3);
    }

    @Override
    public void fillDisc(int n, int n2, int n3, Color color) {
        if (color.getAlphaAsFloat() != 0.0f) {
            G2DShortCuts.useColor(this.g2d, color);
            int n4 = n3 / 2;
            this.g2d.fillOval(n - n4, n2 - n4, n3, n3);
        }
    }

    @Override
    public void draw(TextEntity textEntity, int n, int n2) {
        if (textEntity != null && textEntity.isValid()) {
            Object object;
            Object object2;
            if (textEntity.isTextAntiAliased()) {
                this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                object2 = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
                if (object2 != null && (object = object2.get(RenderingHints.KEY_TEXT_ANTIALIASING)) != null) {
                    this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
                }
            } else {
                this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
            if (textEntity.isTextUseFractionalMetrics()) {
                this.g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            } else {
                this.g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            }
            this.g2d.setColor(textEntity.getTextColor());
            object2 = new TextLayout(textEntity.getText(), textEntity.getFont(), this.g2d.getFontRenderContext());
            object = ((TextLayout)object2).getBounds();
            ((TextLayout)object2).draw(this.g2d, (float)((double)(n + 1) - ((RectangularShape)object).getX()), (float)n2 + ((TextLayout)object2).getAscent());
        }
    }

    @Override
    public void draw(Icon icon, int n, int n2) {
        icon.paintIcon(new JLabel(), this.g2d, n, n2);
    }

    @Override
    public void clear(Color color) {
        AffineTransform affineTransform = this.g2d.getTransform();
        this.g2d.setTransform(this.baseTransform);
        G2DShortCuts.useColor(this.g2d, color);
        this.g2d.fillRect(0, 0, this.textureSize.width, this.textureSize.height);
        this.g2d.setTransform(affineTransform);
    }

    public TextureBufferedImage getImage() {
        return this.image;
    }
}

