/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.texture;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.scilab.forge.scirenderer.data.AbstractDataProvider;
import org.scilab.forge.scirenderer.texture.BufferedImageTextureDrawingTools;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDataProvider;
import org.scilab.forge.scirenderer.texture.TextureDrawer;

public class DrawnTextureDataProvider
extends AbstractDataProvider<Texture>
implements TextureDataProvider {
    private TextureDrawer textureDrawer;
    protected TextureDataProvider.ImageType imageType;
    BufferedImageTextureDrawingTools image;

    public DrawnTextureDataProvider(TextureDrawer textureDrawer) {
        this.textureDrawer = textureDrawer;
        this.imageType = TextureDataProvider.ImageType.RGBA_BYTE;
    }

    @Override
    public TextureDataProvider.ImageType getImageType() {
        return this.imageType;
    }

    @Override
    public boolean isRowMajorOrder() {
        return true;
    }

    public void reDraw() {
        if (this.isValid()) {
            this.image = new BufferedImageTextureDrawingTools(this.textureDrawer.getTextureSize());
            this.image.accept(this.textureDrawer);
        }
    }

    public void setTextureDrawingTools(TextureDrawer textureDrawer) {
        this.textureDrawer = textureDrawer;
        this.reDraw();
    }

    @Override
    public Dimension getTextureSize() {
        if (this.isValid()) {
            return this.textureDrawer.getTextureSize();
        }
        return new Dimension(-1, -1);
    }

    @Override
    public ByteBuffer getData() {
        if (this.isValid()) {
            if (this.image == null) {
                this.reDraw();
            }
            return this.image.getImage().getRGBABuffer();
        }
        return null;
    }

    @Override
    public ByteBuffer getSubData(int n, int n2, int n3, int n4) {
        if (this.isValid()) {
            ByteBuffer byteBuffer = this.getData();
            return byteBuffer;
        }
        return null;
    }

    @Override
    public BufferedImage getImage() {
        if (this.isValid()) {
            if (this.image == null) {
                this.reDraw();
            }
            return this.image.getImage();
        }
        return null;
    }

    @Override
    public BufferedImage getSubImage(int n, int n2, int n3, int n4) {
        if (this.isValid()) {
            BufferedImage bufferedImage = this.getImage();
            return bufferedImage.getSubimage(n, n2, n3, n4);
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return this.textureDrawer != null;
    }
}

