/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.utils.shapes.geometry;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public final class TetrahedronFactory {
    private static final int ELEMENTS_SIZE = 4;
    private static final Vector3d A = new Vector3d(1.0, 1.0, 1.0);
    private static final Vector3d B = new Vector3d(1.0, -1.0, -1.0);
    private static final Vector3d C = new Vector3d(-1.0, 1.0, -1.0);
    private static final Vector3d D = new Vector3d(-1.0, -1.0, 1.0);

    private TetrahedronFactory() {
    }

    public static DefaultGeometry createTetrahedron(Canvas canvas) {
        Vector3d vector3d = A.plus(B).times(0.5);
        Vector3d vector3d2 = A.plus(C).times(0.5);
        Vector3d vector3d3 = A.plus(D).times(0.5);
        Vector3d vector3d4 = B.plus(C).times(0.5);
        Vector3d vector3d5 = B.plus(D).times(0.5);
        Vector3d vector3d6 = C.plus(D).times(0.5);
        FloatBuffer floatBuffer = FloatBuffer.allocate(40);
        floatBuffer.rewind();
        floatBuffer.put(A.getDataAsFloatArray(4));
        floatBuffer.put(B.getDataAsFloatArray(4));
        floatBuffer.put(C.getDataAsFloatArray(4));
        floatBuffer.put(D.getDataAsFloatArray(4));
        floatBuffer.put(vector3d.getDataAsFloatArray(4));
        floatBuffer.put(vector3d2.getDataAsFloatArray(4));
        floatBuffer.put(vector3d3.getDataAsFloatArray(4));
        floatBuffer.put(vector3d4.getDataAsFloatArray(4));
        floatBuffer.put(vector3d5.getDataAsFloatArray(4));
        floatBuffer.put(vector3d6.getDataAsFloatArray(4));
        floatBuffer.rewind();
        IntBuffer intBuffer = IntBuffer.allocate(48);
        intBuffer.rewind();
        intBuffer.put(new int[]{0, 4, 5, 4, 1, 7, 5, 7, 2, 7, 5, 4, 0, 5, 6, 5, 2, 9, 6, 9, 3, 9, 6, 5, 0, 6, 4, 6, 3, 8, 4, 8, 1, 8, 4, 6, 8, 9, 7, 9, 8, 3, 7, 1, 8, 2, 7, 9});
        intBuffer.rewind();
        IntBuffer intBuffer2 = IntBuffer.allocate(48);
        intBuffer2.rewind();
        intBuffer2.put(new int[]{0, 4, 4, 1, 0, 5, 5, 2, 0, 6, 6, 3, 4, 5, 5, 6, 6, 4, 1, 7, 7, 2, 2, 9, 9, 3, 3, 8, 8, 1, 4, 7, 7, 5, 5, 9, 9, 6, 6, 8, 8, 4, 7, 9, 9, 8, 8, 7});
        intBuffer2.rewind();
        canvas.getBuffersManager().createElementsBuffer();
        ElementsBuffer elementsBuffer = canvas.getBuffersManager().createElementsBuffer();
        IndicesBuffer indicesBuffer = canvas.getBuffersManager().createIndicesBuffer();
        IndicesBuffer indicesBuffer2 = canvas.getBuffersManager().createIndicesBuffer();
        elementsBuffer.setData(floatBuffer, 4);
        indicesBuffer.setData(intBuffer);
        indicesBuffer2.setData(intBuffer2);
        DefaultGeometry defaultGeometry = new DefaultGeometry();
        defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.TRIANGLES);
        defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
        defaultGeometry.setPolygonOffsetMode(true);
        defaultGeometry.setWireIndices(indicesBuffer2);
        defaultGeometry.setIndices(indicesBuffer);
        defaultGeometry.setVertices(elementsBuffer);
        return defaultGeometry;
    }
}

