/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.builder;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.scilab.modules.graphic_objects.ScilabNativeView;
import org.scilab.modules.graphic_objects.arc.Arc;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.axis.Axis;
import org.scilab.modules.graphic_objects.fec.Fec;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicModel.GraphicModel;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.imageplot.Imageplot;
import org.scilab.modules.graphic_objects.label.Label;
import org.scilab.modules.graphic_objects.legend.Legend;
import org.scilab.modules.graphic_objects.lighting.Light;
import org.scilab.modules.graphic_objects.polyline.Polyline;
import org.scilab.modules.graphic_objects.rectangle.Rectangle;
import org.scilab.modules.graphic_objects.surface.Surface;
import org.scilab.modules.graphic_objects.textObject.Font;
import org.scilab.modules.graphic_objects.textObject.Text;
import org.scilab.modules.graphic_objects.vectfield.Champ;
import org.scilab.modules.graphic_objects.vectfield.Segs;

public final class Builder {
    public static final int createRect(int n, double d, double d2, double d3, double d4, int n2, int n3, int n4, int n5) {
        GraphicController graphicController = GraphicController.getController();
        Axes axes = (Axes)graphicController.getObjectFromId(n);
        if (d3 < 0.0 || d4 < 0.0) {
            return 0;
        }
        Integer n6 = graphicController.askObject(GraphicObject.Type.RECTANGLE, false);
        Rectangle rectangle = (Rectangle)graphicController.getObjectFromId(n6);
        rectangle.setUpperLeftPoint(new Double[]{d, d2, 0.0});
        rectangle.setHeight(d3);
        rectangle.setWidth(d4);
        rectangle.setVisible(axes.getVisible());
        rectangle.setClipBox(axes.getClipBox());
        rectangle.setClipBoxSet(axes.getClipBoxSet());
        rectangle.setClipState(axes.getClipState());
        rectangle.setMarkMode(axes.getMarkMode());
        Builder.cloneGraphicContext(n, n6);
        rectangle.setLineMode(n5 == 1);
        rectangle.setFillMode(n4 == 1);
        if (n2 != -1) {
            rectangle.setLineColor(n2);
        }
        if (n3 != -1) {
            rectangle.setBackground(n3);
        }
        graphicController.objectCreated(n6);
        return n6;
    }

    public static int cloneGraphicContext(int n, int n2) {
        GraphicController graphicController = GraphicController.getController();
        Boolean bl = false;
        Integer n3 = 0;
        Integer n4 = 0;
        Integer n5 = 0;
        Integer n6 = 0;
        Integer n7 = 0;
        Integer n8 = 0;
        Integer n9 = 0;
        Integer n10 = 0;
        Double d = 0.0;
        bl = (Boolean)graphicController.getProperty(n, 192);
        n3 = (Integer)graphicController.getProperty(n, 195);
        d = (Double)graphicController.getProperty(n, 194);
        n4 = (Integer)graphicController.getProperty(n, 193);
        n5 = (Integer)graphicController.getProperty(n, 96);
        n6 = (Integer)graphicController.getProperty(n, 202);
        n7 = (Integer)graphicController.getProperty(n, 203);
        n8 = (Integer)graphicController.getProperty(n, 199);
        n9 = (Integer)graphicController.getProperty(n, 201);
        n10 = (Integer)graphicController.getProperty(n, 200);
        graphicController.setProperty(n2, 192, bl);
        graphicController.setProperty(n2, 195, n3);
        graphicController.setProperty(n2, 194, d);
        graphicController.setProperty(n2, 193, n4);
        graphicController.setProperty(n2, 96, n5);
        graphicController.setProperty(n2, 202, n6);
        graphicController.setProperty(n2, 203, n7);
        graphicController.setProperty(n2, 199, n8);
        graphicController.setProperty(n2, 201, n9);
        graphicController.setProperty(n2, 200, n10);
        return 0;
    }

    public static int cloneFontContext(int n, int n2) {
        GraphicController graphicController = GraphicController.getController();
        Integer n3 = (Integer)graphicController.getProperty(n, 223);
        Integer n4 = (Integer)graphicController.getProperty(n, 221);
        Double d = (Double)graphicController.getProperty(n, 222);
        Boolean bl = (Boolean)graphicController.getProperty(n, 224);
        graphicController.setProperty(n2, 223, n3);
        graphicController.setProperty(n2, 221, n4);
        graphicController.setProperty(n2, 222, d);
        graphicController.setProperty(n2, 224, bl);
        return 0;
    }

    public static int createHiddenLabel(int n) {
        GraphicController graphicController = GraphicController.getController();
        Integer n2 = graphicController.askObject(GraphicObject.Type.LABEL, false);
        Label label = (Label)graphicController.getObjectFromId(n2);
        label.setHidden(true);
        label.setAutoPosition(true);
        label.setAutoRotation(true);
        Builder.cloneGraphicContext(n, n2);
        Builder.cloneFontContext(n, n2);
        graphicController.objectCreated(n2);
        graphicController.setGraphicObjectRelationship(n, n2);
        return n2;
    }

    public static void initSubWinBounds(int n) {
        GraphicController graphicController = GraphicController.getController();
        graphicController.setProperty(n, 117, false);
        graphicController.setProperty(n, 134, false);
        graphicController.setProperty(n, 151, false);
    }

    public static void reinitSubWin(int n) {
        GraphicController graphicController = GraphicController.getController();
        Integer n2 = 0;
        for (Integer n3 : (Integer[])graphicController.getProperty(n, 22)) {
            GraphicModel.getModel().deleteObject(n3);
        }
        n2 = Builder.createHiddenLabel(n);
        graphicController.setProperty(n, 163, n2);
        n2 = Builder.createHiddenLabel(n);
        graphicController.setProperty(n, 115, n2);
        n2 = Builder.createHiddenLabel(n);
        graphicController.setProperty(n, 132, n2);
        n2 = Builder.createHiddenLabel(n);
        graphicController.setProperty(n, 149, n2);
        graphicController.setProperty(n, 116, 0);
        graphicController.setProperty(n, 133, 4);
        graphicController.setProperty(n, 27, true);
        graphicController.setProperty(n, 183, true);
        Integer n4 = GraphicModel.getAxesModel().getIdentifier();
        Axes axes = (Axes)graphicController.getObjectFromId(n4);
        graphicController.setProperty(n, 167, axes.getView());
        graphicController.setProperty(n, 170, axes.getRotationAngles());
        graphicController.setProperty(n, 171, axes.getRotationAngles3d());
    }

    public static boolean isAxesRedrawing(int n) {
        GraphicController graphicController = GraphicController.getController();
        Axes axes = (Axes)graphicController.getObjectFromId(n);
        if (axes.getAutoClear().booleanValue()) {
            Builder.reinitSubWin(n);
            return true;
        }
        return false;
    }

    public static int createLabel(int n, int n2) {
        GraphicController graphicController = GraphicController.getController();
        Double[] doubleArray = new Double[]{1.0, 1.0, 1.0};
        Integer n3 = (Integer)graphicController.getProperty(n, 29);
        if (n3 != 1) {
            return 1;
        }
        Integer n4 = GraphicModel.getAxesModel().getIdentifier();
        Integer n5 = (Integer)graphicController.getProperty(n4, n2);
        Integer n6 = graphicController.cloneObject(n5);
        graphicController.setProperty(n6, 80, doubleArray);
        Boolean bl = (Boolean)graphicController.getProperty(n5, 231);
        graphicController.setProperty(n6, 231, bl);
        graphicController.setProperty(n, n2, n6);
        graphicController.setGraphicObjectRelationship(n, n6);
        return 0;
    }

    public static final int createFigureFromModel() {
        GraphicController graphicController = GraphicController.getController();
        return graphicController.cloneObject(GraphicModel.getFigureModel().getIdentifier());
    }

    public static final int cloneAxesModel(int n) {
        GraphicController graphicController = GraphicController.getController();
        Integer n2 = graphicController.cloneObject(GraphicModel.getAxesModel().getIdentifier());
        Builder.createLabel(n2, 115);
        Builder.createLabel(n2, 132);
        Builder.createLabel(n2, 149);
        Builder.createLabel(n2, 163);
        graphicController.setGraphicObjectRelationship(n, n2);
        graphicController.setProperty(n, 35, n2);
        ScilabNativeView.ScilabNativeView__setCurrentSubWin(n2);
        ScilabNativeView.ScilabNativeView__setCurrentObject(n2);
        return n2;
    }

    public static final void cloneMenus(int n, int n2) {
        GraphicController graphicController = GraphicController.getController();
        GraphicObject graphicObject = graphicController.getObjectFromId(n);
        Integer[] integerArray = graphicObject.getChildren();
        for (int i = integerArray.length - 1; i >= 0; --i) {
            GraphicObject graphicObject2 = graphicController.getObjectFromId(integerArray[i]);
            if (graphicObject2.getType() != 20) continue;
            Integer n3 = graphicController.cloneObject(integerArray[i]);
            graphicController.setGraphicObjectRelationship(n2, n3);
            Builder.cloneMenus(integerArray[i], n3);
        }
    }

    public static final int createFigure(boolean bl, int n, int n2, boolean bl2, boolean bl3, int n3) {
        GraphicController graphicController = GraphicController.getController();
        Integer n4 = GraphicModel.getFigureModel().getIdentifier();
        Integer n5 = graphicController.cloneObject(n4, false);
        Figure figure = (Figure)graphicController.getObjectFromId(n5);
        figure.setDockable(bl);
        figure.setMenubar(n);
        figure.setToolbar(n2);
        figure.setVisible(bl3);
        figure.setDefaultAxes(bl2);
        figure.setAntialiasing(n3);
        graphicController.objectCreated(n5);
        ScilabNativeView.ScilabNativeView__setCurrentFigure(n5);
        if (n == Figure.BarType.FIGURE.ordinal()) {
            Builder.cloneMenus(n4, n5);
        }
        if (bl2) {
            Builder.cloneAxesModel(n5);
        }
        return n5;
    }

    public static final int createNewFigureWithAxes() {
        GraphicController graphicController = GraphicController.getController();
        Integer n = GraphicModel.getFigureModel().getIdentifier();
        Integer n2 = Builder.createFigureFromModel();
        Builder.cloneMenus(n, n2);
        graphicController.setProperty(n2, 88, 0);
        Builder.cloneAxesModel(n2);
        ScilabNativeView.ScilabNativeView__setCurrentFigure(n2);
        Integer[] integerArray = (Integer[])graphicController.getProperty(n, 85);
        graphicController.setProperty(n2, 85, integerArray);
        graphicController.setProperty(n2, 79, true);
        return n2;
    }

    public static final int createSubWin(int n) {
        return Builder.cloneAxesModel(n);
    }

    public static final int createText(int n, String[] stringArray, int n2, int n3, double d, double d2, boolean bl, double[] dArray, int n4, int n5, boolean bl2, int n6, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n7) {
        GraphicController graphicController = GraphicController.getController();
        int n8 = graphicController.askObject(GraphicObject.Type.TEXT, false);
        Axes axes = (Axes)graphicController.getObjectFromId(n);
        Text text = (Text)graphicController.getObjectFromId(n8);
        text.setClipBox(axes.getClipBox());
        text.setClipBoxSet(axes.getClipBoxSet());
        text.setClipState(axes.getClipState());
        Integer[] integerArray = new Integer[]{n2, n3};
        text.setTextArrayDimensions(integerArray);
        text.setTextStrings(stringArray);
        Double[] doubleArray = new Double[]{d, d2, 0.0};
        text.setPosition(doubleArray);
        Double[] doubleArray2 = new Double[2];
        text.setTextBoxMode(n4);
        text.setAutoDimensioning(bl);
        if (!bl || n4 != 0) {
            doubleArray2[0] = dArray[0];
            doubleArray2[1] = dArray[1];
        } else {
            doubleArray2[0] = 0.0;
            doubleArray2[1] = 0.0;
        }
        text.setTextBox(doubleArray2);
        int n9 = n7 - 1;
        if (n9 < 0 || n9 > 2) {
            n9 = 0;
        }
        text.setAlignment(n9);
        Builder.cloneGraphicContext(n, n8);
        Builder.cloneFontContext(n, n8);
        text.setBox(bl4);
        text.setLineMode(bl5);
        text.setFillMode(bl6);
        if (bl2) {
            text.setLineColor(n5);
        }
        if (bl3) {
            text.setBackground(n6);
        }
        text.setVisible(axes.getVisible());
        graphicController.objectCreated(n8);
        return n8;
    }

    public static final int createArc(int n, double d, double d2, double d3, double d4, double d5, double d6, int n2, boolean bl, int n3, boolean bl2, boolean bl3, boolean bl4) {
        GraphicController graphicController = GraphicController.getController();
        int n4 = graphicController.askObject(GraphicObject.Type.ARC, false);
        Axes axes = (Axes)graphicController.getObjectFromId(n);
        Arc arc = (Arc)graphicController.getObjectFromId(n4);
        arc.setVisible(false);
        Double[] doubleArray = new Double[]{d, d2, 0.0};
        arc.setUpperLeftPoint(doubleArray);
        arc.setHeight(d3);
        arc.setWidth(d4);
        arc.setStartAngle(d5);
        arc.setEndAngle(d6);
        arc.setArcDrawingMethod(axes.getArcDrawingMethod());
        arc.setClipBox(axes.getClipBox());
        arc.setClipBoxSet(axes.getClipBoxSet());
        arc.setClipState(axes.getClipState());
        Builder.cloneGraphicContext(n, n4);
        arc.setLineMode(bl4);
        arc.setFillMode(bl3);
        if (bl) {
            arc.setLineColor(n2);
        }
        if (bl2) {
            arc.setBackground(n3);
        }
        arc.setVisible(axes.getVisible());
        graphicController.objectCreated(n4);
        graphicController.setGraphicObjectRelationship(n, n4);
        return n4;
    }

    public static final int createAxis(int n, int n2, int n3, double[] dArray, double[] dArray2, int n4, String string, int n5, int n6, int n7, boolean bl) {
        GraphicController graphicController = GraphicController.getController();
        int n8 = graphicController.askObject(GraphicObject.Type.AXIS, false);
        Axes axes = (Axes)graphicController.getObjectFromId(n);
        Axis axis = (Axis)graphicController.getObjectFromId(n8);
        axis.setClipBox(axes.getClipBox());
        axis.setClipBoxSet(false);
        axis.setTicksDirection(n2);
        axis.setTicksStyle(n3);
        axis.setXTicksCoords(Builder.toDouble(dArray));
        axis.setYTicksCoords(Builder.toDouble(dArray2));
        if (string != null && !string.equals("")) {
            axis.setFormatn(string);
        }
        axis.setSubticks(n4);
        axis.setTicksSegment(bl);
        Builder.cloneGraphicContext(n, n8);
        Builder.cloneFontContext(n, n8);
        Font font = axis.getFont();
        if (n5 == -1) {
            font.setSize(axes.getFontSize());
        } else {
            font.setSize(new Double(n5));
        }
        if (n6 == -1) {
            font.setColor(axes.getFontColor());
        } else {
            font.setColor(n6);
        }
        font.setStyle(axes.getFontStyle());
        axis.setTicksColor(n7);
        graphicController.objectCreated(n8);
        graphicController.setGraphicObjectRelationship(n, n8);
        return n8;
    }

    public static int createCompound(int n, int[] nArray) {
        GraphicController graphicController = GraphicController.getController();
        int n2 = graphicController.askObject(GraphicObject.Type.COMPOUND);
        GraphicObject graphicObject = graphicController.getObjectFromId(n);
        for (int i = 0; i < nArray.length; ++i) {
            graphicController.setGraphicObjectRelationship(n2, nArray[i]);
        }
        graphicController.setGraphicObjectRelationship(n, n2);
        graphicController.setProperty(n2, 27, graphicObject.getVisible());
        return n2;
    }

    public static int createCompoundSeq(int n, int n2) {
        GraphicController graphicController = GraphicController.getController();
        int n3 = graphicController.askObject(GraphicObject.Type.COMPOUND);
        GraphicObject graphicObject = graphicController.getObjectFromId(n);
        Integer[] integerArray = graphicObject.getChildren();
        for (int i = 0; i < n2; ++i) {
            graphicController.setGraphicObjectRelationship(n3, integerArray[n2 - i - 1]);
        }
        graphicController.setGraphicObjectRelationship(n, n3);
        Figure figure = (Figure)graphicController.getObjectFromId(graphicObject.getParentFigure());
        graphicController.setProperty(n3, 27, figure.getVisible());
        return n3;
    }

    public static int createFec(int n, double[] dArray, int[] nArray, int[] nArray2, boolean bl) {
        GraphicController graphicController = GraphicController.getController();
        int n2 = graphicController.askObject(GraphicObject.Type.FEC, false);
        Axes axes = (Axes)graphicController.getObjectFromId(n);
        Fec fec = (Fec)graphicController.getObjectFromId(n2);
        fec.setZBounds(Builder.toDouble(dArray));
        fec.setColorRange(Builder.toInteger(nArray));
        fec.setOutsideColor(Builder.toInteger(nArray2));
        fec.setVisible(axes.getVisible());
        fec.setClipBox(axes.getClipBox());
        fec.setClipBoxSet(axes.getClipBoxSet());
        fec.setClipState(axes.getClipState());
        Builder.cloneGraphicContext(n, n2);
        fec.setLineMode(bl);
        graphicController.objectCreated(n2);
        return n2;
    }

    public static int createGrayplot(int n, int n2, double[] dArray, int n3, int n4) {
        int[] nArray = new int[]{10, 13, 13};
        GraphicController graphicController = GraphicController.getController();
        int n5 = graphicController.askObject(GraphicObject.getTypeFromName(nArray[n2]), false);
        Axes axes = (Axes)graphicController.getObjectFromId(n);
        Imageplot imageplot = (Imageplot)graphicController.getObjectFromId(n5);
        if (n2 == 2) {
            Double[] doubleArray = new Double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                doubleArray[i] = dArray[i];
            }
            imageplot.setTranslate(doubleArray);
            Double[] doubleArray2 = new Double[]{(dArray[2] - dArray[0]) / ((double)n4 - 1.0), (dArray[3] - dArray[1]) / ((double)n3 - 1.0)};
            imageplot.setScale(doubleArray2);
        }
        imageplot.setVisible(axes.getVisible());
        imageplot.setClipBox(axes.getClipBox());
        imageplot.setClipBoxSet(axes.getClipBoxSet());
        imageplot.setClipState(axes.getClipState());
        Builder.cloneGraphicContext(n, n5);
        graphicController.objectCreated(n5);
        return n5;
    }

    public static int createPolyline(int n, boolean bl, int n2, int n3, boolean bl2, int[] nArray, int n4, boolean bl3, int n5, boolean bl4, int n6, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        GraphicController graphicController = GraphicController.getController();
        int n7 = graphicController.askObject(GraphicObject.Type.POLYLINE, false);
        Axes axes = (Axes)graphicController.getObjectFromId(n);
        Polyline polyline = (Polyline)graphicController.getObjectFromId(n7);
        polyline.setVisible(false);
        polyline.setClipBox(axes.getClipBox());
        polyline.setClipBoxSet(axes.getClipBoxSet());
        polyline.setClipState(axes.getClipState());
        polyline.setClosed(bl);
        polyline.setPolylineStyle(n2);
        Builder.cloneGraphicContext(n, n7);
        polyline.setMarkMode(bl8);
        polyline.setLineMode(bl6);
        polyline.setFillMode(bl7);
        polyline.setInterpColorMode(bl9);
        if (bl2) {
            polyline.setLineColor(n3);
        }
        if (nArray.length != 0) {
            if (bl9) {
                Integer[] integerArray = new Integer[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    integerArray[i] = nArray[i];
                }
                polyline.setInterpColorVector(integerArray);
            } else {
                polyline.setBackground(nArray[0]);
            }
        }
        if (bl3) {
            polyline.setMarkStyle(n4);
        }
        if (bl4) {
            polyline.setMarkForeground(n5);
        }
        if (bl5) {
            polyline.setMarkBackground(n6);
        }
        polyline.setVisible(true);
        graphicController.objectCreated(n7);
        return n7;
    }

    public static int createLegend(int n, String[] stringArray, int[] nArray) {
        GraphicController graphicController = GraphicController.getController();
        Axes axes = (Axes)graphicController.getObjectFromId(n);
        if (axes.getHasLegendChild().booleanValue()) {
            graphicController.removeRelationShipAndDelete(axes.getLegendChild());
        }
        int n2 = graphicController.askObject(GraphicObject.Type.LEGEND, false);
        Legend legend = (Legend)graphicController.getObjectFromId(n2);
        legend.setParent(n);
        legend.setVisible(axes.getVisible());
        int n3 = nArray.length;
        Integer[] integerArray = new Integer[]{n3, 1};
        legend.setTextArrayDimensions(integerArray);
        legend.setTextStrings(stringArray);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n3; ++i) {
            arrayList.add(nArray[i]);
        }
        legend.setLinks(arrayList);
        legend.setClipBoxSet(false);
        legend.setClipState(0);
        legend.setClipBox(axes.getClipBox());
        Builder.cloneGraphicContext(n, n2);
        Builder.cloneFontContext(n, n2);
        legend.setFillMode(true);
        graphicController.objectCreated(n2);
        legend.setParent(0);
        graphicController.setGraphicObjectRelationship(n, n2);
        return n2;
    }

    public static int createSegs(int n, double[] dArray, double[] dArray2, double[] dArray3, boolean bl, int[] nArray, double d) {
        int n2;
        GraphicController graphicController = GraphicController.getController();
        Axes axes = (Axes)graphicController.getObjectFromId(n);
        int n3 = graphicController.askObject(GraphicObject.Type.SEGS, false);
        Segs segs = (Segs)graphicController.getObjectFromId(n3);
        segs.setVisible(axes.getVisible());
        segs.setClipBox(axes.getClipBox());
        segs.setClipBoxSet(axes.getClipBoxSet());
        segs.setClipState(axes.getClipState());
        int n4 = dArray.length / 2;
        segs.setNumberArrows(n4);
        segs.setArrowSize(d);
        Double[] doubleArray = new Double[3 * n4];
        for (n2 = 0; n2 < n4; ++n2) {
            doubleArray[3 * n2] = dArray[2 * n2];
            doubleArray[3 * n2 + 1] = dArray2[2 * n2];
            doubleArray[3 * n2 + 2] = bl ? Double.valueOf(dArray3[2 * n2]) : Double.valueOf(0.0);
        }
        segs.setBase(doubleArray);
        for (n2 = 0; n2 < n4; ++n2) {
            doubleArray[3 * n2] = dArray[2 * n2 + 1];
            doubleArray[3 * n2 + 1] = dArray2[2 * n2 + 1];
            doubleArray[3 * n2 + 2] = bl ? Double.valueOf(dArray3[2 * n2 + 1]) : Double.valueOf(0.0);
        }
        segs.setDirection(doubleArray);
        segs.setColors(Builder.toInteger(nArray));
        Builder.cloneGraphicContext(n, n3);
        graphicController.objectCreated(n3);
        graphicController.setGraphicObjectRelationship(n, n3);
        return n3;
    }

    public static int createChamp(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, boolean bl) {
        int n2;
        GraphicController graphicController = GraphicController.getController();
        Axes axes = (Axes)graphicController.getObjectFromId(n);
        int n3 = graphicController.askObject(GraphicObject.Type.CHAMP, false);
        Champ champ = (Champ)graphicController.getObjectFromId(n3);
        champ.setVisible(axes.getVisible());
        champ.setClipBox(axes.getClipBox());
        champ.setClipBoxSet(axes.getClipBoxSet());
        champ.setClipState(axes.getClipState());
        int n4 = dArray.length * dArray2.length;
        champ.setNumberArrows(n4);
        Integer[] integerArray = new Integer[]{dArray.length, dArray2.length};
        champ.setDimensions(integerArray);
        champ.setArrowSize(d);
        Double[] doubleArray = new Double[3 * n4];
        Double[] doubleArray2 = new Double[dArray.length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            doubleArray2[n2] = dArray[n2];
        }
        champ.setBaseX(doubleArray2);
        doubleArray2 = new Double[dArray2.length];
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            doubleArray2[n2] = dArray2[n2];
        }
        champ.setBaseY(doubleArray2);
        for (n2 = 0; n2 < n4; ++n2) {
            doubleArray[3 * n2] = dArray3[n2];
            doubleArray[3 * n2 + 1] = dArray4[n2];
            doubleArray[3 * n2 + 2] = 0.0;
        }
        champ.setDirection(doubleArray);
        champ.setColored(bl);
        Builder.cloneGraphicContext(n, n3);
        graphicController.objectCreated(n3);
        graphicController.setGraphicObjectRelationship(n, n3);
        return n3;
    }

    public static int createSurface(int n, int n2, int n3, int n4) {
        GraphicController graphicController = GraphicController.getController();
        Axes axes = (Axes)graphicController.getObjectFromId(n);
        int n5 = graphicController.askObject(GraphicObject.getTypeFromName(n2), false);
        Surface surface = (Surface)graphicController.getObjectFromId(n5);
        surface.setVisible(axes.getVisible());
        surface.setClipBox(axes.getClipBox());
        surface.setClipBoxSet(axes.getClipBoxSet());
        surface.setClipState(axes.getClipState());
        surface.setColorFlag(n3);
        surface.setColorMode(n4);
        surface.setHiddenColor(axes.getHiddenColor());
        surface.setSurfaceMode(true);
        Builder.cloneGraphicContext(n, n5);
        graphicController.objectCreated(n5);
        graphicController.setGraphicObjectRelationship(n, n5);
        return n5;
    }

    public static void initSubWinTo3d(int n, String string, boolean bl, int[] nArray, double d, double d2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        Number[] numberArray;
        Constable constable;
        Object[] objectArray;
        Object object;
        GraphicController graphicController = GraphicController.getController();
        graphicController.setProperty(n, 167, 1);
        if (bl) {
            object = new StringTokenizer(string, "@");
            int n2 = ((StringTokenizer)object).countTokens();
            if (n2 > 0) {
                objectArray = new String[]{((StringTokenizer)object).nextToken()};
                constable = (Integer)graphicController.getProperty(n, 115);
                numberArray = new Integer[]{1, 1};
                graphicController.setProperty((Integer)constable, 258, numberArray);
                graphicController.setProperty((Integer)constable, 259, objectArray);
            }
            if (n2 > 1) {
                objectArray = new String[]{((StringTokenizer)object).nextToken()};
                constable = (Integer)graphicController.getProperty(n, 132);
                numberArray = new Integer[]{1, 1};
                graphicController.setProperty((Integer)constable, 258, numberArray);
                graphicController.setProperty((Integer)constable, 259, objectArray);
            }
            if (n2 > 2) {
                objectArray = new String[]{((StringTokenizer)object).nextToken()};
                constable = (Integer)graphicController.getProperty(n, 149);
                numberArray = new Integer[]{1, 1};
                graphicController.setProperty((Integer)constable, 258, numberArray);
                graphicController.setProperty((Integer)constable, 259, objectArray);
            }
        }
        graphicController.setProperty(n, 117, false);
        graphicController.setProperty(n, 134, false);
        graphicController.setProperty(n, 151, false);
        object = (Boolean)graphicController.getProperty(n, 183);
        if (!((Boolean)object).booleanValue() || nArray[2] != 0 && nArray[2] != 1) {
            if (nArray[2] == 0 || nArray[2] == 1) {
                if (((Boolean)object).booleanValue()) {
                    graphicController.setProperty(n, 110, false);
                    graphicController.setProperty(n, 127, false);
                    graphicController.setProperty(n, 144, false);
                    graphicController.setProperty(n, 172, 0);
                    Integer n3 = 0;
                    n3 = (Integer)graphicController.getProperty(n, 115);
                    graphicController.setProperty(n3, 27, false);
                    n3 = (Integer)graphicController.getProperty(n, 132);
                    graphicController.setProperty(n3, 27, false);
                    n3 = (Integer)graphicController.getProperty(n, 149);
                    graphicController.setProperty(n3, 27, false);
                }
            } else if (nArray[2] == 2) {
                graphicController.setProperty(n, 110, false);
                graphicController.setProperty(n, 127, false);
                graphicController.setProperty(n, 144, false);
                graphicController.setProperty(n, 172, 2);
                Integer n4 = 0;
                n4 = (Integer)graphicController.getProperty(n, 115);
                graphicController.setProperty(n4, 27, false);
                n4 = (Integer)graphicController.getProperty(n, 132);
                graphicController.setProperty(n4, 27, false);
                n4 = (Integer)graphicController.getProperty(n, 149);
                graphicController.setProperty(n4, 27, false);
            } else if (nArray[2] == 3) {
                graphicController.setProperty(n, 110, false);
                graphicController.setProperty(n, 127, false);
                graphicController.setProperty(n, 144, false);
                graphicController.setProperty(n, 172, 1);
                Integer n5 = 0;
                n5 = (Integer)graphicController.getProperty(n, 115);
                graphicController.setProperty(n5, 27, true);
                n5 = (Integer)graphicController.getProperty(n, 132);
                graphicController.setProperty(n5, 27, true);
                n5 = (Integer)graphicController.getProperty(n, 149);
                graphicController.setProperty(n5, 27, true);
            } else if (nArray[2] == 4) {
                graphicController.setProperty(n, 110, true);
                graphicController.setProperty(n, 127, true);
                graphicController.setProperty(n, 144, true);
                graphicController.setProperty(n, 172, 1);
                Integer n6 = 0;
                n6 = (Integer)graphicController.getProperty(n, 115);
                graphicController.setProperty(n6, 27, true);
                n6 = (Integer)graphicController.getProperty(n, 132);
                graphicController.setProperty(n6, 27, true);
                n6 = (Integer)graphicController.getProperty(n, 149);
                graphicController.setProperty(n6, 27, true);
            }
        }
        Double[] doubleArray = new Double[]{d, d2};
        graphicController.setProperty(n, 170, doubleArray);
        objectArray = (Double[])graphicController.getProperty(n, 177);
        constable = (Boolean)graphicController.getProperty(n, 181);
        numberArray = new Double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        if (((Boolean)constable).booleanValue()) {
            switch (nArray[1]) {
                case 0: {
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    numberArray[0] = dArray[0];
                    numberArray[1] = dArray[1];
                    numberArray[2] = dArray[2];
                    numberArray[3] = dArray[3];
                    numberArray[4] = dArray[4];
                    numberArray[5] = dArray[5];
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    double[] dArray5 = Builder.getDrect(dArray2, (Double)numberArray[0], (Double)numberArray[1], (Double)objectArray[0], (Double)objectArray[1]);
                    numberArray[0] = dArray5[0];
                    numberArray[1] = dArray5[1];
                    dArray5 = Builder.getDrect(dArray3, (Double)numberArray[2], (Double)numberArray[3], (Double)objectArray[2], (Double)objectArray[3]);
                    numberArray[2] = dArray5[0];
                    numberArray[3] = dArray5[1];
                    dArray5 = Builder.getDrect(dArray4, (Double)numberArray[4], (Double)numberArray[5], (Double)objectArray[4], (Double)objectArray[5]);
                    numberArray[4] = dArray5[0];
                    numberArray[5] = dArray5[1];
                }
            }
            if (!((Boolean)object).booleanValue()) {
                numberArray[0] = Math.min((Double)objectArray[0], (Double)numberArray[0]);
                numberArray[1] = Math.max((Double)objectArray[1], (Double)numberArray[1]);
                numberArray[2] = Math.min((Double)objectArray[2], (Double)numberArray[2]);
                numberArray[3] = Math.max((Double)objectArray[3], (Double)numberArray[3]);
                numberArray[4] = Math.min((Double)objectArray[4], (Double)numberArray[4]);
                numberArray[5] = Math.max((Double)objectArray[5], (Double)numberArray[5]);
            }
            if (nArray[1] != 0) {
                graphicController.setProperty(n, 177, numberArray);
            }
        }
        if (nArray[1] != 0) {
            boolean bl2 = nArray[1] == 3 || nArray[1] == 4 || nArray[1] == 5 || nArray[1] == 6;
            graphicController.setProperty(n, 168, bl2);
        }
    }

    private static double[] getDrect(double[] dArray, double d, double d2, double d3, double d4) {
        double d5 = Double.NEGATIVE_INFINITY;
        double d6 = Double.POSITIVE_INFINITY;
        boolean bl = true;
        for (int i = 0; i < dArray.length; ++i) {
            Double d7 = dArray[i];
            if (d7.isInfinite() || d7.isNaN()) continue;
            d6 = Math.min(d6, d7);
            d5 = Math.max(d5, d7);
            bl = false;
        }
        if (bl) {
            d6 = d3;
            d5 = d4;
        }
        return new double[]{d6, d5};
    }

    private static boolean isValidType(int n) {
        return n >= 0 && n <= 1;
    }

    private static boolean isValidColor(double[] dArray) {
        return dArray[0] >= 0.0 && dArray[0] <= 1.0 && dArray[1] >= 0.0 && dArray[1] <= 1.0 && dArray[2] >= 0.0 && dArray[2] <= 1.0;
    }

    public static int createLight(int n, int n2, boolean bl, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        GraphicController graphicController = GraphicController.getController();
        int n3 = graphicController.askObject(GraphicObject.Type.LIGHT, false);
        Light light = (Light)graphicController.getObjectFromId(n3);
        light.setVisible(bl);
        if (Builder.isValidType(n2)) {
            light.setLightType(Light.LightType.intToEnum(n2));
        }
        if (dArray.length == 3) {
            light.setPosition(Builder.toDouble(dArray));
        }
        if (dArray2.length == 3) {
            light.setDirection(Builder.toDouble(dArray2));
        }
        if (dArray3.length == 3 && Builder.isValidColor(dArray3)) {
            light.setAmbientColor(Builder.toDouble(dArray3));
        }
        if (dArray4.length == 3 && Builder.isValidColor(dArray4)) {
            light.setDiffuseColor(Builder.toDouble(dArray4));
        }
        if (dArray5.length == 3 && Builder.isValidColor(dArray5)) {
            light.setSpecularColor(Builder.toDouble(dArray5));
        }
        graphicController.objectCreated(n3);
        graphicController.setGraphicObjectRelationship(n, n3);
        return n3;
    }

    private static Double[] toDouble(double[] dArray) {
        Double[] doubleArray = new Double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            doubleArray[i] = dArray[i];
        }
        return doubleArray;
    }

    private static Integer[] toInteger(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }
}

