/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.rectangle;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.utils.Utils;

public class RectangleDecomposer {
    private static final int NUMBER_VERTICES = 4;
    private static final int[] triangleIndices = new int[]{0, 1, 3, 0, 3, 2};
    private static final int[] lineIndices = new int[]{0, 1, 1, 3, 3, 2, 2, 0};

    public static int getDataSize() {
        return 4;
    }

    public static int getIndicesSize() {
        return triangleIndices.length;
    }

    public static int getWireIndicesSize() {
        return lineIndices.length;
    }

    public static void fillVertices(FloatBuffer floatBuffer, Integer n, int n2, int n3, double[] dArray, double[] dArray2, int n4) {
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        Double[] doubleArray = (Double[])GraphicController.getController().getProperty(n, 104);
        Double d = (Double)GraphicController.getController().getProperty(n, 105);
        Double d2 = (Double)GraphicController.getController().getProperty(n, 106);
        dArray3[0] = doubleArray[0];
        dArray3[1] = doubleArray[0] + d;
        dArray4[0] = doubleArray[1] - d2;
        dArray4[1] = doubleArray[1];
        double d3 = doubleArray[2];
        if ((n3 & 1) != 0) {
            if ((n4 & 1) != 0) {
                dArray3[0] = Math.log10(dArray3[0]);
                dArray3[1] = Math.log10(dArray3[1]);
            }
            dArray3[0] = dArray3[0] * dArray[0] + dArray2[0];
            dArray3[1] = dArray3[1] * dArray[0] + dArray2[0];
            floatBuffer.put(0, (float)dArray3[0]);
            floatBuffer.put(n2, (float)dArray3[1]);
            floatBuffer.put(2 * n2, (float)dArray3[0]);
            floatBuffer.put(3 * n2, (float)dArray3[1]);
        }
        if ((n3 & 2) != 0) {
            if ((n4 & 2) != 0) {
                dArray4[0] = Math.log10(dArray4[0]);
                dArray4[1] = Math.log10(dArray4[1]);
            }
            dArray4[0] = dArray4[0] * dArray[1] + dArray2[1];
            dArray4[1] = dArray4[1] * dArray[1] + dArray2[1];
            floatBuffer.put(1, (float)dArray4[0]);
            floatBuffer.put(n2 + 1, (float)dArray4[0]);
            floatBuffer.put(2 * n2 + 1, (float)dArray4[1]);
            floatBuffer.put(3 * n2 + 1, (float)dArray4[1]);
        }
        if ((n3 & 4) != 0) {
            if ((n4 & 4) != 0) {
                d3 = Math.log10(d3);
            }
            d3 = d3 * dArray[2] + dArray2[2];
            floatBuffer.put(2, (float)d3);
            floatBuffer.put(n2 + 2, (float)d3);
            floatBuffer.put(2 * n2 + 2, (float)d3);
            floatBuffer.put(3 * n2 + 2, (float)d3);
        }
        if (n2 == 4 && (n3 & 8) != 0) {
            floatBuffer.put(3, 1.0f);
            floatBuffer.put(n2 + 3, 1.0f);
            floatBuffer.put(2 * n2 + 3, 1.0f);
            floatBuffer.put(3 * n2 + 3, 1.0f);
        }
    }

    public static int fillIndices(IntBuffer intBuffer, Integer n, int n2) {
        boolean bl = false;
        Double[] doubleArray = (Double[])GraphicController.getController().getProperty(n, 104);
        Double d = (Double)GraphicController.getController().getProperty(n, 105);
        Double d2 = (Double)GraphicController.getController().getProperty(n, 106);
        if (Utils.isValid(doubleArray[0], doubleArray[1], doubleArray[2]) && Utils.isValid(d) && Utils.isValid(d2)) {
            bl = true;
        }
        if (n2 != 0) {
            boolean bl2 = bl = bl && Utils.isLogValid(doubleArray[0], doubleArray[1] - d2, doubleArray[2], n2);
        }
        if (bl) {
            intBuffer.put(triangleIndices);
            return triangleIndices.length;
        }
        return 0;
    }

    public static int fillWireIndices(IntBuffer intBuffer, Integer n, int n2) {
        boolean bl = false;
        Double[] doubleArray = (Double[])GraphicController.getController().getProperty(n, 104);
        Double d = (Double)GraphicController.getController().getProperty(n, 105);
        Double d2 = (Double)GraphicController.getController().getProperty(n, 106);
        if (Utils.isValid(doubleArray[0], doubleArray[1], doubleArray[2]) && Utils.isValid(d) && Utils.isValid(d2)) {
            bl = true;
        }
        if (n2 != 0) {
            boolean bl2 = bl = bl && Utils.isLogValid(doubleArray[0], doubleArray[1] - d2, doubleArray[2], n2);
        }
        if (bl) {
            intBuffer.put(lineIndices);
            return lineIndices.length;
        }
        return 0;
    }
}

